.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)getty.8	6.5 (Berkeley) 11/17/87
.\"
.TH GETTY 8  "November 17, 1987"
.UC 4
.SH NAME
getty  \- set terminal mode
.SH SYNOPSIS
.B /etc/getty
[ type [ tty ] ]
.SH DESCRIPTION
.I Getty
is usually invoked by
.IR  init (8)
to open and initialize the tty line, read a login name, and invoke
.IR login (1).
.I getty
attempts to adapt the system to the speed and type of terminal
being used.
.PP
The argument
.I tty
is the special device file in /dev to open for the terminal (e.g., ``ttyh0'').
If there is no argument or the argument is
``\-'', the tty line is assumed to be open as file descriptor 0.
.PP
The
.I type
argument can be used to make
.I getty
treat the terminal line specially.
This argument is used as an index into the
.IR gettytab (5)
database, to determine the characteristics of the line.
If there is no argument, or there is no such table, the
.B default
table is used.
If there is no
.B /etc/gettytab
a set of system defaults is used.
If indicated by the table located,
.I getty
will clear the terminal screen,
print a banner heading,
and prompt for a login name.
Usually either the banner or the login prompt will include
the system hostname.
Then the user's name is read, a character at a time.
If a null character is received, it is assumed to be the result
of the user pushing the `break' (`interrupt') key.
The speed is usually then
changed and the `login:' is typed again;
a second `break' changes the speed again and the `login:'
is typed once more.
Successive `break' characters cycle through the
same standard set of speeds.
.PP
The user's name is terminated by a new-line or
carriage-return character.
The latter results in the system being set to
treat carriage returns appropriately (see
.IR  tty (4)).
.PP
The user's name is scanned to see if
it contains any lower-case alphabetic characters; if not,
and if the name is nonempty, the
system is told to map any future upper-case characters
into the corresponding lower-case characters.
.PP
Finally,
.I login
is called with the user's name as an argument.
.PP
Most of the default actions of
.I getty
can be circumvented, or modified, by a suitable
.I gettytab
table.
.PP
.I Getty
can be set to timeout after some interval,
which will cause dial up lines to hang up
if the login name is not entered reasonably quickly.
.SH DIAGNOSTICS
\fIttyxx\fR\|\fB: No such device or address\fR.
\fIttyxx\fR\|\fB: No such file or address\fR.
A terminal which is turned
on in the \fIttys\fR file cannot be opened, likely because the requisite
lines are either not configured into the system, the associated device
was not attached during boot-time system configuration,
or the special file in /dev does not exist.
.SH FILES
/etc/gettytab
.SH "SEE ALSO"
gettytab(5), init(8), login(1), ioctl(2), tty(4), ttys(5)
