.\" Copyright (c) 1987 Regents of the University of California.
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms are permitted
.\" provided that the above copyright notice and this paragraph are
.\" duplicated in all such forms and that any documentation,
.\" advertising materials, and other materials related to such
.\" distribution and use acknowledge that the software was developed
.\" by the University of California, Berkeley.  The name of the
.\" University may not be used to endorse or promote products derived
.\" from this software without specific prior written permission.
.\" THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
.\" IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
.\" WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
.\"
.\"	@(#)fstat.8	5.4 (Berkeley) 7/9/88
.\"
.TH FSTAT 8 "July 9, 1988"
.UC 4
.SH NAME
fstat \- file status
.SH SYNOPSIS
.B fstat
[
.B \-u
user ] [
.B \-p
pid ] [
.B filename... 
]
.SH DESCRIPTION
.I Fstat
identifies open files.
A file is considered open if a process has it open,
if it is the working directory for a process,
or if it is an active pure text file.
If no options are specified,
.I fstat
reports on all open files.
.PP
Options:
.TP 6
.B  \-u
Report all files open by a specified user.
.TP 6
.B  \-p
Report all files open by a specified process id.
.TP 6
.B filename...
Restrict reports to the specified files.
If the file is a block special file,
.I fstat
additionally reports on any open files on that device,
treating it as a mounted file system.  
.PP
The following fields are printed
.TP 6
.B  USER
The username of the owner of the process.
.TP 6
.B CMD
The command name of the process.
.TP 6
.B PID
The process id.
.TP 6
.B FD
The file number in the per-process open file table.  The special
names "text" and "wd" mean that the file is the pure text inode
or the working directory for the process.  If the file number is
followed by an asterick (*), then the file is not an inode, but
either a socket, fifo, or has an error of some kind. In this case
the rest of the entry is variable format, doesn't correspond
to the rest of the
headings, and is
enclosed in parenthesis.
The following paragraph describing sockets will explain the
variable format.
.TP 6
.B DEVICE
Major minor number of the device this file exists on.
.TP 6
.B INODE
The inode number of the file.
.TP 6
.B SIZE
The size in bytes of the file.
.TP 6
.B TYPE
The type of the file. (see sys/file.h)
.PP
Sockets
.sp1 6
The formating of open sockets depends on the protocol domain.  In
all cases the first field is the domain name, the second field
is the socket type (stream, dgram, etc), and the third is the socket
flags field (in hex).  The remaining fields are protocol dependent.  For tcp,
it is the address of the tcpcb, and for udp,
the inpcb (socket pcb).  For unix domain sockets, its the address of the socket
pcb and the address of the connected pcb (if connected).  Otherwise
the protocol number and address of the socket itself are printed. The
idea is not to duplicate netstat, but to make available enough
information for further analysis.  For example, the addresses mentioned
above are the addresses which the "netstat -A" command would print for
tcp, udp, and unixdomain.  Note that since pipe(2) is implemented
with sockets, a pipe appears as a connected unix domain stream socket.
A unidirectional unix domain socket indicates the direction of
flow with an arrow ("<-" or "->"), and a full duplex socket shows
a double arrow ("<->").
.dt
.SH BUGS
Socket information clutters the output.
.PP
Since \fIfstat\fP takes a snapshot of the system, it is only correct for
a very short period of time.
.SH "SEE ALSO"
ps(1), pstat(8)
