.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)reboot.8	6.6 (Berkeley) 7/12/88
.\"
.TH REBOOT 8 "July 12, 1988"
.UC 4
.SH NAME
reboot \- UNIX bootstrapping procedures
.SH SYNOPSIS
.B /etc/reboot
[
.B \-n
] [
.B \-q
]
.SH DESCRIPTION
.PP
UNIX is started by placing it in memory
at location zero and transferring to the entry point.
Since the system is not reenterable,
it is necessary to read it in from disk or tape
each time it is to be bootstrapped.
.PP
.B Rebooting a running system.
When a UNIX is running and a reboot is desired,
.IR shutdown (8)
is normally used.
If there are no users then
.B /etc/reboot
can be used.
Reboot causes the disks to be synced and allows the system
to perform other shutdown activities such as resynchronizing
hardware time-of-day clocks.
A multi-user reboot (as described below) is then initiated.
This causes a system to be
booted and an automatic disk check to be performed.  If all this succeeds
without incident, the system is then brought up for many users.
.PP
Options to reboot are:
.TP
.B \-n
option avoids the sync.  It can be used if a disk or the processor
is on fire. 
.TP
.B \-q
reboots quickly and ungracefully, without shutting down running
processes first.
.PP
.I Reboot
normally logs the reboot using
.IR syslog (8)
and places a shutdown record in the login accounting file
/usr/adm/wtmp.
These actions are inhibited if the
.B \-n
or
.B \-q
options are present.
.PP
.B "Power fail and crash recovery."
Normally, the system will reboot itself at power-up or after crashes.
Provided the auto-restart is enabled on the machine front panel,
an automatic consistency check of the file systems will be performed,
and unless this fails, the system will resume multi-user operations.
.PP
.B Cold starts.
These are processor-type dependent.
On an 11/780, there are two floppy files for each disk controller,
both of which cause boots from unit 0 of the root file system
of a controller located on mba0 or uba0.
One gives a single user shell, while the other invokes the multi-user
automatic reboot.  Thus these files are HPS and HPM for the single
and multi-user boot from MASSBUS RP06/RM03/RM05 disks,
UPS and UPM for UNIBUS storage module controller and disks
such as the EMULEX SC-21
and AMPEX 9300 pair,
RAS and RAM to boot from MSCP controllers and disks such as the RA81,
or HKS and HKM for RK07 disks.
There is also a script for booting from the default device,
which is normally a copy of one of the standard multi-user boot scripts,
but which may be modified to perform other actions
or to boot from a different unit.
The situation on the 8600 is similar, with scripts loaded from the console RL02.
.PP
Giving the command
.IP
>>>BOOT HPM
.LP
would boot the system from (e.g.) an RP06 and run the automatic consistency
check as described in
.IR fsck (8).
(Note that it may
be necessary to type control-P
and halt the processor
to gain the attention of the LSI-11 before getting the >>> prompt.)
The command
.IP
>>>BOOT ANY
.LP
invokes a version of the boot program in a way which allows you to
specify any system as the system to be booted.
It reads from the console a device specification (see below) followed
immediately by a pathname.
.PP
The scripts may be modified for local configuration if necessary.
The flags are placed in register 11 (as defined in
.IR <sys/reboot.h> ).
The boot device is specified in register 10.
The encoding of this register is also defined in
.IR <sys/reboot.h> .
The current encoding has a historical basis, and is shown in the following
table:
.LP
.ta 5 10
.nf
	bits	usage
	0-7	boot device type (the device major number)
	8-15	disk partition
	16-19	drive unit
	20-23	controller number
	24-27	adaptor number (UNIBUS or MASSBUS as appropriate)
.fi
.LP
The adaptor number corresponds to the normal configuration on the 11/750,
and to the order in which adaptors are found on the 11/780 and 8600
(generally the same as the numbers used by UNIX).
.PP
On an 11/750, the reset button will boot from the device
selected by the front panel boot device switch.  In systems
with RK07's, position B normally selects the RK07 for boot.
This will boot multi-user.  To boot from RK07 with boot flags you
may specify
.IP
>>>B/\fIn\fR DMA0
.LP
where, giving a \fIn\fR of 1 causes the boot program
to ask for the name of the system to be bootstrapped,
giving a \fIn\fR of 2 causes the boot program to come up single
user, and a \fIn\fR of 3 causes both of these actions to occur.
The ``DM'' specifies RK07, the ``A'' represents the adaptor number (UNIBUS
or MASSBUS), and the ``0'' is the drive unit number.
Other disk types which may be used are DB (MASSBUS), DD (TU58),
and DU (UDA-50/RA disk).
A non-zero disk partition can be used by adding (partition times 1000 hex)
to \fIn\fR.
.PP
The boot procedure on the MicroVAX II is similar.
A switch on the back panel sets the power-up action
to autoboot or to halt.
When halted, the processor may be booted using the same syntax
as on the 11/750.
.PP
The 11/750 boot procedure uses the boot roms to load block 0 off of
the specified device.  The /usr/mdec directory contains a number
of bootstrap programs for the various disks which should be placed
in a new pack by
.IR disklabel (8).
Similarly, the MicroVAX II boot procedure loads a boot parameter block
from block 0 of the disk.
The
.I rdboot
``bootstrap'' contains the correct parameters for an MSCP disk such
as the RD53.
.PP
On any processor, the 
.I boot
program
finds the corresponding file on the given device 
.RI ( vmunix
by default), loads that file
into memory location zero, and starts the program at the entry address
specified in the program header (after clearing off the high bit
of the specified entry address).
.PP
The file specifications used with \*(lqBOOT ANY\*(rq or \*(lqB/3\*(rq
are of the form:
.IP
device(adaptor,controller,unit,minor)
.PP
where
.I device
is the type of the device to be searched,
.I adaptor
is the UNIBUS or MASSBUS number of the adaptor to which the device is attached,
.I controller
is the unit number of the controller or MASSBUS tape formatter on that adaptor,
.I unit
is the unit number of the disk or transport slave unit of the tape,
and
.I minor
is the disk partition or tape file number.
Leading adaptor or controller numbers default to 0.
Normal line editing characters can be used when typing the file specification.
The following list of supported devices may vary from installation to
installation:
.LP
.ta 5 10
.nf
	hp	MASSBUS disk drive
	up	UNIBUS storage module drive
	ht	TE16,TU45,TU77 on MASSBUS
	kra	storage module on a KDB50
	mt	TU78 on MASSBUS
	hk	RK07 on UNIBUS
	ra	storage module on a MSCP-compatible UNIBUS controller
	rb	storage module on a 730 IDC
	rl	RL02 on UNIBUS
	tm	TM11 emulation tape drives on UNIBUS
	tms	TMSCP-compatible tape
	ts	TS11 on UNIBUS
	ut	UNIBUS TU45 emulator
.fi
.PP
For example,
to boot from a file system which starts at cylinder 0
of unit 0 of a MASSBUS disk, type \*(lqhp(0,0)vmunix\*(rq
to the boot prompt; \*(lqhp(2,0,1,0)vmunix\*(rq
would specify drive 1 on MASSBUS adaptor 2;
\*(lqup(0,0)vmunix\*(rq would specify
a UNIBUS drive, \*(lqhk(0,0)vmunix\*(rq would specify
an RK07 disk drive, \*(lqra(1,0,0,0)vmunix\*(rq would specify a
UDA50 disk drive on a second UNIBUS, and \*(lqrb(0,0)vmunix\*(rq would specify a
disk on a 730 IDC.
For tapes, the minor device number gives a file offset;
\*(lqmt(1,2,3,4)\*(rq would specify the fifth file on slave 3 of the formatter
at \*(lqdrive\*(rq 2 on mba 1.
.PP
On an 11/750 with patchable control store,
microcode patches will be installed by
.I boot
if the file
.I psc750.bin
exists in the root of the filesystem from which the system is booted.
.PP
In an emergency, the bootstrap methods described in the paper
``Installing and Operating 4.3bsd'' can be used
to boot from a distribution tape.
.SH FILES
.ta \w'/usr/mdec/bootxx   'u
/vmunix	system code
.br
/boot	system bootstrap
.br
/usr/mdec/xxboot	sector-0 boot block for 750, xx is disk type
.br
/usr/mdec/bootxx	second-stage boot for 750, xx is disk type
.br
/pcs750.bin	microcode patch file on 750
.SH "SEE ALSO"
arff(8V),
crash(8V),
disklabel(8),
fsck(8),
halt(8),
init(8),
rc(8),
shutdown(8),
syslogd(8)
