.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms are permitted
.\" provided that the above copyright notice and this paragraph are
.\" duplicated in all such forms and that any documentation,
.\" advertising materials, and other materials related to such
.\" distribution and use acknowledge that the software was developed
.\" by the University of California, Berkeley.  The name of the
.\" University may not be used to endorse or promote products derived
.\" from this software without specific prior written permission.
.\" THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
.\" IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
.\" WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
.\"
.\"	@(#)edquota.8	6.4 (Berkeley) 7/9/88
.\"
.TH EDQUOTA 8 "July 9, 1988"
.UC 5
.SH NAME
edquota \- edit user quotas
.SH SYNOPSIS
.B edquota
[
.B \-p
.I proto-user
]
.IR users ...
.SH DESCRIPTION
.I Edquota
is a quota editor.  One or more users
may be specified on the command line.
For each user a temporary file is created
with an ASCII representation of the current
disc quotas for that user and an editor is
then invoked on the file.  The quotas may then
be modified, new quotas added, etc.  Upon
leaving the editor,
.I edquota
reads the temporary file and modifies the binary
quota files to reflect the changes made.
.PP
If the 
.B \-p
option is specified,
.I edquota
will duplicate the quotas of the prototypical user
specified for each user specified.  This is the normal
mechanism used to initialize quotas for groups
of users.
.PP
The editor invoked is 
.IR vi (1)
unless the environment variable EDITOR specifies otherwise.
.PP
Only the super-user may edit quotas.
.SH FILES
.DT
\fIquotas\fP		at the root of each file system with quotas
.br
/etc/fstab	to find file system names and locations
.SH SEE ALSO
quota(1), quota(2), quotacheck(8), quotaon(8), repquota(8)
.SH DIAGNOSTICS
Various messages about inaccessible files; self-explanatory.
.SH BUGS
The format of the temporary file is inscrutable.
