.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)dump.8	6.3 (Berkeley) 5/23/86
.\"
.TH DUMP 8 "May 23, 1986"
.UC 4
.SH NAME
dump \- incremental file system dump
.SH SYNOPSIS
.B /etc/dump
[ key [
.I argument
\&... ] filesystem ]
.SH DESCRIPTION
.I Dump
copies to magnetic tape all files
changed after a certain date
in the
.I filesystem.
The
.I key
specifies the date and other options about the dump.
.I Key
consists of characters from
the set
.B 0123456789fusdWn.
.TP 5
.B  0\-9
This number is the `dump level'.
All files modified since the last date stored
in the file
.I /etc/dumpdates
for the same filesystem at lesser levels
will be dumped.
If no date is determined by the level,
the beginning of time is assumed;
thus the option
.B 0
causes the entire filesystem to be dumped.
.TP 5
.B f
Place the dump on the next 
.I argument 
file
instead of the tape.
If the name of the file is ``\-'',
.I dump 
writes to standard output.
.TP 5
.B u
If the dump completes successfully,
write the date of the beginning of the dump on
file
.I /etc/dumpdates.
This file records a separate date for
each filesystem and each dump level.
The format of
.I /etc/dumpdates
is readable by people, consisting of one
free format record per line:
filesystem name, increment level
and
.I ctime(3)
format dump date.  
.I /etc/dumpdates
may be edited to change any of the fields,
if necessary.
.TP 5
.B s
The size of the dump tape is specified in feet.
The number of feet is taken from the next
.I argument.
When the specified size is reached,
.I dump
will wait for reels to be changed.
The default tape size is 2300 feet.
.TP 5
.B d
The density of the tape, expressed in BPI,
is taken from the next
.I argument.
This is used in calculating the amount of tape
used per reel. The default is 1600.
.TP 5
.B W
.I Dump
tells the operator what file systems need to be dumped.
This information is gleaned from the files
.I /etc/dumpdates
and
.I /etc/fstab.
The
.B W
option causes
.I dump
to print out, for each file system in
.I /etc/dumpdates
the most recent dump date and level,
and highlights those file systems that should be dumped.
If the 
.B W
option is set, all other options are ignored, and
.I dump
exits immediately.
.TP 5
.B w
Is like W, but prints only those filesystems which need to be dumped.
.TP 5
.B n
Whenever
.I dump
requires operator attention,
notify by means similar to a
.IR wall (1)
all of the operators in the group \*(lqoperator\*(rq.
.PP
If no arguments are given,
the
.I key
is assumed to be
.B 9u
and a default file system is dumped
to the default tape.
.PP
.I Dump
requires operator intervention on these conditions:
end of tape,
end of dump,
tape write error,
tape open error or
disk read error (if there are more than a threshold of 32).
In addition to alerting all operators implied by the
.B n
key,
.I dump
interacts with the operator on 
.I dump's
control terminal at times when
.I dump
can no longer proceed,
or if something is grossly wrong.
All questions
.I dump
poses
.B must
be answered by typing \*(lqyes\*(rq or \*(lqno\*(rq,
appropriately.
.PP
Since making a dump involves a lot of time and effort for full dumps,
.I dump
checkpoints itself at the start of each tape volume.
If writing that volume fails for some reason,
.I dump
will,
with operator permission,
restart itself from the checkpoint
after the old tape has been rewound and removed,
and a new tape has been mounted.
.PP
.I Dump
tells the operator what is going on at periodic intervals,
including usually low estimates of the number of blocks to write,
the number of tapes it will take, the time to completion, and
the time to the tape change.
The output is verbose,
so that others know that the terminal
controlling
.I dump
is busy,
and will be for some time.
.PP
Now a short suggestion on how to
perform dumps.
Start with a full level 0 dump
.PP
	dump 0un
.PP
Next, dumps of active file 
systems are taken on a daily basis,
using a modified Tower of Hanoi algorithm,
with this sequence of dump levels:
.ce 1
3 2 5 4 7 6 9 8 9 9 ...
For the daily dumps, a set of 10 tapes per dumped file system
is used on a cyclical basis.
Each week, a level 1 dump is taken, and
the daily Hanoi sequence repeats with 3.
For weekly dumps, a set of 5 tapes per dumped file system is
used, also on a cyclical basis.
Each month, a level 0 dump is taken
on a set of fresh tapes that is saved forever.
.SH FILES
.nf
.ta \w'/etc/dumpdates\ \ 'u
/dev/rrp1g	default filesystem to dump from
/dev/rmt8	default tape unit to dump to
/etc/dumpdates	new format dump date record 
/etc/fstab	dump table: file systems and frequency
/etc/group	to find group \fIoperator\fP
.fi
.DT
.br
.SH "SEE ALSO"
restore(8),
dump(5),
fstab(5)
.SH DIAGNOSTICS
Many, and verbose.
.PP
Dump exits with zero status on success.
Startup errors are indicated with an exit code of 1;
abnormal termination is indicated with an exit code of 3.
.SH BUGS
.PP
Fewer than 32 read errors on the filesystem are ignored.
Each reel requires a new process, so parent processes for
reels already written just hang around until the entire tape
is written.
.PP
.I Dump
with the
.B W
or
.B w
options does not report filesystems that have never been recorded
in /etc/dumpdates, even if listed in /etc/fstab.
.PP
It would be nice if
.I dump
knew about the dump sequence,
kept track of the tapes scribbled on,
told the operator which tape to mount when,
and provided more assistance
for the operator running
.IR restore .
