.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)diskpart.8	6.4 (Berkeley) 7/12/88
.\"
.TH DISKPART 8 "July 12, 1988"
.UC 4
.SH NAME
diskpart \- calculate default disk partition sizes
.SH SYNOPSIS
.B /etc/diskpart
[
.B \-p
] [
.B \-d
] [
.B \-s
size
]
disk-type
.SH DESCRIPTION
.I Diskpart
is used to calculate the disk partition sizes based on the
default rules used at Berkeley.  If the
.B \-p
option is supplied, tables suitable for inclusion in a device driver
are produced.  If the
.B \-d
option is supplied, an entry suitable for inclusion in the disk
description file
.I /etc/disktab
is generated; c.f.
.IR disktab (5).
On disks that use
.IR bad144 \|-style
bad-sector forwarding,
space is normally left in the last partition on the disk
for a bad sector forwarding table, although this space
is not reflected in the tables produced.  The space reserved
is one track for the replicated copies of the table and
sufficient tracks to hold a pool of 126 sectors to which bad sectors
are mapped.  For more information, see 
.IR bad144 (8).
The size of the disk may be limited with the
.B \-s
option, specifying the amount of the disk to be used.
This option is intended for other controllers that reserve some space at the end
of the disk for bad-sector replacements or other control areas,
even if not a multiple of cylinders.
.PP
The disk partition sizes are based on the total amount of
space on the disk as given in the table below (all values
are supplied in units of sectors).  The `c' partition
is, by convention, used to access the entire physical disk.
The device driver tables include
the space reserved for the bad sector forwarding table in the `c' partition;
those used in the disktab and default formats exclude reserved tracks.
In normal operation, either the `g' partition is used, or the
`d', `e', and `f' partitions are used.  The `g' and `f' partitions
are variable-sized, occupying whatever space remains after allocation
of the fixed sized partitions.
If the disk is smaller than 20 Megabytes, then
.I diskpart
aborts with the message ``disk too small, calculate by hand''.
.in +0.5i
.nf

.ta \w'Partition  'u +\w'20-60 MB  'u +\w'61-205 MB  'u +\w'206-355 MB  'u +\w'356+ MB'u
Partition	20-60 MB	61-205 MB	206-355 MB	356+ MB
a	15884	15884	15884	15884
b	10032	33440	33440	66880
d	15884	15884	15884	15884
e	unused	55936	55936	307200
h	unused	unused	291346	291346

.fi
.in -0.5i
.PP
If an unknown disk type is specified, 
.I diskpart
will prompt for the required disk geometry information.
.SH SEE ALSO
disktab(5),
bad144(8)
.SH BUGS
Most default partition sizes are based on historical artifacts
(e.g. RP06), and may result in unsatisfactory layouts.
.PP
When using the \-d flag, alternate disk names are not included
in the output.
