.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)badsect.8	6.1 (Berkeley) 4/27/85
.\"
.TH BADSECT 8 "April 27, 1985"
.UC 4
.SH NAME
badsect \- create files to contain bad sectors
.SH SYNOPSIS
.B /etc/badsect
bbdir sector ...
.SH DESCRIPTION
.I Badsect
makes a file to contain a bad sector.  Normally, bad sectors
are made inaccessible by the standard formatter, which provides
a forwarding table for bad sectors to the driver; see
.IR bad144 (8)
for details.
If a driver supports the bad blocking standard it is much preferable to
use that method to isolate bad blocks, since the bad block forwarding
makes the pack appear perfect, and such packs can then be copied with
.IR dd (1).
The technique used by this program is also less general than
bad block forwarding, as
.I badsect
can't make amends for
bad blocks in the i-list of file systems or in swap areas.
.PP
On some disks,
adding a sector which is suddenly bad to the bad sector table
currently requires the running of the standard DEC formatter.
Thus to deal with a newly bad block
or on disks where the drivers
do not support the bad-blocking standard 
.I badsect
may be used to good effect.
.PP
.I Badsect
is used on a quiet file system in the following way:
First mount the file system, and change to its root directory.
Make a directory BAD there.  Run
.I badsect
giving as argument the BAD directory followed by
all the bad sectors you wish to add.
(The sector numbers must be relative to the beginning of
the file system, but this is not hard as the system reports
relative sector numbers in its console error messages.)
Then change back to the root directory, unmount the file system
and run
.IR fsck (8)
on the file system.  The bad sectors should show up in two files
or in the bad sector files and the free list.  Have
.I fsck
remove files containing the offending bad sectors, but 
.B "do not"
have it remove the BAD/\fInnnnn\fR files.
This will leave the bad sectors in only the BAD files.
.PP
.I Badsect
works by giving the specified sector numbers in a
.IR mknod (2)
system call,
creating an illegal file whose first block address is the block containing
bad sector and whose name is the bad sector number.
When it is discovered by 
.I fsck
it will ask ``HOLD BAD BLOCK''?
A positive response will cause 
.I fsck
to convert the inode to a regular file containing the bad block.
.SH SEE ALSO
bad144(8),
fsck(8),
format(8V)
.SH DIAGNOSTICS
.I Badsect
refuses to attach a block that
resides in a critical area or is out of range of the file system.
A warning is issued if the block is already in use.
.SH BUGS
If more than one sector which comprise a file system fragment are bad,
you should specify only one of them to
.I badsect,
as the blocks in the bad sector files actually cover all the sectors in a
file system fragment.
