.\" Copyright (c) 1986 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)XNSrouted.8c	6.1 (Berkeley) 6/4/86
.\"
.TH XNSROUTED 8C "June 4, 1986"
.UC 6
.SH NAME
XNSrouted \- NS Routing Information Protocol daemon
.SH SYNOPSIS
.B /etc/XNSrouted
[
.B \-s
] [
.B \-q
] [
.B \-t
] [
.I logfile
]
.SH DESCRIPTION
.I XNSrouted
is invoked at boot time to manage the Xerox NS routing tables.
The NS routing daemon uses the Xerox NS Routing
Information Protocol in maintaining up to date kernel routing
table entries.
.PP
In normal operation
.I XNSrouted
listens
for routing information packets.  If the host is connected to
multiple NS networks, it periodically supplies copies
of its routing tables to any directly connected hosts
and networks.
.PP
When
.I XNSrouted
is started, it uses the SIOCGIFCONF
.I ioctl
to find those
directly connected interfaces configured into the
system and marked ``up'' (the software loopback interface
is ignored).  If multiple interfaces
are present, it is assumed the host will forward packets
between networks.
.I XNSrouted
then transmits a 
.I request
packet on each interface (using a broadcast packet if
the interface supports it) and enters a loop, listening
for
.I request
and
.I response
packets from other hosts.
.PP
When a
.I request
packet is received, 
.I XNSrouted
formulates a reply based on the information maintained in its
internal tables.  The
.I response
packet generated contains a list of known routes, each marked
with a ``hop count'' metric (a count of 16, or greater, is
considered ``infinite'').  The metric associated with each
route returned provides a metric
.IR "relative to the sender" .
.PP
.I Response
packets received by
.I XNSrouted
are used to update the routing tables if one of the following
conditions is satisfied:
.TP
(1)
No routing table entry exists for the destination network
or host, and the metric indicates the destination is ``reachable''
(i.e. the hop count is not infinite).
.TP
(2)
The source host of the packet is the same as the router in the
existing routing table entry.  That is, updated information is
being received from the very internetwork router through which
packets for the destination are being routed.
.TP
(3)
The existing entry in the routing table has not been updated for
some time (defined to be 90 seconds) and the route is at least
as cost effective as the current route.
.TP
(4)
The new route describes a shorter route to the destination than
the one currently stored in the routing tables; the metric of
the new route is compared against the one stored in the table
to decide this.
.PP
When an update is applied,
.I XNSrouted
records the change in its internal tables and generates a
.I response
packet to all directly connected hosts and networks.
.I Routed
waits a short period
of time (no more than 30 seconds) before modifying the kernel's
routing tables to allow possible unstable situations to settle.
.PP
In addition to processing incoming packets,
.I XNSrouted
also periodically checks the routing table entries.
If an entry has not been updated for 3 minutes, the entry's metric
is set to infinity and marked for deletion.  Deletions are delayed
an additional 60 seconds to insure the invalidation is propagated
to other routers.
.PP
Hosts acting as internetwork routers gratuitously supply their
routing tables every 30 seconds to all directly connected hosts
and networks.
.PP
Supplying the
.B \-s
option forces 
.I XNSrouted
to supply routing information whether it is acting as an internetwork
router or not.
The
.B \-q
option is the opposite of the
.B \-s
option.  If the
.B \-t
option is specified, all packets sent or received are
printed on the standard output.  In addition,
.I XNSrouted
will not divorce itself from the controlling terminal
so that interrupts from the keyboard will kill the process.
Any other argument supplied is interpreted as the name
of file in which 
.IR XNSrouted 's
actions should be logged.  This log contains information
about any changes to the routing tables and a history of
recent messages sent and received which are related to
the changed route.
.SH "SEE ALSO"
``Internet Transport Protocols'', XSIS 028112, Xerox System Integration
Standard.
.br
idp(4P)
