.\"	@(#)tp.1	6.1 (Berkeley) 4/29/85
.\"
.TH TP 1 "April 29, 1985"
.AT 3
.SH NAME
tp \- manipulate tape archive
.SH SYNOPSIS
.B tp
[ key ] [ name ... ]
.SH DESCRIPTION
.PP
.I Tp
saves and restores files
on DECtape or magtape.
Its actions are controlled by the
.I key
argument.
The key is a string of characters containing
at most one function letter and possibly
one or more function modifiers.
Other arguments to the command are file or directory
names specifying which files are to be dumped, restored,
or listed.
In all cases, appearance of a directory name refers to
the files and (recursively) subdirectories of that directory.
.PP
The function portion of
the key is specified by one of the following letters:
.TP 8
.B  r
The named files
are written
on the tape.
If files with the same names
already exist, they are replaced.
`Same' is determined by string comparison, so
`./abc' can never be the same as `/usr/dmr/abc' even
if `/usr/dmr' is the current directory.
If no file argument is given, `\fB.\fR' is the default.
.TP 8
.B  u
updates the tape.
.B u
is like
.B r,
but a file is replaced only if its
modification date is later than the date stored on the tape;
that is to say, if it has changed since it was dumped.
.B u
is the default command if none is given.
.TP 8
.B  d
deletes the named files from
the tape.
At least one name argument must be given.
This function is not permitted on magtapes.
.TP 8
.B  x
extracts the named files from the tape to the file system.
The owner and mode are restored.
If no file argument is given, the entire contents of the
tape are extracted.
.TP 8
.B  t
lists the names of the specified files.
If no file argument is given,
the entire contents of the tape is listed.
.PP
The following characters may be used in addition to the letter
which selects the function desired.
.TP 10
.B  m
Specifies magtape as opposed to DECtape.
.TP 10
.B  0,...,7
This
modifier selects the drive on which the tape is mounted.
For DECtape, 
.B x
is default; for magtape
`0' is the default.
.TP 10
.B  v
Normally
.I tp
does its work silently.
The
.B v
(verbose)
option causes it to type the name of each file it treats
preceded by the function letter.
With the
.B t
function,
.B v
gives more information about the
tape entries than just the name.
.TP 10
.B  c
means a fresh dump is being created; the tape directory
is cleared before beginning.
Usable only with
.B r
and
.B u.
This option is assumed with magtape since
it is impossible to selectively overwrite
magtape.
.TP 10
.B  i
Errors reading and writing the
tape are noted, but no action is taken.
Normally, errors cause a return to the command level.
.TP 10
.B f
Use the first named file, rather than a tape,
as the archive.
This option currently acts like 
.BR m ;
.I i.e.
.BR r
implies 
.BR c ,
and neither
.BR d
nor
.BR u
are permitted.
.TP 10
.B  w
causes
.I tp
to pause before treating each file, type
the indicative letter and the file name (as with
.BR v )
and await the user's response.
Response
.B y
means `yes', so the file is treated.
Null response
means `no', and the file does not take part
in whatever is being done.
Response
.B x
means `exit';
the
.I tp
command terminates immediately.
In the
.B x
function,
files previously asked about
have been extracted already.
With
.B "r, u,"
and
.B d
no change has been made to the tape.
.PP
.SH FILES
/dev/tap?
.br
/dev/rmt?
.SH SEE ALSO
ar(1), tar(1)
.SH DIAGNOSTICS
Several; the non-obvious one is
`Phase error', which means the file changed after it was selected for
dumping but before it was dumped.
.SH BUGS
A single file with several links to it is treated like several files.
.PP
Binary-coded control information makes
magnetic tapes written by
.I tp
difficult to carry to other machines;
.IR tar (1)
avoids the problem.
