.\"	@(#)tar.1	6.6 (Berkeley) 5/23/88
.\"
.TH TAR 1 "May 23, 1988"
.AT 3
.SH NAME
tar \- tape archiver
.SH SYNOPSIS
.B tar
[ key ] [ name ... ]
.SH DESCRIPTION
.PP
.I Tar
saves and restores multiple files on a single file (usually a magnetic
tape, but it can be any file).  
.IR Tar 's
actions are controlled by the
.I key
argument.  The
.I key
is a string of characters containing at most one function letter and possibly
one or more function modifiers.  Other arguments to 
.I tar
are file or directory names specifying which files to dump or restore.
In all cases, appearance of a directory name refers to
the files and (recursively) subdirectories of that directory.
.PP
The function portion of the key is specified by one of the following letters:
.TP 8
.B r
The named files are written on the end of the tape.  The
.B c
function implies this.
.TP 8
.B x
The named files are extracted from the tape.  If the named file
matches a directory whose contents had been written onto the tape, this
directory is (recursively) extracted.  The owner, modification time, and mode
are restored (if possible).  If no file argument is given, the entire content
of the tape is extracted.  Note that if multiple entries specifying the same
file are on the tape, the last one overwrites all earlier.
.TP 8
.B t
The names of the specified files are listed each time they occur on
the tape.  If no file argument is given, all of the names on the tape
are listed.
.TP 8
.B u
The named files are added to the tape if either they are not
already there or have been modified since last put on the tape.
.TP 8
.B c
Create a new tape; writing begins on the beginning of the tape
instead of after the last file.  This command implies
.BR r .
.PP
The following characters may be used in addition to the letter
which selects the function desired.
.TP 10
.B o
On output, tar normally places information specifying owner and modes
of directories in the archive.  Former versions of tar, when encountering
this information will give error message of the form
.br
	"<name>/: cannot create".
.br
This modifier will suppress the directory information.
.TP 10
.B p
This modifier says to restore files to their original modes,
ignoring the present
.IR umask (2).
Setuid and sticky information
will also be restored to the super-user.
.TP 10
.B 0, ..., 9
This modifier selects an alternate drive on which the tape is mounted.
The default is drive 0 at 1600 bpi, which is normally /dev/rmt8.
.TP 10
.B v
Normally
.I tar
does its work silently.  The
.B v
(verbose) option makes
.I tar
print the name of each file it treats preceded by the function
letter.  With the
.B t
function, the verbose option
gives more information about the tape entries than just their names.
.TP 10
.B w
.I Tar
prints the action to be taken followed by file name, then
wait for user confirmation. If a word beginning with `y'
is given, the action is done. Any other input means don't do it.
.TP 10
.B f
.I Tar
uses the next argument as the name of the archive instead of
/dev/rmt?. If the name of the file is `\-', tar writes to standard output or
reads from standard input, whichever is appropriate. Thus,
.I tar
can be used as the head or tail of a filter chain.
.I Tar
can also be used to move hierarchies with the command
.ce 1
cd fromdir; tar cf - . | (cd todir; tar xf -)
.TP 10
.B b
.I Tar
uses the next argument as the blocking factor for tape records. The
default is 20 (the maximum). This option should only be used with raw magnetic
tape archives (See 
.B f
above).  The block size is determined automatically
when reading tapes (key letters `x' and `t').
.TP 10
.B s
tells tar to strip off any leading slashes from pathnames.
.TP 10
.B l
tells 
.I tar
to complain if it cannot resolve all of the links to the
files dumped.  If this is not specified, no error messages are printed.
.TP 10
.B m
tells 
.I tar
not to restore the modification times.  The modification time
will be the time of extraction.
.TP 10
.B h
Force 
.I tar
to follow symbolic links as if they were normal files or
directories.  Normally, 
.I tar
does not follow symbolic links.
.TP 10
.B B
Forces input and output blocking to 20 blocks per record.  This option
was added so that 
.I tar
can work across a communications channel where the blocking may not
be maintained.
.TP 10
.B C
If a file name is preceded by 
.BR \-C ,
then 
.I tar
will perform a
.IR chdir (2)
to that file name.  This allows multiple directories not
related by a close common parent to be archived using short
relative path names.  For example, to archive files from /usr/include
and from /etc, one might use
.ti +0.5i
tar c -C /usr include -C / etc
.PP
Previous restrictions dealing with
.IR tar 's
inability to properly handle blocked archives have been lifted.
.PP
.SH FILES
/dev/rmt?
.br
/tmp/tar*
.SH "SEE ALSO"
tar(5)
.SH DIAGNOSTICS
Complaints about bad key characters and tape read/write errors.
.br
Complaints if enough memory is not available to hold the link tables.
.SH BUGS
There is no way to ask for the
.IR n -th
occurrence of a file.
.br
Tape errors are handled ungracefully.
.br
The 
.B u
option can be slow.
.br
The current limit on file name length is 100 characters.
.br
There is no way selectively to follow symbolic links.
.br
When extracting tapes created with the
.B r
or
.B u
options, directory modification times may not be set correctly.
