.\"	@(#)sh.1	6.3 (Berkeley) 5/5/86
.\"
.TH SH 1 "May 5, 1986"
.AT 3
.SH NAME
sh, for, case, if, while, \fB:\fP, \fB.\fP, break, continue, cd, eval, exec, exit, export, login, read, readonly, set, shift, times, trap, umask, wait \- command language
.SH SYNOPSIS
.B sh
[
.B \-ceiknrstuvx
] [ arg ] ...
.ds OK [\|
.ds CK \|]
.ds LT \s-2<\s0
.ds GT \s-2>\s0
.ds LE \s-2<\s0
.ds ST *
.SH DESCRIPTION
.I Sh
is a command programming language that executes commands read from a terminal
or a file.  See
.B invocation
for the meaning of arguments to the shell.
.PP
.B Commands.
.br
A
.I simple-command
is a sequence of non blank
.I words
separated by blanks (a blank is a
.B tab
or a
.BR space ).
The first word specifies the name of the command to be executed.
Except as specified below the remaining words are passed as arguments
to the invoked command.
The command name is passed as argument 0 (see
.IR execve (2)).
The
.I value
of a simple-command is its exit status
if it terminates normally or 200+\fIstatus\fP if it terminates abnormally (see
.IR sigvec (2)
for a list of status values).
.LP
A
.I pipeline
is a sequence of one or more
.I commands
separated by
.B \(or.
The standard output of each command but the last is connected by a
.IR pipe (2)
to the standard input of the next command.
Each command is run as a separate process;
the shell waits for the last command to terminate.
.LP
A
.I list
is a sequence of one or more
.I pipelines
separated by
.BR ; ,
.BR & ,
.B &&
or
.B \(or\|\(or
and optionally terminated by
.B ;
or
.BR & .
.B ;
and
.B &
have equal precedence which is lower than that of
.B &&
and
.BR \(or\|\(or ,
.B &&
and
.B \(or\|\(or
also have equal precedence.
A semicolon causes sequential execution; an ampersand causes the preceding
.I pipeline
to be executed without waiting for it to finish.  The symbol
.B &&
.RB ( \(or\|\(or )
causes the
.I list
following to be executed only if the preceding
.I pipeline
returns a zero (non zero) value.  Newlines may appear in a
.I list,
instead of semicolons, to delimit commands.
.LP
A
.I command
is either a simple-command or one of the following.
The value returned by a command is that of the
last simple-command executed in the command.
.TP
\fBfor \fIname\fR \*(OK\fBin \fIword\fR ...\*(CK \fBdo \fIlist \fBdone\fR
Each time a
.B for
command is executed
.I name
is set to the next word in the
.B for
word list.
If
.BI in \ word
\&...
is omitted,
.B
in "$@"
is assumed.  Execution ends when there are no more words in the list.
.TP
\fBcase \fIword \fBin\fR \*(OK\fIpattern \fR\*(OK \fB\(or \fIpattern \fR\*(CK ... \fB) \fIlist \fB;;\fR\*(CK ... \fBesac\fR
A
.B case
command executes the
.I list
associated with the first pattern that matches
.I word.
The form of the patterns is the same as that used for file name generation.
.TP
\fBif \fIlist \fBthen \fIlist\fR \*(OK\fBelif \fIlist \fBthen \fIlist\fR\*(CK ... \*(OK\fBelse \fIlist\fR\*(CK \fBfi\fR
The
.I list
following
.B if
is executed and if it returns zero the
.I list
following
.B then
is executed.  Otherwise, the
.I list
following
.B elif
is executed and if its value is zero the
.I list
following
.B then
is executed.  Failing that the
.B else
.I list
is executed.
.TP
\fBwhile \fIlist\fR \*(OK\fBdo \fIlist\fR\*(CK \fBdone\fR
A
.B while
command repeatedly executes the
.B while
.I list
and if its value is zero executes the
.B do
.I list;
otherwise the loop terminates.  The value returned by a
.B while
command is that of the last executed command in the
.B do
.I list.
.B until
may be used in place of
.B while
to negate the loop termination test.
.TP
.BI ( " list " )
Execute
.I list
in a subshell.
.TP
.BI { " list " }
.I list
is simply executed.
.LP
The following words are only recognized as the first word of a command
and when not quoted.
.IP
.B
if then else elif fi case in esac for while until do done { }
.PP
.B Command substitution.
.br
The standard output from a command enclosed in a pair of back quotes 
.RB ( \`\|\` )
may be used as part or all of a word; trailing newlines are removed.
.PP
.B Parameter substitution.
.br
The character
.B $
is used to introduce substitutable parameters.
Positional parameters may be assigned values by
.BR set .
Variables may be set by writing
.IP
.IB name = value
[
.IB name = value
] ...
.TP
$\fB\|{\fIparameter\fB\|}\fR
A
.I parameter
is a sequence of letters, digits or underscores (a
.IR name ),
a digit, or any of the characters
.B
* @ # ? \- $ !\|.
The value, if any, of the parameter is substituted.
The braces are required only when
.I parameter
is followed by a letter, digit, or underscore
that is not to be interpreted as part of its name.  If
.I parameter
is a digit, it is a positional parameter.  If
.I parameter
is
.BR * " or" " @"
then all the positional parameters, starting with
.SM
.BR $1 ,
are substituted separated by spaces.
.SM
.B $0
is set from argument zero when the shell is invoked.
.TP
$\fB\|{\fIparameter\|\-word\|\fB}\fR
If
.I parameter
is set, substitute its value; otherwise substitute
.I word.
.TP
$\fB\|{\fIparameter\|\(eq\|word\|\fB}\fR
If
.I parameter
is not set, set it to
.I word;
the value of the parameter is then substituted.
Positional parameters may not be assigned to in this way.
.TP
$\fB\|{\fIparameter\|?\|word\|\fB}\fR
If
.I parameter
is set, substitute its value; otherwise, print
.I word
and exit from the shell.  If
.I word
is omitted, a standard message is printed.
.TP
$\fB\|{\fIparameter\|\(plword\|\fB}\fR
If
.I parameter
is set, substitute
.I word;
otherwise substitute nothing.
.LP
In the above
.I word
is not evaluated unless it is to be used as the substituted string.
(So that, for example, echo ${d\-\'pwd\'} will only execute
.I pwd
if
.I d
is unset.)
.LP
The following
.I parameters
are automatically set by the shell.
.RS
.TP
.B #
The number of positional parameters in decimal.
.PD 0
.TP
.B \-
Options supplied to the shell on invocation or by
.BR set .
.TP
.B ?
The value returned by the last executed command in decimal.
.TP
.B $
The process number of this shell.
.TP
.B !
The process number of the last background command invoked.
.PD
.RE
.LP
The following
.I parameters
are used but not set by the shell.
.RS
.TP
.B
.SM HOME
The default argument (home directory) for the
.B cd
command.
.PD 0
.TP
.B
.SM PATH
The search path for commands (see
.BR execution ).
.TP
.B
.SM MAIL
If this variable is set to the name of
a mail file, the shell informs the user of
the arrival of mail in the specified file.
.SM
.TP
.B PS1
Primary prompt string, by default '$ '.
.TP
.SM
.B PS2
Secondary prompt string, by default '> '.
.TP
.SM
.B IFS
Internal field separators, normally
.BR space ,
.BR tab ,
and
.BR newline .
.B IFS
is ignored if 
.I sh
is running as root or if the effective user id differs from the real user id.
.PD
.RE
.PP
.B Blank interpretation.
.br
After parameter and command substitution,
any results of substitution are scanned for internal field separator
characters (those found in
.SM
.BR $IFS \*S)
and split into distinct arguments where such characters are found.
Explicit null arguments ("" or \'\') are retained.
Implicit null arguments (those resulting from
.I parameters
that have no values) are removed.
.PP
.B File name generation.
.br
Following substitution, each command word is scanned for the characters
.BR * ,
.B ?
and
.B \*(OK.
If one of these characters appears, the word is regarded as a pattern.
The word is replaced with alphabetically sorted file names that match the
pattern.  If no file name is found that matches the pattern,
the word is left unchanged.  The character
.B .
at the start of a file name or immediately following a
.BR / ,
and the character
.BR / ,
must be matched explicitly.
.TP 
.B \*(ST
Matches any string, including the null string.
.PD 0
.TP 
.B ?
Matches any single character.
.TP 
.B \*(OK...\*(CK
Matches any one of the characters enclosed.
A pair of characters separated by
.B \-
matches any character lexically between the pair.
.PD
.PP
.B Quoting.
.br
The following characters have a special meaning to the shell
and cause termination of a word unless quoted.
.LP
	\fB;   &   (   )   \(or   \*(LT   \*(GT   newline   space   tab\fP
.LP
A character may be
.I quoted
by preceding it with a
.B
\\\|.
.B \\\\newline
is ignored.
All characters enclosed between a pair of quote marks (\fB\'\|\'\fP),
except a single quote, are quoted.  Inside double quotes (\fB"\|"\fP)
parameter and command substitution occurs and
.B
\\
quotes the characters
.B
\\ \' "
and
.BR $ \|.
.LP
.B
"$*"
is equivalent to
.SM
.B
"$1 $2 ..."
whereas
.br
.B
"$@"
is equivalent to
.SM
.B
"$1" "$2" ... .
.PP
.B Prompting.
.br
When used interactively, the shell prompts with the value of
.SM
PS1
before reading a command.
If at any time a newline is typed and further input is needed
to complete a command, the secondary prompt
.RB ( \s-2$PS2\s0 )
is issued.
.PP
.B Input output.
.br
Before a command is executed its input and output
may be redirected using a special notation interpreted by the shell.
The following may appear anywhere in a simple-command
or may precede or follow a
.I command
and are not passed on to the invoked command.
Substitution occurs before
.I word
or
.I digit
is used.
.TP
\*(LT\fI\|word\fP
Use file
.I word
as standard input (file descriptor 0).
.PD
.TP
\*(GT\fI\|word\fP
Use file
.I word
as standard output (file descriptor 1).
If the file does not exist, it is created;
otherwise it is truncated to zero length.
.TP
\*(GT\*(GT\fI\|word\fP
Use file
.I word
as standard output.
If the file exists, output is appended (by seeking to the end);
otherwise the file is created.
.TP
\*(LT\*(LT\fI\|word\fP
The shell input is read up to a line the same as
.IR word ,
or end of file.
The resulting document becomes the standard input.
If any character of
.I word
is quoted, no interpretation is placed upon the characters of the document;
otherwise, parameter and command substitution occurs,
.B
\\newline
is ignored, and
.B
\\
is used to quote the characters
.B
\\ $ \'
and the first character of
.I word.
.TP
\*(LT\|&\|\fIdigit\fP
The standard input is duplicated from file descriptor
.I digit;
see
.IR dup (2).
Similarly for the standard output using \*(GT\|.
.TP
\*(LT\|&\|\-
The standard input is closed.
Similarly for the standard output using \*(GT\|.
.PD
.LP
If one of the above is preceded by a digit, the
file descriptor created is that specified by the digit
(instead of the default 0 or 1).  For example,
.LP
	\&... 2\*(GT&1
.LP
creates file descriptor 2 to be a duplicate
of file descriptor 1.
.LP
If a command is followed by
.B &
then the default standard input for the command is the empty file
(/dev/null).
Otherwise, the environment for the execution of a command contains the
file descriptors of the invoking shell as modified by input
output specifications.
.PP
.B Environment.
.br
The environment is a list of name-value pairs that is passed to
an executed program in the same way as a normal argument list; see
.IR execve (2)
and
.IR environ (7).
The shell interacts with the environment in several ways.
On invocation, the shell scans the environment and creates a
.I parameter
for each name found, giving it the corresponding value.
Executed commands inherit the same environment.
If the user modifies the values of these
.I parameters
or creates new ones, none of these affects the environment unless the
.B export
command is used to bind the shell's
.I parameter
to the environment.
The environment seen by any executed command is thus composed
of any unmodified name-value pairs originally inherited by the shell,
plus any modifications or additions, all of which must be noted in
.B export
commands.
.LP
The environment for any
.I simple-command
may be augmented by prefixing it with one or more assignments to
.I parameters.
Thus these two lines are equivalent
.IP
TERM=450 cmd args
.br
(export TERM; TERM=450; cmd args)
.LP
If the
.B \-k
flag is set,
.I all
keyword arguments are placed in the environment,
even if the occur after the command name.
The following prints 'a=b c' and 'c':
.nf
echo a=b c
set \-k
echo a=b c
.fi
.PP
.B Signals.
.br
The INTERRUPT and QUIT signals for an invoked
command are ignored if the command is followed by
.BR & ;
otherwise signals have the values inherited by the shell from its parent.
(But see also
.BR trap. )
.PP
.B Execution.
.br
Each time a command is executed the above substitutions are carried out.
Except for the 'special commands' listed below a new process is created and
an attempt is made to execute the command via an
.IR execve (2).
.LP
The shell parameter
.B
.SM $PATH
defines the search path for the directory containing the command.
Each alternative directory name is separated by a colon
.RB ( : ).
The default path is
.BR :/bin:/usr/bin .
If the command name contains a /, the search path is not used.
Otherwise, each directory in the path is searched for an executable file.
If the file has execute permission but is not an
.I a.out
file, it is assumed to be a file containing shell commands.
A subshell (i.e., a separate process) is spawned to read it.
A parenthesized command is also executed in a subshell.
.PP
.B Special commands.
.br
The following commands are executed in the shell process
and except where specified
no input output redirection is permitted for such commands.
.TP
.B #
For non-interactive shells, everything following the
.B #
is treated as a comment, i.e. the rest of the line is ignored.
For interactive shells, the
.B #
has no special effect.
.TP
.B :
No effect; the command does nothing.
.PD 0
.TP
.BI . \ file
Read and execute commands from
.I file
and return.  The search path
.B
.SM $PATH
is used to find the directory containing
.IR file .
.TP
\fBbreak\fR \*(OK\fIn\fR\*(CK
Exit from the enclosing
.B for
or
.B while
loop, if any.
If
.I n
is specified, break
.I n
levels.
.TP
\fBcontinue\fR \*(OK\fIn\fR\*(CK
Resume the next iteration of the enclosing
.B for
or
.B while
loop.  If
.I n
is specified, resume at the
.IR n -th
enclosing loop.
.TP
\fBcd\fR \*(OK\fIarg\fR\*(CK
Change the current directory to
.I arg.
The shell parameter
.B
.SM $HOME
is the default
.IR arg .
.TP
\fBeval\fR \*(OK\fIarg \fR...\*(CK
The arguments are read as input to the shell
and the resulting command(s) executed.
.TP
\fBexec\fR \*(OK\fIarg \fR...\*(CK
The command specified by the arguments is executed in place of this shell
without creating a new process.
Input output arguments may appear and if no other
arguments are given cause the shell input output to be modified.
.TP
\fBexit\fR \*(OK\fIn\fR\*(CK
Causes a non interactive shell to exit with the exit status specified by
.I n.
If
.I n
is omitted, the exit status is that of the last command executed.
(An end of file will also exit from the shell.)
.TP
\fBexport\fR \*(OK\fIname\fR ...\*(CK
The given names are marked for automatic export to the
.I environment
of subsequently-executed commands.
If no arguments are given, a list of exportable names is printed.
.TP
\fBlogin\fR \*(OK\fIarg\fR ...\*(CK
Equivalent to 'exec login arg ...'.
.TP
.BI read \ name\ ...
One line is read from the standard input;
successive words of the input are assigned to the variables
.I name
in order, with leftover words to the last variable.
The return code is 0 unless the end-of-file is encountered.
.TP
\fBreadonly\fR \*(OK\fIname \fR...\*(CK
The given names are marked readonly and
the values of the these names may not be changed
by subsequent assignment.
If no arguments are given, a list of all readonly names is printed.
.TP
\fBset\fR \*(OK\fB\-eknptuvx\fR \*(OK\fIarg \fR...\*(CK\*(CK
.RS
.PD 0
.TP 3m
.B \-e
If non interactive, exit immediately if a command fails.
.TP
.B \-k
All keyword arguments are placed in the environment for a command,
not just those that precede the command name.
.TP
.B \-n
Read commands but do not execute them.
.TP
.B \-t
Exit after reading and executing one command.
.TP
.B \-u
Treat unset variables as an error when substituting.
.TP
.B \-v
Print shell input lines as they are read.
.TP
.B \-x
Print commands and their arguments as they are executed.
.TP
.B \-
Turn off the
.B \-x
and
.B \-v
options.
.PD
.LP
These flags can also be used upon invocation of the shell.
The current set of flags may be found in
.BR $\- .
.LP
Remaining arguments are positional
parameters and are assigned, in order, to
.SM
.BR $1 ,
.SM
.BR $2 ,
etc.  If no arguments are given, the values of all names are printed.
.RE
.TP
.B shift
The positional parameters from
.SM
.BR $2 ...
are renamed
.SM
.BR $1 ...
.TP
.B times
Print the accumulated user and system times for processes run from the shell.
.TP
\fBtrap\fR \*(OK\fIarg\fR\*(CK \*(OK\fIn\fR\*(CK ...
.I Arg
is a command to be read and executed when the shell receives signal(s)
.I n.
(Note that
.I arg
is scanned once when the trap is set and once when the trap is taken.)
Trap commands are executed in order of signal number.  If
.I arg
is absent, all trap(s)
.I n
are reset to their original values.
If
.I arg
is the null
string, this signal is ignored by the shell and by invoked commands.
If
.I n
is 0, the command
.I arg
is executed on exit from the shell, otherwise upon receipt of signal
.I n
as numbered in
.IR sigvec (2).
.I Trap
with no arguments prints a list of commands associated with each signal number.
.TP
\fBumask \fR[ \fInnn\fR ]
The user file creation mask is set to the octal value
.I nnn
(see
.IR umask (2)).
If
.I nnn
is omitted, the current value of the mask is printed.
.TP
\fBwait\fP \*(OK\fIn\fP\*(CK
Wait for the specified process and report its termination status.  If
.I n
is not given, all currently active child processes are waited for.
The return code from this command is that of the process waited for.
.PD
.LP
.PP
.B Invocation.
.br
If the first character of argument zero is
.BR \- ,
commands are read from
.BR \s-2$HOME\s0/.\|profile ,
if such a file exists.
Commands are then read as described below.
The following flags are interpreted by the shell when it is invoked.
.PD 0
.TP 11n
.BI \-c \ string
If the
.B \-c
flag is present, commands are read from
.I string\|.
.TP 11n
.B \-s
If the
.B \-s
flag is present or if no arguments remain
then commands are read from the standard input.
Shell output is written to file descriptor 2.
.TP 11n
.B \-i
If the
.B \-i
flag is present or
if the shell input and output are attached to a terminal (as told by
.IR gtty )
then this shell is
.I interactive.
In this case the terminate signal SIGTERM (see
.IR sigvec (2))
is ignored (so that 'kill 0'
does not kill an interactive shell) and the interrupt signal
SIGINT is caught and ignored (so that
.B wait
is interruptible).
In all cases SIGQUIT is ignored by the shell.
.PD
.LP
The remaining flags and arguments are described under the
.B set
command.
.SH FILES
.RB $HOME/ . \^profile
.br
/tmp/sh*
.br
/dev/null
.SH SEE ALSO
csh(1),
test(1),
execve(2),
environ(7)
.SH DIAGNOSTICS
Errors detected by the shell, such as syntax errors cause the shell
to return a non zero exit status.
If the shell is being used non interactively
then execution of the shell file is abandoned.
Otherwise, the shell returns the exit status of
the last command executed (see also
.BR exit ).
.SH BUGS
If \*(LT\*(LT is used to provide standard input to an asynchronous
process invoked by &, the shell gets mixed up about naming the input document.
A garbage file /tmp/sh* is created, and the shell complains about
not being able to find the file by another name.
