.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)ps.1	6.5 (Berkeley) 3/10/88
.\"
.TH PS 1 "March 10, 1988"
.UC 4
.SH NAME
ps \- process status
.SH SYNOPSIS
.B ps
[
.B acegklnstuvwxU#
]
.SH PLEASE NOTE:
There is no man page for the MACH 3.0
.I ps,
this is the man page for the Berkeley 6.5 version.
.SH DESCRIPTION
.I Ps
prints information about processes.
Normally, only your processes are candidates to be printed by
.I ps;
specifying
.B a
causes other users' processes to be candidates to be printed;
specifying
.B x
includes processes without control terminals in the candidate pool.
.PP
All output formats include, for each process, the process id PID,
control terminal of the process TT, cpu time used by the process TIME
(this includes both user and system time), the state STAT of the process,
and an indication of the COMMAND which is running.
The state is given by a sequence of letters, e.g. ``RWNA''.
The first letter indicates the runnability of the process:
R for runnable processes,
T for stopped processes,
P for processes in page wait,
D for those in disk (or other short term) waits,
S for those sleeping for less than about 20 seconds,
and I for idle (sleeping longer than about 20 seconds)
processes.
Additional characters after these, if any,
indicate additional state information.
The letter W indicates that a process is swapped out,
showing W if it is, or a blank if it is loaded (in-core).
A process which has specified a soft limit on memory requirements
and which is exceeding that limit shows >; such a process is (necessarily)
not swapped.
An additional letter may indicate whether a process is running with altered
CPU scheduling priority (nice); if the process priority is reduced,
an N is shown, if the process priority has been artificially raised then
a `<' is shown.
The final optional letter
indicates any special treatment of the process for virtual
memory replacement; the letters correspond to options to the
.IR vadvise (2)
call; currently the possibilities are A standing for VA_ANOM and 
S for VA_SEQL.
An A typically represents a
.IR lisp (1)
in garbage collection, and S is typical of large image processing programs
which are using virtual memory to sequentially address voluminous data.
.PP
Here are the options:
.TP 5
.B a
asks for information about all processes with terminals (ordinarily
only one's own processes are displayed).
.TP 5
.B c
prints the command name, as stored internally in the system for purposes
of accounting, rather than the command arguments, which are kept
in the process' address space.  This is more reliable, if less informative,
since the process is free to destroy the latter information.
.TP 5
.B e
Asks for the environment to be printed as well as the arguments to the command.
.TP 5
.B g
Asks for all processes.
Without this option,
.I ps
only prints ``interesting'' processes.
Processes are deemed to be uninteresting if they are process group leaders.
This normally eliminates top-level command interpreters and processes
waiting for users to login on free terminals.
.TP 5
.B k
causes the file
.I /vmcore
is used in place of
.IR /dev/kmem " and " /dev/mem.
This is used for
postmortem system debugging.
.TP 5
.B l
asks for a long listing, with fields PPID, CP, PRI, NI, ADDR, SIZE, RSS and
WCHAN as described below.
.TP 5
.B n
Asks for numerical output.
In a long listing, the WCHAN field is printed numerically rather than
symbolically, or, in a user listing, the USER field is replaced by a
UID field.
.TP 5
.B s
Adds the size SSIZ of the kernel stack of each process (for use by system
maintainers) to the basic output format.
.TP 5
\fBt\fIx\fR
restricts output to processes whose controlling tty is \fIx\fR
(which should be specified as printed by
.I ps,
e.g.
.I t3
for tty3,
.I tco
for console,
.I td0
for ttyd0,
.I t?
for processes with no tty,
.I t
for processes at the current tty,
etc).
This option must be the last one given.
.TP 5
.B u
A user oriented output is produced.
This includes fields USER, %CPU, NICE, SIZE, and RSS as described below.
.TP 5
.B v
A version of the output containing virtual memory statistics is output.
This includes fields RE, SL, PAGEIN, SIZE, RSS, LIM, TSIZ, TRS, %CPU
and %MEM, described below.
.TP 5
.B w
Use a wide output format (132 columns rather than 80); if repeated,
e.g. ww, use arbitrarily wide output.
This information is used to decide how much of long commands to print.
.TP 5
.B x
asks even about processes with no terminal.
.TP
.B U
causes ps to update a private database where it keeps system
information.  Thus ``ps U'' should be included in the /etc/rc file.
.TP 5
.B #
A process number may be given,
(indicated here by #),
in which case the output
is restricted to that process.
This option must also be last.
.PP
A second argument is taken 
to be the file containing the system's
namelist.  Otherwise, /vmunix is used.
A third argument tells
.I ps
where to look for
.I core
if the
.B k
option is given, instead of /vmcore.
If a fourth argument is given, it
is taken to be the name of a swap file to use instead of
the default /dev/drum.
.PP
Fields which are not common to all output formats:
.PD 0
.IP USER 10
name of the owner of the process
.IP %CPU 10
cpu utilization of the process; this is a decaying average over up to
a minute of previous (real) time.  Since the time base over which this
is computed varies (since processes may be very young) it is possible
for the sum of all %CPU fields to exceed 100%.
.IP NICE 10
(or NI) process scheduling increment (see
.IR setpriority (2))
.IP SIZE 10
virtual size of the process (in 1024 byte units)
.IP RSS 10
real memory (resident set) size of the process (in 1024 byte units)
.IP LIM 10
soft limit on memory used, specified via a call to
.IR setrlimit (2);
if no limit has been specified then shown as \fIxx\fR
.IP TSIZ 10
size of text (shared program) image
.IP TRS 10
size of resident (real memory) set of text
.IP %MEM 10
percentage of real memory used by this process.
.IP RE 10
residency time of the process (seconds in core)
.IP SL 10
sleep time of the process (seconds blocked)
.IP PAGEIN 10
number of disk i/o's resulting from references by the process
to pages not loaded in core.
.IP UID 10
numerical user-id of process owner
.IP PPID 10
numerical id of parent of process
.IP CP 10
short-term cpu utilization factor (used in scheduling)
.IP PRI 10
process priority (non-positive when in non-interruptible wait)
.IP ADDR 10
swap address of the process
.IP WCHAN 10
event on which process is waiting (an address in the system).
A symbol is chosen that classifies the address, unless numerical
output is requested (see the 
.B n
flag).
In this case, the initial part of the address is
trimmed off and is printed hexadecimally, e.g., 0x80004000 prints as 4000.
.sp
.IP F 10
flags associated with process as in
.RI < sys/proc.h >:
.br
.PP
.sp
.nf
.ta 6n 18n 26n
	SLOAD	000001	in core
	SSYS	000002	swapper or pager process
	SLOCK	000004	process being swapped out
	SSWAP	000008	save area flag
	STRC	000010	process is being traced
	SWTED	000020	another tracing flag
	SULOCK	000040	user settable lock in core
	SPAGE	000080	process in page wait state
	SKEEP	000100	another flag to prevent swap out
	SDLYU	000200	delayed unlock of pages
	SWEXIT	000400	working on exiting
	SPHYSIO	000800	doing physical i/o (bio.c)
	SVFORK	001000	process resulted from vfork()
	SVFDONE	002000	another vfork flag
	SNOVM	004000	no vm, parent in a vfork()
	SPAGI	008000	init data space on demand from inode
	SANOM	010000	system detected anomalous vm behavior
	SUANOM	020000	user warned of anomalous vm behavior
	STIMO	040000	timing out during sleep
	SDETACH	080000	detached inherited by init
	SOUSIG	100000	using old signal mechanism
.fi
.PD
.PP
A process that has exited and has a parent that has not
yet waited for the process is marked <defunct>; a process
which is blocked trying to exit is marked <exiting>;
.I Ps
makes an educated guess as to the file name
and arguments given when the process was created
by examining memory or the swap area.
The method is inherently somewhat unreliable and in any event
a process is entitled to destroy this information,
so the names cannot be counted on too much.
.SH FILES
.ta \w'/etc/psdatabase 'u
/vmunix	system namelist
.br
/dev/kmem	kernel memory
.br
/dev/drum	swap device
.br
/vmcore	core file
.br
/dev	searched to find swap device and tty names
.br
/etc/psdatabase	system namelist, device, and wait channel information
.SH "SEE ALSO"
kill(1), w(1)
.SH BUGS
Things can change while
.I ps
is running; the picture it gives is only a close
approximation to reality.
