.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)passwd.1	6.4 (Berkeley) 6/5/86
.\"
.TH PASSWD 1 "June 5, 1986"
.UC 4
.SH NAME
chfn, chsh, passwd \- change password file information
.SH SYNOPSIS
.B passwd
[
.B \-f
] [
.B \-s
] [ name ]
.SH DESCRIPTION
This command changes (or installs)
a password, login shell
.RB ( \-s
option), or GECOS information field
.RB ( \-f
option)
associated with the user
.IR name
(your own name by default).
.PP
When altering a password,
the program prompts for the current password and then for the new one.
The caller must supply both.
The new password must be typed twice to forestall mistakes.
.PP
New passwords must be at least four characters long if they use
a sufficiently rich alphabet and at least six characters long
if monocase.
These rules are relaxed if you are insistent enough.
.PP
Only the owner of the name or the super-user may change a password;
the owner must prove he knows the old password.
.PP
When altering a login shell,
.I passwd
displays the current login shell and then prompts
for the new one.
The new login shell must be one of the approved shells
listed in
.I /etc/shells
unless you are the super-user.
If
.I /etc/shells
does not exist, the only shells that may be specified are
.I /bin/sh
and
.IR /bin/csh .
.PP
The super-user may change anyone's login shell; normal users
may only change their own login shell.
.PP
When altering the GECOS information field,
.I passwd
displays the current information, broken into
fields, as interpreted by the
.IR finger (1)
program, among others, and prompts for new values.
These fields include a user's
``real life'' name, office room number,
office phone number, and home phone number.
Included in each prompt is a default value,
which is enclosed between brackets.
The default value is accepted simply by typing a carriage
return.  To enter a blank field, the word ``none'' may
be typed.  Below is a sample run:
.IP
.B "Name [Biff Studsworth II]:"
.br
.B "Room number (Exs: 597E or 197C) []:"
521E
.br
.B "Office Phone (Ex: 1632) []:"
1863
.br
.B "Home Phone (Ex: 987532) [5771546]:"
none
.sp
.PP
.I Passwd
allows phone numbers to be entered with or without hyphens.
It is a good idea to run
.I finger
after changing the GECOS information
to make sure everything is setup properly.
.PP
The super-user may change anyone's GECOS information; normal
users may only change their own.
.SH FILES
/etc/passwd	The file containing all of this information
.br
/etc/shells	The list of approved shells
.SH "SEE ALSO"
login(1), finger(1), passwd(5), crypt(3)
.br
Robert Morris and Ken Thompson,
.I UNIX password security
