.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)mv.1	6.1 (Berkeley) 4/29/85
.\"
.TH MV 1 "April 29, 1985"
.UC 4
.SH NAME
mv \- move or rename files
.SH SYNOPSIS
.B mv
[
.B \-i
] [
.B \-f
] [
.B \-
] file1 file2
.PP
.B mv
[
.B \-i
] [
.B \-f
] [
.B \-
] file ... directory
.SH DESCRIPTION
.I Mv
moves (changes the name of)
.I file1
to
.IR file2 .
.PP
If
.I file2
already exists, it is removed before
.I file1
is moved.  If
.I file2
has a mode which forbids writing,
.I mv
prints the mode (see
.IR chmod (2))
and reads the standard input to obtain a line; if the line begins with
.B y,
the move takes place; if not,
.I mv
exits.
.PP
In the second form, one or more
.I files
(plain files or directories) are moved to the
.I directory
with their original file-names.
.PP
.I Mv
refuses to move a file onto itself.
.PP
Options:
.TP
.B \-i
stands for interactive mode. Whenever a move is to supercede an
existing file, the user is prompted by the name of the file
followed by a question mark. If he answers with a line starting
with 'y', the move continues. Any other reply prevents the move from
occurring.
.TP
.B \-f
stands for force. This option overrides any mode restrictions or the
\-i switch.
.TP
.B \-
means interpret all the following arguments to 
.I mv
as file names.  This allows file names starting with minus.
.SH "SEE ALSO"
cp(1), ln(1)
.SH BUGS
If
.I file1
and
.I file2
lie on different file systems,
.I mv
must copy the file and delete the original.
In this case the owner name becomes that of the copying process and any
linking relationship with other files is lost.
