.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)make.1	6.4 (Berkeley) 8/24/87
.\"
.TH MAKE 1 "August 24, 1987"
.UC 4
.SH NAME
make \- maintain program groups
.SH SYNOPSIS
.B make
[
.B \-f
makefile ] [ option ] ...
file ...
.SH DESCRIPTION
.I Make
executes commands in
.I makefile
to update
one or more target
.IR names .
.I Name
is typically a program.
If no
.B \-f
option is present, `makefile' and `Makefile' are
tried in order.
If
.I makefile
is `\-', the standard input is taken.
More than one
.B \-f
option may appear.
.PP
.I Make
updates a target if it depends on prerequisite files
that have been modified since the target was last modified,
or if the target does not exist.
.PP
.I Makefile
contains a sequence of entries that specify dependencies.
The first line of an entry is a
blank-separated list of targets, then a colon,
then a list of prerequisite files.
Text following a semicolon, and all following lines
that begin with a tab, are shell commands
to be executed to update the target.
If a name appears on the left of more than one `colon' line, then it depends
on all of the names on the right of the colon on those lines, but only
one command sequence may be specified for it.
If a name appears on a line with a double colon
.B "::"
then the command sequence following that line is performed
only if the name is out of date with respect to the names to the right
of the double colon, and is not affected by other double colon lines
on which that name may appear.
.PP
Two special forms of a name are recognized.
A name like
.IR a ( b )
means the file named
.I b
stored in the archive named
.I a.
A name like
.IR a (( b ))
means the file stored in archive
.I a
containing the entry point
.I b.
.PP
Sharp and newline surround comments.
.PP
The following makefile says that `pgm' depends on two
files `a.o' and `b.o', and that they in turn depend on
`.c' files and a common file `incl'.
.RS 
.HP
.PD 0
.nf
pgm: a.o b.o
cc a.o b.o \-lm \-o pgm
.HP
a.o: incl a.c
cc \-c a.c
.HP
b.o: incl b.c
cc \-c b.c
.fi
.RE
.PD
.PP
.I Makefile
entries of the form
.PP
.IP
string1 = string2
.PP
are macro definitions.
Subsequent appearances of 
.RI $( string1 )
or
.RI ${ string1 }
are replaced by
.IR string2 .
If
.I string1
is a single character, the parentheses or braces
are optional.
.PP
.I Make 
infers prerequisites for files for which
.I makefile
gives no construction commands.
For example, a
`.c' file may be inferred as prerequisite for a `.o' file
and be compiled to produce the `.o' file.
Thus the preceding example can be done more briefly:
.RS
.HP
.PD 0
.nf
pgm: a.o b.o
cc a.o b.o \-lm \-o pgm
.HP
a.o b.o: incl
.fi
.RE
.PD
.PP
Prerequisites are inferred according to selected suffixes
listed as the `prerequisites' for the special name `.SUFFIXES';
multiple lists accumulate;
an empty list clears what came before.
Order is significant; the first possible name for which both
a file and a rule as described in the next paragraph exist
is inferred.
The default list is
.IP
\&.SUFFIXES: .out .o .c .e .r .f .y .l .s .p
.PP
The rule to create a file with suffix
.I s2
that depends on a similarly named file with suffix
.I s1
is specified as an entry
for the `target'
.IR s1s2 .
In such an entry, the special macro $* stands for
the target name with suffix deleted, $@ for the full target name,
$< for the complete list of prerequisites,
and
$? for the list of prerequisites that are out of date.
For example, a rule for making
optimized `.o' files from `.c' files is
.IP
\&.c.o: ; cc \-c \-O \-o $@ $*.c
.PP
Certain macros are used by the default inference rules
to communicate optional arguments to
any resulting compilations.
In particular,
`CFLAGS' is used for
.IR cc (1)
options,
`FFLAGS' for
.IR f77 (1)
options,
`PFLAGS' for
.IR pc (1)
options,
and `LFLAGS' and `YFLAGS' for 
.I lex
and
.IR yacc (1)
options.  In addition, the macro `MFLAGS' is filled in
with the initial command line options supplied to 
.IR make .
This simplifies maintaining a hierarchy of makefiles as
one may then invoke 
.I make
on makefiles in subdirectories and pass along useful options
such as
.BR \-k .
.PP
The environment is read by \fImake\fP.  All variables are assumed to be
macro definitions and processed as such.  The environmental variables
are processed before any makefile and after the internal rules; thus,
macro assignments in a makefile override environmental variables.  The
\fB-e\fP option causes the environment to override the macro assignments
in a makefile.  As with macro assignments, environmental variables are
always overriden by the command line.
.PP
Another special macro is `VPATH'.
The `VPATH' macro should be set to a list of directories separated by colons.
When
.I make
searches for a file as a result of a dependency relation, it will
first search the current directory and then each of the directories on the
`VPATH' list.
If the file is found, the actual path to the file will be used, rather than
just the filename.
If `VPATH' is not defined, then only the current directory is searched.
.PP
One use for `VPATH' is when one has several programs that compile from the
same source.
The source can be kept in one directory and each set of
object files (along with a separate
.IR makefile )
would be in a separate subdirectory.
The `VPATH' macro would point to the source directory in this case.
.PP
Command lines are executed one at a time, each by its
own shell.
A line is printed when it is executed unless
the special target `.SILENT'
is in 
.I makefile,
or the first character of the command is `@'.
.PP
Commands returning nonzero status (see
.IR intro (1))
cause
.I make
to terminate unless
the special target `.IGNORE' is in
.I makefile
or the command begins with
<tab><hyphen>.
.PP
Interrupt and quit cause the target to be deleted
unless the target is a directory or
depends on the special name `.PRECIOUS'.
.PP
Other options:
.TP
.B \-e
Environmental variables override assignments within makefiles.
.TP
.B \-i
Equivalent to the special entry `.IGNORE:'.
.TP
.B \-k
When a command returns nonzero status,
abandon work on the current entry, but
continue on branches that do not depend on the current entry.
.TP
.B \-n
Trace and print, but do not execute the commands
needed to update the targets.
.TP
.B \-t
Touch, i.e. update the modified date of targets, without
executing any commands.
.TP
.B \-r
Equivalent to an initial special entry `.SUFFIXES:'
with no list.
.TP 
.B \-s
Equivalent to the special entry
`.SILENT:'.
.SH FILES
makefile, Makefile
.br
.SH "SEE ALSO"
sh(1), touch(1), f77(1), pc(1), getenv(3)
.br
S. I. Feldman
.I
Make \- A Program for Maintaining Computer Programs
.SH BUGS
Some commands return nonzero status inappropriately.
Use
.B \-i
to overcome the difficulty.
.br
Commands that are directly executed by the shell,
notably
.IR  cd (1),
are ineffectual across newlines in
.I make.
.PP
`VPATH' is intended to act like the System V `VPATH' support,
but there is no guarantee that it functions identically.
