.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)ls.1	6.6 (Berkeley) 9/30/87
.\"
.TH LS 1 "September 30, 1987"
.UC
.SH NAME
ls \- list contents of directory
.SH SYNOPSIS
.B ls
[
.B \-acdfgilqrstu1ACLFR
] name ...
.br
.SH DESCRIPTION
For each directory argument,
.I ls
lists the contents of the directory;
for each file argument,
.I ls
repeats its name and any other information requested.
By default, the output is sorted alphabetically.
When no argument is given, the current directory is listed.
When several arguments are given,
the arguments are first sorted appropriately,
but file arguments are processed
before directories and their contents.
.PP
There are a large number of options:
.TP
.B \-l
List in long format, giving mode, number of links, owner,
size in bytes, and time of last modification
for each file.
(See below.)
If the file is a special file the size field will instead contain
the major and minor device numbers.
If the file is a symbolic link the pathname of
the linked-to file is printed preceded by ``\->''.
.TP
.B \-g
Include the group ownership of the file in a long output.
.TP
.B \-t
Sort by time modified (latest first) instead of
by name.
.TP
.B \-a
List all entries; in the absence of this option, entries whose
names begin with a period
.RB ( . )
are
.I not
listed.
.TP
.B \-s
Give size in kilobytes of each file.
.TP
.B \-d
If argument is a directory, list only its name;
often used with \fB\-l\fR to get the status of a directory.
.TP
.B \-L
If argument is a symbolic link, list the file or directory the link references
rather than the link itself.
.TP
.B \-r
Reverse the order of sort to get reverse alphabetic
or oldest first as appropriate.
.TP
.B \-u
Use time of last access instead of last
modification for sorting
(with the \fB\-t\fP option)
and/or printing (with the \fB\-l\fP option).
.TP
.B \-c
Use time when file status was last changed for sorting or printing.
.TP
.B \-i
For each file, print the i-number in the first column of the report.
.TP
.B \-f
Force each argument to be interpreted as a directory
and list the name found in each slot.
This option turns off
.B "\-l, \-t, \-s,"
and
.B \-r,
and
turns on
.B \-a;
the order is the order in which entries
appear in the directory.
.TP
.B \-F
cause directories to be marked with a trailing `/',
sockets with a trailing `=',
symbolic links with a trailing `@', and executable
files with a trailing `*'.
.TP
.B \-R
recursively list subdirectories encountered.
.TP
.B \-1
force one entry per line output format; this is the default when
output is not to a terminal.
.TP
.B \-C
force multi-column output; this is the default when output is to a terminal.
.TP
.B \-q
force printing of non-graphic characters in file names as
the character `?'; this is the default when output is to a terminal.
.PP
The mode printed under the
.B \-l
option contains 11 characters
which are interpreted
as follows:
the first character is
.TP 3
.B d
if the entry is a directory;
.br
.ns
.TP 3
.B b
if the entry is a block-type special file;
.br
.ns
.TP 3
.B c
if the entry is a character-type special file;
.br
.ns
.TP 3
.B l
if the entry is a symbolic link;
.br
.ns
.TP
.B s
if the entry is a socket, or
.br
.ns
.TP 3
.B  \-
if the entry is a plain file.
.PP
The next 9 characters are interpreted
as three sets of three bits each.
The first set refers to owner permissions;
the next refers to permissions to others in the same user-group;
and the last to all others.
Within each set the three characters indicate
permission respectively to read, to write, or to
execute the file as a program.
For a directory, `execute' permission is interpreted
to mean permission to search the directory.
The permissions are indicated as follows:
.TP 3
.B  r
if the file is readable;
.br
.ns
.TP 3
.B  w
if the file is writable;
.br
.ns
.TP 3
.B  x
if the file is executable;
.br
.ns
.TP 3
.B  \-
if the indicated permission is not granted.
.PP
The group-execute permission character is given as \fBs\fP if the file has
the set-group-id bit set; likewise the user-execute permission character is
given as \fBs\fP if the file has the set-user-id bit set.  These are given
as \fBS\fP (capitalized) if the corresponding execute permission is NOT
set.
.PP
The last character of the mode (normally `x' or `\-') is 
.B t
if the 1000 bit of the mode is on.
See
.IR  chmod (1)
for the meaning of this mode.  This is given as \fBT\fP (capitalized) if the
corresponding execute permission is NOT set.
.PP
When the sizes of the files in a directory
are listed, a total count of blocks,
including indirect blocks is printed.
.SH FILES
/etc/passwd to get user id's for
`ls \-l'.
.br
/etc/group to get group id's for
`ls \-g'.
.SH BUGS
Newline and tab are considered printing characters in file names.
.PP
The output device is assumed to be 80 columns wide.
.PP
The option setting based on whether the output is a teletype is
undesirable as ``ls\ \-s'' is much different than ``ls\ \-s\ |\ lpr''.
On the other hand, not doing this setting would make old shell scripts
which used
.I ls
almost certain losers.
