.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)ln.1	6.3 (Berkeley) 11/26/86
.\"
.TH LN 1 "November 26, 1986"
.UC 4
.SH NAME
ln \- make links
.SH SYNOPSIS
.B ln
[
.B \-s
]
sourcename [ targetname ]
.br
.B ln
[
.B \-s
]
sourcename1 sourcename2 [ sourcename3 ... ] targetdirectory
.SH DESCRIPTION
A link is a directory entry referring
to a file; the same file (together with
its size, all its protection
information, etc.)
may have several links to it.
There are two kinds of links: hard links and symbolic links.
.PP
By default
.I ln
makes hard links.
A hard link to a file is indistinguishable from the
original directory entry; any changes to a
file are effective independent of the name used
to reference the file.  Hard links may not refer to directories
(unless the proper incantations are supplied) and may not span
file systems.
.PP
The
.B \-s
option causes
.I ln
to create symbolic links.
A symbolic link contains the name of the file to
which it is linked.  The referenced file is used when an
.IR open (2)
operation is performed on the link.
A
.IR stat (2)
on a symbolic link will return the linked-to file; an
.IR lstat (2)
must be done to obtain information about the link.
The
.IR readlink (2)
call may be used to read the contents of a symbolic link.
Symbolic links may span file systems and may refer to directories.
.PP
Given one or two arguments,
.I ln
creates a link to an existing file
.IR sourcename .
If
.I targetname
is given, the link has that name;
.I targetname
may also be a directory in which to place the link;
otherwise it is placed in the current directory.
If only the directory is specified, the link will be made
to the last component of
.IR sourcename .
.PP
Given more than two arguments,
.I ln
makes links in 
.I targetdirectory
to all the named source files.
The links made will have the same name as the files being linked to.
.SH "SEE ALSO"
rm(1), cp(1), mv(1), link(2), readlink(2), stat(2), symlink(2)
