.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)kill.1	6.2 (Berkeley) 4/20/86
.\"
.TH KILL 1 "April 20, 1986"
.UC 4
.SH NAME
kill \- terminate a process with extreme prejudice
.SH SYNOPSIS
.B kill
[
.BR \- sig
]
processid ...
.br
.B kill
.B \-l
.SH DESCRIPTION
.I Kill
sends the TERM (terminate, 15) signal to the specified processes.
If a signal name or number preceded by `\-' is given
as first argument, that signal is sent instead of
terminate
(see
.IR  sigvec (2)).
The signal names are listed by
`kill \-l', and are as given in
.I /usr/include/signal.h,
stripped of the common SIG prefix.
.PP
The terminate signal will kill processes that do not catch the signal;
`kill \-9 ...' is a sure kill, as the KILL (9) signal cannot be caught.
By convention, if process number 0 is specified, all members
in the process group (i.e. processes resulting from 
the current login) are signaled (but beware: this works only
if you use
.IR sh (1);
not if you use
.IR csh (1).)
Negative process numbers also have special meanings; see
.IR kill (2)
for details.
.PP
The killed processes must belong
to the current user unless
he is the super-user.
.PP
The process number of an asynchronous process
started with `&' is reported by the shell.
Process numbers can also be found by using
.IR ps (1).
.I Kill
is a built-in to
.IR csh (1);
it allows job specifiers of the form ``%...'' as arguments
so process id's are not as often used as
.I kill
arguments.
See
.IR csh (1)
for details.
.SH "SEE ALSO"
csh(1), ps(1), kill(2), sigvec(2)
.SH BUGS
A replacement for ``kill 0''
for
.IR csh (1)
users should be provided.
