.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)diff.1	6.4 (Berkeley) 5/19/86
.\"
.TH DIFF 1 "May 19, 1986"
.UC 4
.SH NAME
diff \- differential file and directory comparator
.SH SYNOPSIS
.B diff
[
.B \-l
] [
.B \-r
] [
.B \-s
] [
\fB\-cefhn\fR
] [
.B \-biwt
] dir1 dir2
.br
.B diff
[
\fB\-cefhn
] [
\fB\-biwt\fR
] file1 file2
.br
.B diff
[
.BI \-D string
] [
.B \-biw
]
file1 file2
.SH DESCRIPTION
If both arguments are directories,
.I diff
sorts the contents of the directories by name, and then runs the
regular file
.I diff
algorithm (described below)
on text files which are different.
Binary files which differ,
common subdirectories, and files which appear in only one directory
are listed.
Options when comparing directories are:
.TP
.B \-l
long output format; each text file
.I diff
is piped through
.IR pr (1)
to paginate it,
other differences are remembered and summarized
after all text file differences are reported.
.TP
.B \-r
causes application of
.I diff
recursively to common subdirectories encountered.
.TP
.B \-s
causes 
.I diff
to report files which are the same, which are otherwise not mentioned.
.TP
.B \-Sname
starts a directory
.I diff
in the middle beginning with file
.I name.
.PP
When run on regular files, and when comparing text files which differ
during directory comparison,
.I diff
tells what lines must be changed in the files to bring them into agreement.
Except in rare circumstances,
.I diff
finds a smallest sufficient set of file differences.
If neither
.I file1
nor
.I file2
is a directory, then either
may be given as `\-', in which case the standard input is used.
If
.I file1
is a directory,
then a file in that directory whose file-name is the same as the file-name of
.I file2
is used (and vice versa).
.PP
There are several options for output format;
the default output format contains lines of these forms:
.IP "" 5
.I n1
a
.I n3,n4
.br
.I n1,n2
d
.I n3
.br
.I n1,n2
c
.I n3,n4
.PP
These lines resemble
.I ed
commands to convert
.I file1
into
.IR file2 .
The numbers after the letters pertain to
.IR file2 .
In fact, by exchanging `a' for `d' and reading backward
one may ascertain equally how to convert 
.I file2
into
.IR file1 .
As in 
.I ed,
identical pairs where
.I n1
=
.I n2
or
.I n3
=
.I n4
are abbreviated as a single number.
.PP
Following each of these lines come all the lines that are
affected in the first file flagged by `<', 
then all the lines that are affected in the second file
flagged by `>'.
.PP
Except for
\fB\-b, -w, -i\fP or \fB-t\fP
which may be given with any of the others,
the following options are mutually exclusive:
.TP 9
.B \-e
produces a script of
.I "a, c"
and 
.I d
commands for the editor
.I ed,
which will recreate
.I file2
from
.IR file1 .
In connection with
.BR \-e ,
the following shell program may help maintain
multiple versions of a file.
Only an ancestral file ($1) and a chain of 
version-to-version
.I ed
scripts ($2,$3,...) made by
.I diff
need be on hand.
A `latest version' appears on
the standard output.
.IP
\ \ \ \ \ \ \ \ (shift; cat $*; echo \'1,$p\') \(bv ed \- $1
.IP
Extra commands are added to the output when comparing directories with
.B \-e,
so that the result is a
.IR sh (1)
script for converting text files which are common to the two directories
from their state in
.I dir1
to their state in
.I dir2.
.TP 9
.B \-f
produces a script similar to that of
.B \-e,
not useful with
.I ed,
and in the opposite order.
.TP 9
.B \-n
produces a script similar to that of
.B \-e,
but in the opposite order and with a count of changed lines on each
insert or delete command.  This is the form used by
.IR rcsdiff (1).
.TP 9
.B \-c
produces a diff with lines of context.
The default is to present 3 lines of context and may be changed, e.g to 10, by
.BR \-c10 \&.
With
.B \-c
the output format is modified slightly:
the output beginning with identification of the files involved and
their creation dates and then each change is separated
by a line with a dozen *'s.
The lines removed from
.I file1
are marked with `\(mi '; those added to
.I file2
are marked `+ '.  Lines which are changed from one
file to the other are marked in both files with with `! '.

Changes which lie within <context> lines of each other are grouped
together on output.  (This is a change from the previous ``diff -c''
but the resulting output is usually much easier to interpret.)
.TP 9
.B \-h
does a fast, half-hearted job.
It works only when changed stretches are short
and well separated,
but does work on files of unlimited length.
.TP
.B \-Dstring
causes
.I diff
to create a merged version of
.I file1
and
.I file2
on the standard output, with C preprocessor controls included so that
a compilation of the result without defining \fIstring\fR is equivalent
to compiling
.I file1,
while defining
.I string
will yield
.I file2.
.TP 9
.B \-b
causes trailing blanks (spaces and tabs) to be ignored, and other
strings of blanks to compare equal.
.TP 9
.B \-w
is similar to
.B \-b
but causes whitespace (blanks and tabs) to be totally ignored.  E.g.,
``if\ (\ a\ ==\ b\ )'' will compare equal to ``if(a==b)''.
.TP 9
.B \-i
ignores the case of letters.  E.g., ``A'' will compare equal to ``a''.
.TP 9
.B \-t
will expand tabs in output lines.  Normal or
.B \-c
output adds character(s) to the front of each line which may screw up
the indentation of the original source lines and make the output listing
difficult to interpret.  This option will preserve the original source's
indentation.
.SH FILES
/tmp/d?????
.br
/usr/lib/diffh for 
.B \-h
.br
/bin/diff for directory diffs
.br
/bin/pr
.SH "SEE ALSO"
cmp(1), cc(1), comm(1), ed(1), diff3(1)
.SH DIAGNOSTICS
Exit status is 0 for no differences, 1 for some, 2 for trouble.
.SH BUGS
Editing scripts produced under the
.BR \-e " or"
.BR \-f " option are naive about"
creating lines consisting of a single `\fB.\fR'.
.PP
When comparing directories with the
\fB\-b, -w\fP or \fB-i\fP
options specified,
.I diff
first compares the files ala
.I cmp,
and then decides to run the
.I diff
algorithm if they are not equal.
This may cause a small amount of spurious output if the files
then turn out to be identical because the only differences are
insignificant blank string or case differences.
