.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)dd.1	6.1 (Berkeley) 4/29/85
.\"
.TH DD 1 "April 29, 1985"
.UC 4
.SH NAME
dd \- convert and copy a file
.SH SYNOPSIS
.B dd
[option=value] ...
.SH DESCRIPTION
.I Dd
copies the specified input file
to the specified output with
possible conversions.
The standard input and output are used by default.
The input and output block size may be
specified to take advantage of raw physical I/O.
.PP
.br
.ns
.TP 15
.I option
.I values
.br
.ns
.TP 
if=
input file name; standard input is default
.br
.ns
.TP 
of=
output file name; standard output is default
.br
.ns
.TP 
.RI ibs= n
input block size
.I n
bytes (default 512)
.br
.ns
.TP 
.RI obs= n
output block size (default 512)
.br
.ns
.TP 
.RI bs= n
set both input and output block size,
superseding
.I ibs
and
.I obs;
also, if no conversion is specified,
it is particularly efficient since no copy need be done
.br
.ns
.TP 
.RI cbs= n
conversion buffer size
.br
.ns
.TP 
.RI skip= n
skip
.IR n ""
input records before starting copy
.br
.ns
.TP
.RI files= n
copy
.I n
input files before terminating (makes sense only
where input is a magtape or similar device).
.br
.ns
.TP 
.RI seek= n
seek
.I n
records from beginning of output file before copying
.br
.ns
.TP 
count=\fIn\fR
copy only
.IR n ""
input records
.br
.ns
.TP 
conv=ascii
.ds h \h'\w'conv='u'
convert EBCDIC to ASCII
.br
.ns
.IP \*hebcdic
convert ASCII to EBCDIC
.br
.ns
.IP \*hibm
slightly different map of ASCII to EBCDIC
.br
.ns
.IP \*hblock
convert variable length records to fixed length
.br
.ns
.IP \*hunblock
convert fixed length records to variable length
.br
.ns
.IP \*hlcase
map alphabetics to lower case
.br
.ns
.IP \*hucase
map alphabetics to upper case
.br
.ns
.IP \*hswab
swap every pair of bytes
.br
.ns
.IP \*hnoerror
do not stop processing on an error
.br
.ns
.IP \*hsync
pad every input record to
.I  ibs
.br
.ns
.IP "\*h... , ..."
several comma-separated conversions
.PP
.fi
Where sizes are specified,
a number of bytes is expected.
A number may end with
.B "k, b"
or
.B w
to specify multiplication by
1024, 512, or 2 respectively;
a pair of numbers may be separated by
.B x
to indicate a product.
.PP
.I Cbs
is used only if
.I ascii,
.I unblock,
.I ebcdic,
.I ibm,
or
.I block
conversion is specified.
In the first two cases,
.I cbs
characters are placed into the conversion buffer, any specified
character mapping is done,
trailing blanks trimmed and new-line added
before sending the line to the output.
In the latter three cases, characters are read into the
conversion buffer, and blanks added
to make up an
output record of size
.IR cbs .
.PP
After completion,
.I dd
reports the number of whole and partial input and output
blocks.
.PP
For example, to read an EBCDIC tape blocked ten 80-byte
EBCDIC card images per record into the ASCII file
.I x:
.IP
.nf
dd if=/dev/rmt0 of=x ibs=800 cbs=80 conv=ascii,lcase
.fi
.PP
Note the use of raw magtape.
.I Dd
is especially suited to I/O on the raw
physical devices because it allows reading
and writing in arbitrary record sizes.
.SH "SEE ALSO"
cp(1), tr(1)
.SH DIAGNOSTICS
f+p records in(out): numbers of full and partial records read(written)
.SH BUGS
The ASCII/EBCDIC conversion tables are
taken
from the 256 character standard in
the CACM Nov, 1968.
The `ibm' conversion, while less blessed as a standard,
corresponds better to certain IBM print train conventions.
There is no universal solution.
.br
One must specify ``conv=noerror,sync'' when copying
raw disks with bad sectors to insure 
.I dd
stays synchronized.
.PP
Certain combinations of arguments to 
.I conv=
are permitted.
However, the
.I block
or
.I unblock
option cannot be combined with
.IR ascii ,
.IR ebcdic ""
or
.IR ibm .
Invalid combinations
.I "silently ignore"
all but the last mutually-exclusive keyword.
