.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)csh.1	6.11 (Berkeley) 4/24/88
.\"
.TH CSH 1 "April 24, 1988"
.UC 4
.de sh
.br
.ne 5
.PP
\fB\\$1\fR
.PP
..
.if n .ds ua ^
.if t .ds ua \(ua
.if n .ds aa '
.if t .ds aa \(aa
.if n .ds ga `
.if t .ds ga \(ga
.if t .tr *\(**
.SH NAME
csh \- a shell (command interpreter) with C-like syntax
.SH SYNOPSIS
.B csh
[
.B \-cef\^instvVxX
] [
arg ...
]
.SH DESCRIPTION
.I Csh
is a first implementation of a command language interpreter
incorporating a history mechanism (see \fBHistory Substitutions\fP),
job control facilities (see \fBJobs\fP), interactive file name
and user name completion (see \fBFile Name Completion\fP),
and a C-like syntax.
So as to be able to use its job control facilities, users of
.I csh
must (and automatically) use the new tty driver fully described in
.IR tty (4).
This new tty driver allows generation of interrupt characters
from the keyboard to tell jobs to stop.  See
.IR stty (1)
for details on setting options in the new tty driver.
.PP
An instance of
.I csh
begins by executing commands from the file `.cshrc' in the
.I home
directory of the invoker.
If this is a login shell then it also executes commands from the file
`.login' there.
It is typical for users on crt's to put the command ``stty crt'' in their
.I \&.login
file, and to also invoke
.IR tset (1)
there.
.PP
In the normal case, the shell will then begin reading commands from the
terminal, prompting with `% '.
Processing of arguments and the use of the shell to process files
containing command scripts will be described later.
.PP
The shell then repeatedly performs the following actions:
a line of command input is read and broken into
.IR words .
This sequence of words is placed on the command history list and then parsed.
Finally each command in the current line is executed.
.PP
When a login shell terminates it executes commands from the file `.logout'
in the users home directory.
.sh "Lexical structure"
The shell splits input lines into words at blanks and tabs with the
following exceptions.
The characters
`&' `|' `;' `<' `>' `(' `)'
form separate words.
If doubled in `&&', `|\|\||', `<<' or `>>' these pairs form single words.
These parser metacharacters may be made part of other words, or prevented their
special meaning, by preceding them with `\e'.
A newline preceded by a `\e' is equivalent to a blank.
.PP
In addition strings enclosed in matched pairs of quotations,
`\*(aa', `\*(ga' or `"',
form parts of a word; metacharacters in these strings, including blanks
and tabs, do not form separate words.
These quotations have semantics to be described subsequently.
Within pairs of `\'' or `"' characters a newline preceded by a `\e' gives
a true newline character.
.PP
When the shell's input is not a terminal,
the character `#' introduces a comment which continues to the end of the
input line.
It is prevented this special meaning when preceded by `\e'
and in quotations using `\`', `\'', and `"'.
.sh "Commands"
A simple command is a sequence of words, the first of which
specifies the command to be executed.
A simple command or
a sequence of simple commands separated by `|' characters
forms a pipeline.
The output of each command in a pipeline is connected to the input of the next.
Sequences of pipelines may be separated by `;', and are then executed
sequentially.
A sequence of pipelines may be executed without immediately 
waiting for it to terminate by following it with an `&'.
.PP
Any of the above may be placed in `(' `)' to form a simple command (which
may be a component of a pipeline, etc.)
It is also possible to separate pipelines with `|\|\||' or `&&' indicating,
as in the C language,
that the second is to be executed only if the first fails or succeeds
respectively. (See
.I Expressions.)
.sh "Jobs"
The shell associates a \fIjob\fR with each pipeline.  It keeps
a table of current jobs, printed by the
\fIjobs\fR command, and assigns them small integer numbers.  When
a job is started asynchronously with `&', the shell prints a line which looks
like:
.PP
.DT
	[1] 1234
.PP
indicating that the job which was started asynchronously was job number
1 and had one (top-level) process, whose process id was 1234.
.PP
If you are running a job and wish to do something else you may hit the key
\fB^Z\fR (control-Z) which sends a STOP signal to the current job.
The shell will then normally indicate that the job has been `Stopped',
and print another prompt.  You can then manipulate the state of this job,
putting it in the background with the \fIbg\fR command, or run some other
commands and then eventually bring the job back into the foreground with
the foreground command \fIfg\fR.  A \fB^Z\fR takes effect immediately and
is like an interrupt in that pending output and unread input are discarded
when it is typed.  There is another special key \fB^Y\fR which does 
not generate a STOP signal until a program attempts to
.IR read (2)
it.
This can usefully be typed ahead when you have prepared some commands
for a job which you wish to stop after it has read them.
.PP
A job being run in the background will stop if it tries to read
from the terminal.  Background jobs are normally allowed to produce output,
but this can be disabled by giving the command ``stty tostop''.
If you set this
tty option, then background jobs will stop when they try to produce
output like they do when they try to read input.
.PP
There are several ways to refer to jobs in the shell.  The character
`%' introduces a job name.  If you wish to refer to job number 1, you can
name it as `%1'.  Just naming a job brings it to the foreground; thus
`%1' is a synonym for `fg %1', bringing job 1 back into the foreground.
Similarly saying `%1 &' resumes job 1 in the background.
Jobs can also be named by prefixes of the string typed in to start them,
if these prefixes are unambiguous, thus `%ex' would normally restart
a suspended
.IR ex (1)
job, if there were only one suspended job whose name began with
the string `ex'.  It is also possible to say `%?string'
which specifies a job whose text contains
.I string,
if there is only one such job.
.PP
The shell maintains a notion of the current and previous jobs.
In output pertaining to jobs, the current job is marked with a `+'
and the previous job with a `\-'.  The abbreviation `%+' refers
to the current job and `%\-' refers to the previous job.  For close
analogy with the syntax of the
.I history
mechanism (described below),
`%%' is also a synonym for the current job.
.sh "Status reporting"
This shell learns immediately whenever a process changes state.
It normally informs you whenever a job becomes blocked so that
no further progress is possible, but only just before it prints
a prompt.  This is done so that it does not otherwise disturb your work.
If, however, you set the shell variable
.I notify,
the shell will notify you immediately of changes of status in background
jobs.
There is also a shell command
.I notify
which marks a single process so that its status changes will be immediately
reported.  By default 
.I notify
marks the current process;
simply say `notify' after starting a background job to mark it.
.PP
When you try to leave the shell while jobs are stopped, you will
be warned that `You have stopped jobs.'  You may use the \fIjobs\fR
command to see what they are.  If you do this or immediately try to
exit again, the shell will not warn you a second time, and the suspended
jobs will be terminated.
.sh "File Name Completion"
When the file name completion feature is enabled by setting
the shell variable \fIfilec\fP (see \fBset\fP), \fIcsh\fP will
interactively complete file names and user names from unique
prefixes, when they are input from the terminal followed by
the escape character (the escape key, or control-[).  For example,
if the current directory looks like
.ta 1i 2i 3i 4i 5i 6i
.nf
	DSC.OLD	bin	cmd	lib	xmpl.c
	DSC.NEW	chaosnet	cmtest	mail	xmpl.o
	bench	class	dev	mbox	xmpl.out
.fi
and the input is
.br
	% vi ch<escape>
.br
\fIcsh\fP will complete the prefix ``ch''
to the only matching file name ``chaosnet'', changing the input
line to
.br
	% vi chaosnet
.br
However, given
.br
	% vi D<escape>
.br
\fIcsh\fP will only expand the input to
.br
	% vi DSC.
.br
and will sound the terminal bell to indicate that the expansion is
incomplete, since there are two file names matching the prefix ``D''.
.PP
If a partial file name is followed by the end-of-file character
(usually control-D), then, instead of completing the name, \fIcsh\fP
will list all file names matching the prefix.  For example,
the input
.br
	% vi D<control-D>
.br
causes all files beginning with ``D'' to be listed:
.br
	DSC.NEW	DSC.OLD
.br
while the input line remains unchanged.
.PP
The same system of escape and end-of-file can also be used to
expand partial user names, if the word to be completed
(or listed) begins with the character ``~''.  For example,
typing
.br
	cd ~ro<escape>
.br
may produce the expansion
.br
	cd ~root
.PP
The use of the terminal bell to signal errors or multiple matches
can be inhibited by setting the variable \fInobeep\fP.
.PP
Normally, all files in the particular directory are candidates
for name completion.  Files with certain suffixes can be excluded
from consideration by setting the variable \fIfignore\fP to the
list of suffixes to be ignored.  Thus, if \fIfignore\fP is set by
the command
.br
	% set fignore = (.o .out)
.br
then typing
.br
	% vi x<escape>
.br
would result in the completion to
.br
	% vi xmpl.c
.br
ignoring the files "xmpl.o" and "xmpl.out".
However, if the only completion possible requires not ignoring these
suffixes, then they are not ignored.  In addition, \fIfignore\fP
does not affect the listing of file names by control-D.  All files
are listed regardless of their suffixes.
.sh Substitutions
We now describe the various transformations the shell performs on the
input in the order in which they occur.
.sh "History substitutions"
History substitutions place words from previous command input as portions
of new commands, making it easy to repeat commands, repeat arguments
of a previous command in the current command, or fix spelling mistakes
in the previous command with little typing and a high degree of confidence.
History substitutions begin with the character `!' and may begin
.B anywhere
in the input stream (with the proviso that they
.B "do not"
nest.)
This `!' may be preceded by an `\e' to prevent its special meaning; for
convenience, a `!' is passed unchanged when it is followed by a blank,
tab, newline, `=' or `('.
(History substitutions also occur when an input line begins with `\*(ua'.
This special abbreviation will be described later.)
Any input line which contains history substitution is echoed on the terminal
before it is executed as it could have been typed without history substitution.
.PP
Commands input from the terminal which consist of one or more words
are saved on the history list.
The history substitutions reintroduce sequences of words from these
saved commands into the input stream.
The size of which is controlled by the
.I history
variable; the previous command is always retained, regardless of its value.
Commands are numbered sequentially from 1.
.PP
For definiteness, consider the following output from the
.I history
command:
.PP
.DT
.br
	\09  write michael
.br
	10  ex write.c
.br
	11  cat oldwrite.c
.br
	12  diff *write.c
.PP
The commands are shown with their event numbers.
It is not usually necessary to use event numbers, but the current event
number can be made part of the
.I prompt
by placing an `!' in the prompt string.
.PP
With the current event 13 we can refer to previous events by event
number `!11', relatively as in `!\-2' (referring to the same event),
by a prefix of a command word
as in `!d' for event 12 or `!wri' for event 9, or by a string contained in
a word in the command as in `!?mic?' also referring to event 9.
These forms, without further modification, simply reintroduce the words
of the specified events, each separated by a single blank.
As a special case `!!' refers to the previous command; thus `!!'
alone is essentially a
.I redo.
.PP
To select words from an event we can follow the event specification by
a `:' and a designator for the desired words.
The words of an input line are numbered from 0,
the first (usually command) word being 0, the second word (first argument)
being 1, etc.
The basic word designators are:
.PP
.DT
.nf
	0	first (command) word
	\fIn\fR	\fIn\fR\|'th argument
	\*(ua	first argument,  i.e. `1'
	$	last argument
	%	word matched by (immediately preceding) ?\fIs\fR\|? search
	\fIx\fR\|\-\fIy\fR	range of words
	\-\fIy\fR	abbreviates `0\-\fIy\fR\|'
	*	abbreviates `\*(ua\-$', or nothing if only 1 word in event
	\fIx\fR\|*	abbreviates `\fIx\fR\|\-$'
	\fIx\fR\|\-	like `\fIx\fR\|*' but omitting word `$'
.fi
.PP
The `:' separating the event specification from the word designator
can be omitted if the argument selector begins with a `\*(ua', `$', `*'
`\-' or `%'.
After the optional word designator can be
placed a sequence of modifiers, each preceded by a `:'.
The following modifiers are defined:
.ta .5i 1.2i
.PP
.nf
	h	Remove a trailing pathname component, leaving the head.
	r	Remove a trailing `.xxx' component, leaving the root name.
	e	Remove all but the extension `.xxx' part.
	s/\fIl\fR\|/\fIr\fR\|/	Substitute \fIl\fR for \fIr\fR
	t	Remove all leading pathname components, leaving the tail.
	&	Repeat the previous substitution.
	g	Apply the change globally, prefixing the above, e.g. `g&'.
	p	Print the new command line but do not execute it.
	q	Quote the substituted words, preventing further substitutions.
	x	Like q, but break into words at blanks, tabs and newlines.
.fi
.PP
Unless preceded by a `g' the modification is applied only to the first
modifiable word.  With substitutions, it is an error for no word to be
applicable.
.PP
The left hand side of substitutions are not regular expressions in the sense
of the editors, but rather strings.
Any character may be used as the delimiter in place of `/';
a `\e' quotes the delimiter into the
.IR l ""
and
.IR r ""
strings.
The character `&' in the right hand side is replaced by the text from
the left.
A `\e' quotes `&' also.
A null
.IR l ""
uses the previous string either from a
.IR l ""
or from a
contextual scan string
.IR s ""
in `!?\fIs\fR\|?'.
The trailing delimiter in the substitution may be omitted if a newline
follows immediately as may the trailing `?' in a contextual scan.
.PP
A history reference may be given without an event specification, e.g. `!$'.
In this case the reference is to the previous command unless a previous
history reference occurred on the same line in which case this form repeats
the previous reference.
Thus `!?foo?\*(ua !$' gives the first and last arguments
from the command matching `?foo?'.
.PP
A special abbreviation of a history reference occurs when the first
non-blank character of an input line is a `\*(ua'.
This is equivalent to `!:s\*(ua' providing a convenient shorthand for substitutions
on the text of the previous line.
Thus `\*(ualb\*(ualib' fixes the spelling of 
`lib'
in the previous command.
Finally, a history substitution may be surrounded with `{' and `}'
if necessary to insulate it from the characters which follow.
Thus, after `ls \-ld ~paul' we might do `!{l}a' to do `ls \-ld ~paula',
while `!la' would look for a command starting `la'.
.PP
.if n .ul
\fBQuotations\ with\ \'\ and\ "\fR
.PP
The quotation of strings by `\'' and `"' can be used
to prevent all or some of the remaining substitutions.
Strings enclosed in `\'' are prevented any further interpretation.
Strings enclosed in `"' may be expanded as described below.
.PP
In both cases the resulting text becomes (all or part of) a single word;
only in one special case (see
.I "Command Substitition"
below) does a `"' quoted string yield parts of more than one word;
`\'' quoted strings never do.
.sh "Alias substitution"
The shell maintains a list of aliases which can be established, displayed
and modified by the
.I alias
and
.I unalias
commands.
After a command line is scanned, it is parsed into distinct commands and
the first word of each command, left-to-right, is checked to see if it
has an alias.
If it does, then the text which is the alias for that command is reread
with the history mechanism available
as though that command were the previous input line.
The resulting words replace the
command and argument list.
If no reference is made to the history list, then the argument list is
left unchanged.
.PP
Thus if the alias for `ls' is `ls \-l' the command `ls /usr' would map to
`ls \-l /usr', the argument list here being undisturbed.
Similarly if the alias for `lookup' was `grep !\*(ua /etc/passwd' then
`lookup bill' would map to `grep bill /etc/passwd'.
.PP
If an alias is found, the word transformation of the input text
is performed and the aliasing process begins again on the reformed input line.
Looping is prevented if the first word of the new text is the same as the old
by flagging it to prevent further aliasing.
Other loops are detected and cause an error.
.PP
Note that the mechanism allows aliases to introduce parser metasyntax.
Thus we can `alias print \'pr \e!* \||\| lpr\'' to make a command which
.I pr's
its arguments to the line printer.
.sh "Variable substitution"
The shell maintains a set of variables, each of which has as value a list
of zero or more words.
Some of these variables are set by the shell or referred to by it.
For instance, the
.I argv
variable is an image of the shell's argument list, and words of this
variable's value are referred to in special ways.
.PP
The values of variables may be displayed and changed by using the
.I set
and
.I unset
commands.
Of the variables referred to by the shell a number are toggles;
the shell does not care what their value is,
only whether they are set or not.
For instance, the
.I verbose
variable is a toggle which causes command input to be echoed.
The setting of this variable results from the
.B \-v
command line option.
.PP
Other operations treat variables numerically.
The `@' command permits numeric calculations to be performed and the result
assigned to a variable.
Variable values are, however, always represented as (zero or more) strings.
For the purposes of numeric operations, the null string is considered to be
zero, and the second and subsequent words of multiword values are ignored.
.PP
After the input line is aliased and parsed, and before each command
is executed, variable substitution
is performed keyed by `$' characters.
This expansion can be prevented by preceding the `$' with a `\e' except
within `"'s where it
.B always
occurs, and within `\''s where it
.B never
occurs.
Strings quoted by `\*(ga' are interpreted later (see
.I "Command substitution"
below) so `$' substitution does not occur there until later, if at all.
A `$' is passed unchanged if followed by a blank, tab, or end-of-line.
.PP
Input/output redirections are recognized before variable expansion,
and are variable expanded separately.
Otherwise, the command name and entire argument list are expanded together.
It is thus possible for the first (command) word to this point to generate
more than one word, the first of which becomes the command name,
and the rest of which become arguments.
.PP
Unless enclosed in `"' or given the `:q' modifier the results of variable
substitution may eventually be command and filename substituted.
Within `"', a variable whose value consists of multiple words expands to a
(portion of) a single word, with the words of the variables value
separated by blanks.
When the `:q' modifier is applied to a substitution
the variable will expand to multiple words with each word separated
by a blank and quoted to prevent later command or filename substitution.
.PP
The following metasequences are provided for introducing variable values into
the shell input.
Except as noted, it is an error to reference a variable which is not set.
.HP 5
$name
.br
.ns
.HP 5
${name}
.br
Are replaced by the words of the value of variable
.I name,
each separated by a blank.
Braces insulate
.I name
from following characters which would otherwise be part of it.
Shell variables have names consisting of up to 20 letters and digits
starting with a letter.  The underscore character is considered a letter.
.br
If
.I name
is not a shell variable, but is set in the environment, then
that value is returned (but \fB:\fR modifiers and the other forms
given below are not available in this case).
.HP 5
$name[selector]
.br
.ns
.HP 5
${name[selector]}
.br
May be used to select only some of the words from the value of
.I name.
The selector is subjected to `$' substitution and may consist of a single
number or two numbers separated by a `\-'.
The first word of a variables value is numbered `1'.
If the first number of a range is omitted it defaults to `1'.
If the last member of a range is omitted it defaults to `$#name'.
The selector `*' selects all words.
It is not an error for a range to be empty if the second argument is omitted
or in range.
.HP 5
$#name
.br
.ns
.HP 5
${#name}
.br
Gives the number of words in the variable.
This is useful for later use in a `[selector]'.
.HP 5
$0
.br
Substitutes the name of the file from which command input is being read.
An error occurs if the name is not known.
.HP 5
$number
.br
.ns
.HP 5
${number}
.br
Equivalent to `$argv[number]'.
.HP 5
$*
.br
Equivalent to `$argv[*]'.
.PP
The modifiers `:e', `:h', `:t', `:r', `:q' and `:x' may be applied to
the substitutions above as may `:gh', `:gt' and `:gr'.
If braces `{' '}' appear in the command form then the modifiers
must appear within the braces.
.B  "The current implementation allows only one `:' modifier on each `$' expansion."
.PP
The following substitutions may not be modified with `:' modifiers.
.HP 5
$?name
.br
.ns
.HP 5
${?name}
.br
Substitutes the string `1' if name is set, `0' if it is not.
.HP 5
$?0
.br
Substitutes `1' if the current input filename is known, `0' if it is not.
.HP 5
$$
.br
Substitute the (decimal) process number of the (parent) shell.
.HP 5
$<
.br
Substitutes a line from the standard
input, with no further interpretation thereafter.  It can be used
to read from the keyboard in a shell script.
.sh "Command and filename substitution"
The remaining substitutions, command and filename substitution,
are applied selectively to the arguments of builtin commands.
This means that portions of expressions which are not evaluated are
not subjected to these expansions.
For commands which are not internal to the shell, the command
name is substituted separately from the argument list.
This occurs very late,
after input-output redirection is performed, and in a child
of the main shell.
.sh "Command substitution"
Command substitution is indicated by a command enclosed in `\*(ga'.
The output from such a command is normally broken into separate words
at blanks, tabs and newlines, with null words being discarded,
this text then replacing the original string.
Within `"'s, only newlines force new words; blanks and tabs are preserved.
.PP
In any case, the single final newline does not force a new word.
Note that it is thus possible for a command substitution to yield
only part of a word, even if the command outputs a complete line.
.sh "Filename substitution"
If a word contains any of the characters `*', `?', `[' or `{'
or begins with the character `~', then that word is a candidate for
filename substitution, also known as `globbing'.
This word is then regarded as a pattern, and replaced with an alphabetically
sorted list of file names which match the pattern.
In a list of words specifying filename substitution it is an error for
no pattern to match an existing file name, but it is not required
for each pattern to match.
Only the metacharacters `*', `?' and `[' imply pattern matching,
the characters `~' and `{' being more akin to abbreviations.
.PP
In matching filenames, the character `.' at the beginning of a filename
or immediately following a `/', as well as the character `/' must
be matched explicitly.
The character `*' matches any string of characters, including the null
string.
The character `?' matches any single character.
The sequence `[...]' matches any one of the characters enclosed.
Within `[...]',
a pair of characters separated by `\-' matches any character lexically between
the two.
.PP
The character `~' at the beginning of a filename is used to refer to home
directories.
Standing alone, i.e. `~' it expands to the invokers home directory as reflected
in the value of the variable
.I home.
When followed by a name consisting of letters, digits and `\-' characters
the shell searches for a user with that name and substitutes their
home directory;  thus `~ken' might expand to `/usr/ken' and `~ken/chmach'
to `/usr/ken/chmach'.
If the character `~' is followed by a character other than a letter or `/'
or appears not at the beginning of a word,
it is left undisturbed.
.PP
The metanotation `a{b,c,d}e' is a shorthand for `abe ace ade'.
Left to right order is preserved, with results of matches being sorted
separately at a low level to preserve this order.
This construct may be nested.
Thus `~source/s1/{oldls,ls}.c' expands to
`/usr/source/s1/oldls.c /usr/source/s1/ls.c'
whether or not these files exist without any chance of error
if the home directory for `source' is `/usr/source'.
Similarly `../{memo,*box}' might expand to `../memo ../box ../mbox'.
(Note that `memo' was not sorted with the results of matching `*box'.)
As a special case `{', `}' and `{}' are passed undisturbed.
.sh Input/output
The standard input and standard output of a command may be redirected
with the following syntax:
.HP 5
< name
.br
Open file
.I name
(which is first variable, command and filename expanded) as the standard
input.
.HP 5
<< word
.br
Read the shell input up to a line which is identical to
.I word.
.I Word
is not subjected to variable, filename or command substitution,
and each input line is compared to
.I word
before any substitutions are done on this input line.
Unless a quoting `\e', `"', `\*(aa' or `\*(ga' appears in
.I word
variable and command substitution is performed on the intervening lines,
allowing `\e' to quote `$', `\e' and `\*(ga'.
Commands which are substituted have all blanks, tabs, and newlines
preserved, except for the final newline which is dropped.
The resultant text is placed in an anonymous temporary file which
is given to the command as standard input.
.HP 5
> name
.br
.ns
.HP 5
>! name
.br
.ns
.HP 5
>& name
.br
.ns
.HP 5
>&! name
.br
The file
.I name
is used as standard output.
If the file does not exist then it is created;
if the file exists, its is truncated, its previous contents being lost.
.IP
If the variable
.I noclobber
is set, then the file must not exist or be a character special file (e.g. a
terminal or `/dev/null') or an error results.
This helps prevent accidental destruction of files.
In this case the `!' forms can be used and suppress this check.
.IP
The forms involving `&' route the diagnostic output into the specified
file as well as the standard output.
.I Name
is expanded in the same way as `<' input filenames are.
.HP 5
>> name
.br
.ns
.HP 5
>>& name
.br
.ns
.HP 5
>>! name
.br
.ns
.HP 5
>>&! name
.br
Uses file
.I name
as standard output like `>' but places output at the end of the file.
If the variable
.I noclobber
is set, then it is an error for the file not to exist unless
one of the `!' forms is given.
Otherwise similar to `>'.
.PP
A command receives the environment in which the shell was
invoked as modified by the input-output parameters and
the presence of the command in a pipeline.
Thus, unlike some previous shells, commands run from a file of shell commands
have no access to the text of the commands by default; rather
they receive the original standard input of the shell.
The `<<' mechanism should be used to present inline data.
This permits shell command scripts to function as components of pipelines
and allows the shell to block read its input.
Note that the default standard input for a command run detached is
.B not
modified to be the empty file `/dev/null'; rather the standard input
remains as the original standard input of the shell.  If this is a terminal
and if the process attempts to read from the terminal, then the process
will block and the user will be notified (see
.B Jobs
above).
.PP
Diagnostic output may be directed through a pipe with the standard output.
Simply use the form `|\|&' rather than just `|'.
.sh Expressions
A number of the builtin commands (to be described subsequently)
take expressions, in which the operators are similar to those of C, with
the same precedence.
These expressions appear in the
.I @,
.I exit,
.I if,
and
.I while
commands.
The following operators are available:
.DT
.PP
	|\|\||  &&  |  \*(ua  &  ==  !=  =~  !~  <=  >=  <  >  <<  >>  +  \-  *  /  %  !  ~  (  )
.PP
Here the precedence increases to the right,
`==' `!=' `=~' and `!~', `<=' `>=' `<' and `>', `<<' and `>>', `+' and `\-',
`*' `/' and `%' being, in groups, at the same level.
The `==' `!=' `=~' and `!~' operators compare their arguments as strings;
all others operate on numbers.
The operators `=~' and `!~' are like `!=' and `==' except that the right
hand side is a
.I pattern
(containing, e.g. `*'s, `?'s and instances of `[...]')
against which the left hand operand is matched.  This reduces the
need for use of the
.I switch
statement in shell scripts when all that is really needed is pattern matching.
.PP
Strings which begin with `0' are considered octal numbers.
Null or missing arguments are considered `0'.
The result of all expressions are strings,
which represent decimal numbers.
It is important to note that no two components of an expression can appear
in the same word; except when adjacent to components of expressions which
are syntactically significant to the parser (`&' `|' `<' `>' `(' `)')
they should be surrounded by spaces.
.PP
Also available in expressions as primitive operands are command executions
enclosed in `{' and `}'
and file enquiries of the form `\-\fIl\fR  name' where
.I  l
is one of:
.PP
.DT
.nf
	r	read access
	w	write access
	x	execute access
	e	existence
	o	ownership
	z	zero size
	f	plain file
	d	directory
.fi
.PP
The specified name is command and filename expanded and then tested
to see if it has the specified relationship to the real user.
If the file does not exist or is inaccessible then all enquiries return
false, i.e. `0'.
Command executions succeed, returning true, i.e. `1',
if the command exits with status 0, otherwise they fail, returning
false, i.e. `0'.
If more detailed status information is required then the command
should be executed outside of an expression and the variable
.I status
examined.
.sh "Control flow"
The shell contains a number of commands which can be used to regulate the
flow of control in command files (shell scripts) and
(in limited but useful ways) from terminal input.
These commands all operate by forcing the shell to reread or skip in its
input and, due to the implementation, restrict the placement of some
of the commands.
.PP
The
.I foreach,
.I switch,
and
.I while
statements, as well as the
.I if\-then\-else
form of the
.I if
statement require that the major keywords appear in a single simple command
on an input line as shown below.
.PP
If the shell's input is not seekable,
the shell buffers up input whenever a loop is being read
and performs seeks in this internal buffer to accomplish the rereading
implied by the loop.
(To the extent that this allows, backward goto's will succeed on
non-seekable inputs.)
.sh "Builtin commands"
Builtin commands are executed within the shell.
If a builtin command occurs as any component of a pipeline
except the last then it is executed in a subshell.
.HP 5
.B  alias
.br
.ns
.HP 5
.BR alias " name"
.br
.ns
.HP 5
.BR alias " name wordlist"
.br
The first form prints all aliases.
The second form prints the alias for name.
The final form assigns the specified
.I wordlist
as the alias of 
.I name;
.I wordlist
is command and filename substituted.
.I Name
is not allowed to be
.I alias
or
.I unalias.
.HP 5
.B  alloc
.br
Shows the amount of dynamic memory acquired, broken down into used and
free memory.
With an argument shows the number of free and used blocks in each size
category.  The categories start at size 8 and double at each step.
This command's output may vary across system types, since
systems other than the VAX may use a different memory allocator.
.HP 5
.B bg
.br
.ns
.HP 5
\fBbg\ %\fRjob\ ...
.br
Puts the current or specified jobs into the background, continuing them
if they were stopped.
.HP 5
.B  break
.br
Causes execution to resume after the
.I end
of the nearest enclosing
.I foreach
or
.I while.
The remaining commands on the current line are executed.
Multi-level breaks are thus possible by writing them all on one line.
.HP 5
.B  breaksw
.br
Causes a break from a
.I switch,
resuming after the
.I endsw.
.HP 5
.BR case " label:"
.br
A label in a
.I switch
statement as discussed below.
.HP 5
.B  cd
.br
.ns
.HP 5
.BR cd " name"
.br
.ns
.HP 5
.B  chdir
.br
.ns
.HP 5
.BR chdir " name"
.br
Change the shell's working directory to directory
.I name.
If no argument is given then change to the home directory of the user.
.br
If
.I name
is not found as a subdirectory of the current directory (and does not begin
with `/', `./' or `../'), then each
component of the variable
.I cdpath
is checked to see if it has a subdirectory
.I name.
Finally, if all else fails but
.I name
is a shell variable whose value begins with `/', then this
is tried to see if it is a directory.
.HP 5
.B  continue
.br
Continue execution of the nearest enclosing
.I while
or
.I foreach.
The rest of the commands on the current line are executed.
.HP 5
.B  default:
.br
Labels the default case in a
.I switch
statement.
The default should come after all
.I case
labels.
.HP 5
.BR "dirs"
.br
Prints the directory stack; the top of the stack is at the left,
the first directory in the stack being the current directory.
.HP 5
.BR echo " wordlist"
.br
.ns
.HP 5
.BR "echo \-n" " wordlist"
.br
The specified words are written to the shells standard output, separated
by spaces, and terminated with a newline unless the
.B \-n
option is specified.
.HP 5
.B  else
.br
.ns
.HP 5
.B  end
.br
.ns
.HP 5
.B  endif
.br
.ns
.HP 5
.B  endsw
.br
See the description of the
.I foreach,
.I if,
.I switch,
and
.I while
statements below.
.HP 5
.BR eval " arg ..."
.br
(As in
.IR sh (1).)
The arguments are read as input to the shell and the resulting
command(s) executed in the context of the current shell.
This is usually used to execute commands
generated as the result of command or variable substitution, since
parsing occurs before these substitutions.  See
.IR tset (1)
for an example of using
.IR eval .
.HP 5
.BR exec " command"
.br
The specified command is executed in place of the current shell.
.HP 5
.B  exit
.br
.ns
.HP 5
.BR exit (expr)
.br
The shell exits either with the value of the
.I status
variable (first form) or with the value of the specified
.I  expr
(second form).
.HP 5
.B fg
.br
.ns
.HP 5
\fBfg\ %\fRjob\ ...
.br
Brings the current or specified jobs into the foreground, continuing them if
they were stopped.
.HP 5
.BR foreach " name (wordlist)"
.br
.ns
.HP 5
\    ...
.br
.ns
.HP 5
.B  end
.br
The variable
.I name
is successively set to each member of
.I wordlist
and the sequence of commands between this command and the matching
.I end
are executed.
(Both
.I foreach
and
.I end
must appear alone on separate lines.)
.IP
The builtin command
.I continue
may be used to continue the loop prematurely and the builtin
command
.I break
to terminate it prematurely.
When this command is read from the terminal, the loop is read up once
prompting with `?' before any statements in the loop are executed.
If you make a mistake typing in a loop at the terminal you can rub it out.
.HP 5
.BR glob " wordlist"
.br
Like
.I echo
but no `\e' escapes are recognized and words are delimited
by null characters in the output.
Useful for programs which wish to use the shell to filename expand a list
of words.
.HP 5
.BR goto " word"
.br
The specified
.I word
is filename and command expanded to yield a string of the form `label'.
The shell rewinds its input as much as possible
and searches for a line of the form `label:'
possibly preceded by blanks or tabs.
Execution continues after the specified line.
.HP 5
.BR hashstat
.br
Print a statistics line indicating how effective the internal hash
table has been at locating commands (and avoiding
.IR exec 's).
An
.I exec
is attempted for each component of the
.I path
where the hash function indicates a possible hit, and in each component
which does not begin with a `/'.
.HP 5
.B  history
.br
.ns
.HP 5
.BI history " n"
.br
.ns
.HP 5
.BI "history \-r" " n"
.br
.ns
.HP 5
.BI "history \-h" " n"
.br
Displays the history event list; if \fIn\fR is given only the
.I n
most recent events are printed.
The
.B \-r
option reverses the order of printout to be most recent first
rather than oldest first.
The
.B \-h
option causes the history list to be printed without leading numbers.
This is used to produce files suitable for sourceing using the \-h
option to
.IR source .
.HP 5
.BR if " (expr) command"
.br
If the specified expression evaluates true, then the single
.I  command
with arguments is executed.
Variable substitution on
.IR command ""
happens early, at the same
time it does for the rest of the
.I if
command.
.I Command
must be a simple command, not
a pipeline, a command list, or a parenthesized command list.
Input/output redirection occurs even if
.I expr
is false, when command is
.B not
executed (this is a bug).
.HP 5
.BR if " (expr) " "then"
.br
.ns
.HP 5
\    ...
.br
.ns
.HP 5
.BR else " " "if\fR (expr2) \fBthen"
.br
.ns
.HP 5
\    ...
.br
.ns
.HP 5
.B  else
.br
.ns
.HP 5
\    ...
.br
.ns
.HP 5
.B  endif
.br
If the specified
.IR expr ""
is true then the commands to the first
.I else
are executed; otherwise if
.IR expr2 ""
is true then the commands to the
second \fIelse\fR are executed, etc.
Any number of
.I else-if
pairs are possible; only one
.I endif
is needed.
The
.I else
part is likewise optional.
(The words
.I else
and
.I endif
must appear at the beginning of input lines;
the
.I if
must appear alone on its input line or after an
.I else.)
.HP 5
.B jobs
.br
.ns
.HP 5
.B "jobs \-l"
.br
Lists the active jobs; given the
.B \-l
options lists process id's in addition to the normal information.
.HP 5
\fBkill %\fRjob
.br
.ns
.HP 5
\fBkill\ \-\fRsig\ \fB%\fRjob\ ...
.br
.ns
.HP 5
\fBkill\fR\ pid
.br
.ns
.HP 5
\fBkill\ \-\fRsig\ pid\ ...
.br
.ns
.HP 5
\fBkill\ \-l\fR
.br
Sends either the TERM (terminate) signal or the
specified signal to the specified jobs or processes.
Signals are either given by number or by names (as given in
.I /usr/include/signal.h,
stripped of the prefix ``SIG'').
The signal names are listed by ``kill \-l''.
There is no default, saying just `kill' does not
send a signal to the current job.
If the signal being sent is TERM (terminate) or HUP (hangup),
then the job or process will be sent a CONT (continue) signal as well.
.HP
\fBlimit\fR
.br
.ns
.HP 5
\fBlimit\fR \fIresource\fR
.br
.ns
.HP 5
\fBlimit\fR \fIresource\fR \fImaximum-use\fR
.br
.ns
.HP 5
\fBlimit\ \-h\fR
.br
.ns
.HP 5
\fBlimit\ \-h\fR \fIresource\fR
.br
.ns
.HP 5
\fBlimit\ \-h\fR \fIresource\fR \fImaximum-use\fR
.br
Limits the consumption by the current process and each process
it creates to not individually exceed \fImaximum-use\fR on the
specified \fIresource\fR.  If no \fImaximum-use\fR is given, then
the current limit is printed; if no \fIresource\fR is given, then
all limitations are given.  If the \fB\-h\fR
flag is given, the hard limits are used instead of the current
limits.  The hard limits impose a ceiling on the values of
the current limits.  Only the super-user may raise the hard limits,
but a user may lower or raise the current limits within the legal range.
.IP
Resources controllable currently include \fIcputime\fR (the maximum
number of cpu-seconds to be used by each process), \fIfilesize\fR
(the largest single file which can be created), \fIdatasize\fR
(the maximum growth of the data+stack region via
.IR sbrk (2)
beyond the end of the program text), \fIstacksize\fR (the maximum
size of the automatically-extended stack region), and \fIcoredumpsize\fR
(the size of the largest core dump that will be created).
.IP
The \fImaximum-use\fR may be given as a (floating point or integer)
number followed by a scale factor.  For all limits other than \fIcputime\fR
the default scale is `k' or `kilobytes' (1024 bytes);
a scale factor of `m' or `megabytes' may also be used.
For
.I cputime
the default scaling is `seconds', while `m' for minutes
or `h' for hours, or a time of the form `mm:ss' giving minutes
and seconds may be used.
.IP
For both \fIresource\fR names and scale factors, unambiguous prefixes
of the names suffice.
.HP 5
.B  login
.br
Terminate a login shell, replacing it with an instance of
.B /bin/login.
This is one way to log off, included for compatibility with
.IR sh (1).
.HP 5
.B  logout
.br
Terminate a login shell.
Especially useful if
.I ignoreeof
is set.
.HP 5
.B  nice
.br
.ns
.HP 5
.BR nice " +number"
.br
.ns
.HP 5
.BR nice " command"
.br
.ns
.HP 5
.BR nice " +number command"
.br
The first form sets the
scheduling priority
for this shell to 4.
The second form sets the
priority
to the given number.
The final two forms run command at priority 4 and
.I number
respectively.
The greater the number, the less cpu the process will get.
The super-user may specify negative priority by using `nice \-number ...'.
Command is always executed in a sub-shell, and the restrictions
placed on commands in simple
.I if
statements apply.
.HP 5
.B  nohup
.br
.ns
.HP 5
.BR "nohup" " command"
.br
The first form can be used in shell scripts to cause hangups to be
ignored for the remainder of the script.
The second form causes the specified command to be run with hangups
ignored.
All processes detached with `&' are effectively
.I nohup'ed.
.HP 5
.B notify
.br
.ns
.HP 5
\fBnotify\ %\fRjob\ ...
.br
Causes the shell to notify the user asynchronously when the status of the
current or specified jobs changes; normally notification is presented
before a prompt.  This is automatic if the shell variable
.I notify
is set.
.HP 5
.B  onintr
.br
.ns
.HP 5
.BR onintr "  \-"
.br
.ns
.HP 5
.BR onintr "  label"
.br
Control the action of the shell on interrupts.
The first form restores the default action of the shell on interrupts
which is to terminate shell scripts or to return to the terminal command
input level.
The second form `onintr \-' causes all interrupts to be ignored.
The final form causes the shell to execute a `goto label' when
an interrupt is received or a child process terminates because
it was interrupted.
.IP
In any case, if the shell is running detached and interrupts are
being ignored, all forms of
.I onintr
have no meaning and interrupts
continue to be ignored by the shell and all invoked commands.
.HP 5
.BR "popd"
.br
.ns
.HP 5
.BR "popd" " +n"
.br
Pops the directory stack, returning to the new top directory.
With an argument `+\fIn\fR' discards the \fIn\fR\|th
entry in the stack.
The elements of the directory stack are numbered from 0 starting at the top.
.HP 5
.BR "pushd"
.br
.ns
.HP 5
.BR "pushd" " name"
.br
.ns
.HP 5
.BR "pushd" " +n"
.br
With no arguments,
.I pushd
exchanges the top two elements of the directory stack.
Given a
.I name
argument,
.I pushd
changes to the new directory (ala
.I cd)
and pushes the old current working directory
(as in
.I csw)
onto the directory stack.
With a numeric argument, rotates the \fIn\fR\|th argument of the directory
stack around to be the top element and changes to it.  The members
of the directory stack are numbered from the top starting at 0.
.HP 5
.BR rehash
.br
Causes the internal hash table of the contents of the directories in
the
.I path
variable to be recomputed.  This is needed if new commands are added
to directories in the
.I path
while you are logged in.  This should only be necessary if you add
commands to one of your own directories, or if a systems programmer
changes the contents of one of the system directories.
.HP 5
.BR repeat " count command"
.br
The specified 
.I command
which is subject to the same restrictions
as the
.I command
in the one line
.I if
statement above,
is executed
.I count
times.
I/O redirections occur exactly once, even if
.I count
is 0.
.HP 5
.B  set
.br
.ns
.HP 5
.BR set " name"
.br
.ns
.HP 5
.BR set " name=word"
.br
.ns
.HP 5
.BR set " name[index]=word"
.br
.ns
.HP 5
.BR set " name=(wordlist)"
.br
The first form of the command shows the value of all shell variables.
Variables which have other than a single word as value print as a parenthesized
word list.
The second form sets
.I name
to the null string.
The third form sets
.I name
to the single
.I word.
The fourth form sets
the
.I index'th
component of name to word;
this component must already exist.
The final form sets
.I name
to the list of words in
.I wordlist.
In all cases the value is command and filename expanded.
.IP
These arguments may be repeated to set multiple values in a single set command.
Note however, that variable expansion happens for all arguments before any
setting occurs.
.HP 5
.BR setenv
.br
.ns
.HP 5
.BR setenv " name value"
.br
.ns
.HP 5
.BR setenv " name"
.br
The first form lists all current environment variables.
The last form sets the value of environment variable
.I name
to be
.I value,
a single string.  The second form sets
.I name
to an empty string.
The most commonly used environment variable USER, TERM, and PATH
are automatically imported to and exported from the
.I csh
variables
.I user,
.I term,
and
.I path;
there is no need to use
.I setenv
for these.
.HP 5
.B  shift
.br
.ns
.HP 5
.BR shift " variable"
.br
The members of
.I argv
are shifted to the left, discarding
.I argv[1].
It is an error for
.I argv
not to be set or to have less than one word as value.
The second form performs the same function on the specified variable.
.HP 5
.BR source " name"
.br
.ns
.HP 5
.BR "source \-h" " name"
.br
The shell reads commands from
.I name.
.I Source
commands may be nested; if they are nested too deeply the shell may
run out of file descriptors.
An error in a
.I source
at any level terminates all nested
.I source
commands.
Normally input during 
.I source
commands is not placed on the history list;
the \-h option causes the commands to be placed in the
history list without being executed.
.HP 5
.B stop
.br
.ns
.HP 5
\fBstop\ %\fRjob\ ...
.br
Stops the current or specified job which is executing in the background.
.HP 5
.B suspend
.br
.ns
Causes the shell to stop in its tracks, much as if it had been sent a stop
signal with \fB^Z\fR.  This is most often used to stop shells started by
.IR su (1).
.HP 5
.BR switch " (string)"
.br
.ns
.HP 5
.BR case " str1:"
.br
.ns
.HP 5
\    ...
.br
.ns
.HP 5
\   
.B  breaksw
.br
.ns
.HP 5
\&...
.br
.ns
.HP 5
.B  default:
.br
.ns
.HP 5
\    ...
.br
.ns
.HP 5
\   
.B  breaksw
.br
.ns
.HP 5
.B  endsw
.br
Each case label is successively matched, against the specified
.I string
which is first command and filename expanded.
The file metacharacters `*', `?' and `[...]' may be used in the case labels,
which are variable expanded.
If none of the labels match before a `default' label is found, then
the execution begins after the default label.
Each case label and the default label must appear at the beginning of a line.
The command 
.I breaksw
causes execution to continue after the
.I endsw.
Otherwise control may fall through case labels and default labels as in C.
If no label matches and there is no default, execution continues after
the
.I endsw.
.HP 5
.B  time
.br
.ns
.HP 5
.BR time " command"
.br
With no argument, a summary of time used by this shell and its children
is printed.
If arguments are given
the specified simple command is timed and a time summary
as described under the
.I time
variable is printed.  If necessary, an extra shell is created to print the time
statistic when the command completes.
.HP 5
.B umask
.br
.ns
.HP 5
.BR umask " value"
.br
The file creation mask is displayed (first form) or set to the specified
value (second form).  The mask is given in octal.  Common values for
the mask are 002 giving all access to the group and read and execute
access to others or 022 giving all access except no write access for
users in the group or others.
.HP 5
.BR unalias " pattern"
.br
All aliases whose names match the specified pattern are discarded.
Thus all aliases are removed by `unalias *'.
It is not an error for nothing to be
.I unaliased.
.HP 5
.BR unhash
.br
Use of the internal hash table to speed location of executed programs
is disabled.
.HP 5
\fBunlimit\fR
.br
.ns
.HP 5
\fBunlimit\fR \fIresource\fR
.br
.ns
.HP 5
\fBunlimit\ \-h\fR
.br
.ns
.HP 5
\fBunlimit\ \-h\fR \fIresource\fR
.br
Removes the limitation on \fIresource\fR.  If no \fIresource\fR
is specified, then all \fIresource\fR limitations are removed.  If
\fB\-h\fR is given, the corresponding hard limits are removed.  Only the
super-user may do this.
.HP 5
.BR unset " pattern"
.br
All variables whose names match the specified pattern are removed.
Thus all variables are removed by `unset *'; this has noticeably
distasteful side-effects.
It is not an error for nothing to be
.I unset.
.HP 5
.BR unsetenv " pattern"
.br
Removes all variables whose name match the specified pattern from the
environment.  See also the
.I setenv
command above and
.IR printenv (1).
.HP 5
.B  wait
.br
All background jobs are waited for.
It the shell is interactive, then an interrupt can disrupt the wait,
at which time the shell prints names and job numbers of all jobs
known to be outstanding.
.HP 5
.BR while " (expr)"
.br
.ns
.HP 5
\    ...
.br
.ns
.HP 5
.B  end
.br
While the specified expression evaluates non-zero, the commands between
the
.I while
and the matching end are evaluated.
.I Break
and
.I continue
may be used to terminate or continue the loop prematurely.
(The
.I while
and
.I end
must appear alone on their input lines.)
Prompting occurs here the first time through the loop as for the
.I foreach
statement if the input is a terminal.
.HP 5
\fB%\fRjob
.br
Brings the specified job into the foreground.
.HP 5
\fB%\fRjob \fB&\fR
.br
Continues the specified job in the background.
.HP 5
.B "@"
.br
.ns
.HP 5
.BR "@" " name = expr"
.br
.ns
.HP 5
.BR "@" " name[index] = expr"
.br
The first form prints the values of all the shell variables.
The second form sets the specified
.I name
to the value of
.I expr.
If the expression contains `<', `>', `&' or `|' then at least
this part of the expression must be placed within `(' `)'.
The third form assigns the value of
.I expr
to the
.I index'th
argument of
.I name.
Both 
.I name
and its
.I index'th
component must already exist.
.IP
The operators `*=', `+=', etc are available as in C.
The space separating the name from the assignment operator is optional.
Spaces are, however, mandatory in separating components of
.I expr
which would otherwise be single words.
.IP
Special postfix `++' and `\-\|\-' operators increment and decrement
.I name
respectively, i.e. `@  i++'.
.sh "Pre-defined and environment variables"
The following variables have special meaning to the shell.
Of these,
.I argv,
.I cwd,
.I home,
.I path,
.I prompt,
.I shell
and
.I status
are always set by the shell.
Except for
.I cwd
and
.I status
this setting occurs only at initialization;
these variables will not then be modified unless this is done
explicitly by the user.
.PP
This shell copies the environment variable USER into the variable
.I user,
TERM into
.I term,
and
HOME into
.I home,
and copies these back into the environment whenever the normal
shell variables are reset.
The environment variable PATH is likewise handled; it is not
necessary to worry about its setting other than in the file
.I \&.cshrc
as inferior
.I csh
processes will import the definition of
.I path
from the environment, and re-export it if you then change it.
.TP 15
.B argv
\c
Set to the arguments to the shell, it is from this variable that
positional parameters are substituted, i.e. `$1' is replaced by
`$argv[1]', etc.
.TP 15
.B cdpath
\c
Gives a list of alternate directories searched to find subdirectories
in
.I chdir
commands.
.TP 15
.B cwd
The full pathname of the current directory.
.TP 15
.B echo
\c
Set when the
.B \-x
command line option is given.
Causes each command and its arguments
to be echoed just before it is executed.
For non-builtin commands all expansions occur before echoing.
Builtin commands are echoed before command and filename substitution,
since these substitutions are then done selectively.
.TP 15
.B filec
Enable file name completion.
\c
.TP 15
.B histchars
\c
Can be given a string value to change the characters used in history
substitution.  The first character of its value is used as the
history substitution character, replacing the default character !.
The second character of its value replaces the character \(ua in
quick substitutions.
.TP 15
.B history
\c
Can be given a numeric value to control the size of the history list.
Any command which has been referenced in this many events will not be
discarded.
Too large values of
.I history
may run the shell out of memory.
The last executed command is always saved on the history list.
.TP 15
.B home
\c
The home directory of the invoker, initialized from the environment.
The filename expansion of `\fB~\fR' refers to this variable.
.TP 15
.B ignoreeof
\c
If set the shell ignores
end-of-file from input devices which are terminals.
This prevents shells from accidentally being killed by control-D's.
.TP 15
.B mail
\c
The files where the shell checks for mail.
This is done after each command completion which will result in a prompt,
if a specified interval has elapsed.
The shell says `You have new mail.'
if the file exists with an access time not greater than its modify time.
.IP
If the first word of the value of
.I mail
is numeric it specifies a different mail checking interval, in seconds,
than the default, which is 10 minutes.
.IP
If multiple mail files are specified, then the shell says
`New mail in
.IR name '
when there is mail in the file
.I name.
.TP 15
.B noclobber
\c
As described in the section on
.I Input/output,
restrictions are placed on output redirection to insure that
files are not accidentally destroyed, and that `>>' redirections
refer to existing files.
.TP 15
.B noglob
\c
If set, filename expansion is inhibited.
This is most useful in shell scripts which are not dealing with filenames,
or after a list of filenames has been obtained and further expansions
are not desirable.
.TP 15
.B nonomatch
\c
If set, it is not an error for a filename expansion to not match any
existing files; rather the primitive pattern is returned.
It is still an error for the primitive pattern to be malformed, i.e.
`echo [' still gives an error.
.TP 15
.B notify
\c
If set, the shell notifies asynchronously of job completions.  The
default is to rather present job completions just before printing
a prompt.
.TP 15
.B path
\c
Each word of the path variable specifies a directory in which
commands are to be sought for execution.
A null word specifies the current directory.
If there is no
.I path
variable then only full path names will execute.
The usual search path is `.', `/bin' and `/usr/bin', but this
may vary from system to system.
For the super-user the default search path is `/etc', `/bin' and `/usr/bin'.
A shell which is given neither the
.B \-c
nor the
.B \-t
option will normally hash the contents of the directories in the
.I path
variable after reading
.I \&.cshrc,
and each time the
.I path
variable is reset.  If new commands are added to these directories
while the shell is active, it may be necessary to give the
.I rehash
or the commands may not be found.
.TP 15
.B prompt
\c
The string which is printed before each command is read from
an interactive terminal input.
If a `!' appears in the string it will be replaced by the current event number
unless a preceding `\e' is given.
Default is `% ', or `# ' for the super-user.
.TP 15
.B savehist
\c
is given a numeric value to control the number of entries of the
history list that are saved in ~/.history when the user logs out.
Any command which has been referenced in this many events will be saved.
During start up the shell sources ~/.history into the history list
enabling history to be saved across logins.
Too large values of
.I savehist
will slow down the shell during start up.
.TP 15
.B shell
\c
The file in which the shell resides.
This is used in forking shells to interpret files which have execute
bits set, but which are not executable by the system.
(See the description of
.I "Non-builtin Command Execution"
below.)
Initialized to the (system-dependent) home of the shell.
.TP 15
.B status
\c
The status returned by the last command.
If it terminated abnormally, then 0200 is added to the status.
Builtin commands which fail return exit status `1',
all other builtin commands set status `0'.
.TP 15
.B time
\c
Controls automatic timing of commands.
If set, then any command which takes more than this many cpu seconds
will cause a line giving user, system, and real times and a utilization
percentage which is the ratio of user plus system times to real time
to be printed when it terminates.
.TP 15
.B verbose
\c
Set by the
.B \-v
command line option, causes the words of each command to be printed
after history substitution.
.sh "Non-builtin command execution"
When a command to be executed is found to not be a builtin command
the shell attempts to execute the command via
.IR  execve (2).
Each word in the variable
.I path
names a directory from which the shell will attempt to execute the command.
If it is given neither a
.B \-c
nor a
.B \-t
option, the shell will hash the names in these directories into an internal
table so that it will only try an
.I exec
in a directory if there is a possibility that the command resides there.
This greatly speeds command location when a large number of directories
are present in the search path.
If this mechanism has been turned off (via
.IR unhash ),
or if the shell was given a
.B \-c
or
.B \-t
argument, and in any case for each directory component of
.I path
which does not begin with a `/',
the shell concatenates with the given command name to form a path name
of a file which it then attempts to execute.
.PP
Parenthesized commands are always executed in a subshell.
Thus `(cd ; pwd) ; pwd' prints the
.I home
directory; leaving you where you were (printing this after the home directory),
while `cd ; pwd' leaves you in the
.I home
directory.
Parenthesized commands are most often used to prevent
.I chdir
from affecting the current shell.
.PP
If the file has execute permissions but is not an
executable binary to the system, then it is assumed to be a
file containing shell commands and a new shell is spawned to read it.
.PP
If there is an
.I alias
for
.I shell
then the words of the alias will be prepended to the argument list to form
the shell command.
The first word of the
.I alias
should be the full path name of the shell
(e.g. `$shell').
Note that this is a special, late occurring, case of
.I alias
substitution,
and only allows words to be prepended to the argument list without modification.
.sh "Argument list processing"
If argument 0 to the shell is `\-' then this
is a login shell.
The flag arguments are interpreted as follows:
.TP 5
.B  \-b
\c
This flag forces a ``break'' from option processing, causing any further
shell arguments to be treated as non-option arguments.
The remaining arguments will not be interpreted as shell options.
This may be used to pass options to a shell script without confusion
or possible subterfuge.
The shell will not run a set-user ID script without this option.
.TP 5
.B  \-c
\c
Commands are read from the (single) following argument which must
be present.
Any remaining arguments are placed in
.I argv.
.TP 5
.B  \-e
\c
The shell exits if any invoked command terminates abnormally
or yields a non-zero exit status.
.TP 5
.B  \-f
\c
The shell will start faster, because it will neither search for nor
execute commands from the file
`\&.cshrc' in the invoker's home directory.
.TP 5
.B  \-i
\c
The shell is interactive and prompts for its top-level input,
even if it appears to not be a terminal.
Shells are interactive without this option if their inputs
and outputs are terminals.
.TP 5
.B  \-n
\c
Commands are parsed, but not executed.
This aids in syntactic checking of shell scripts.
.TP 5
.B  \-s
\c
Command input is taken from the standard input.
.TP 5
.B  \-t
\c
A single line of input is read and executed.
A `\e' may be used to escape the newline at the end of this
line and continue onto another line.
.TP 5
.B  \-v
\c
Causes the
.I verbose
variable to be set, with the effect
that command input is echoed after history substitution.
.TP 5
.B  \-x
\c
Causes the 
.I echo
variable to be set, so that commands are echoed immediately before execution.
.TP 5
.B  \-V
\c
Causes the
.I verbose
variable to be set even before `\&.cshrc' is executed.
.TP 5
.B  \-X
\c
Is to
.B \-x
as
.B \-V
is to
.B \-v.
.PP
After processing of flag arguments, if arguments remain but none of the
.B \-c,
.B \-i,
.B \-s,
or
.B \-t
options was given, the first argument is taken as the name of a file of
commands to be executed.
The shell opens this file, and saves its name for possible resubstitution
by `$0'.
Since many systems use either the standard version 6 or version 7 shells
whose shell scripts are not compatible with this shell, the shell will
execute such a `standard' shell if the first character of a script
is not a `#', i.e. if the script does not start with a comment.
Remaining arguments initialize the variable
.I argv.
.sh "Signal handling"
The shell normally ignores
.I quit
signals.
Jobs running detached (either by `&' or the \fIbg\fR or \fB%... &\fR
commands) are immune to signals generated from the keyboard, including
hangups.
Other signals have the values which the shell inherited from its parent.
The shells handling of interrupts and terminate signals
in shell scripts can be controlled by
.I onintr.
Login shells catch the
.I terminate
signal; otherwise this signal is passed on to children from the state in the
shell's parent.
In no case are interrupts allowed when a login shell is reading the file
`\&.logout'.
.SH AUTHOR
William Joy.
Job control and directory stack features first implemented by J.E. Kulp of
I.I.A.S.A, Laxenburg, Austria,
with different syntax than that used now.  File name completion
code written by Ken Greer, HP Labs.
.SH FILES
.ta 1.75i
.nf
~/.cshrc	Read at beginning of execution by each shell.
~/.login	Read by login shell, after `.cshrc' at login.
~/.logout	Read by login shell, at logout.
/bin/sh	Standard shell, for shell scripts not starting with a `#'.
/tmp/sh*	Temporary file for `<<'.
/etc/passwd	Source of home directories for `~name'.
.fi
.SH LIMITATIONS
Words can be no longer than 1024 characters.
The system limits argument lists to 10240 characters.
The number of arguments to a command which involves filename expansion
is limited to 1/6'th the number of characters allowed in an argument list.
Command substitutions may substitute no more characters than are
allowed in an argument list.
To detect looping, the shell restricts the number of
.I alias
substitutions on a single line to 20.
.SH "SEE ALSO"
sh(1), access(2), execve(2), fork(2), killpg(2), pipe(2), sigvec(2),
umask(2), setrlimit(2), wait(2), tty(4), a.out(5), environ(7),
`An introduction to the C shell'
.SH BUGS
When a command is restarted from a stop,
the shell prints the directory it started in if this is different
from the current directory; this can be misleading (i.e. wrong)
as the job may have changed directories internally.
.PP
Shell builtin functions are not stoppable/restartable.
Command sequences of the form `a ; b ; c' are also not handled gracefully
when stopping is attempted.  If you suspend `b', the shell will then
immediately execute `c'.  This is especially noticeable if this
expansion results from an
.I alias.
It suffices to place the sequence of commands in ()'s to force it to
a subshell, i.e. `( a ; b ; c )'.
.PP
Control over tty output after processes are started is primitive;
perhaps this will inspire someone to work on a good virtual
terminal interface.  In a virtual terminal interface much more
interesting things could be done with output control.
.PP
Alias substitution is most often used to clumsily simulate shell procedures;
shell procedures should be provided rather than aliases.
.PP
Commands within loops, prompted for by `?', are not placed in the
.I history
list.
Control structure should be parsed rather than being recognized as built-in
commands.  This would allow control commands to be placed anywhere,
to be combined with `|', and to be used with `&' and `;' metasyntax.
.PP
It should be possible to use the `:' modifiers on the output of command
substitutions.
All and more than one `:' modifier should be allowed on `$' substitutions.
.PP
The way the
.B filec
facility is implemented is ugly and expensive.
