.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)cp.1	6.2 (Berkeley) 6/8/85
.\"
.TH CP 1 "June 8, 1985"
.UC 4
.SH NAME
cp \- copy
.SH SYNOPSIS
.B cp
[
.B \-ip
] file1 file2
.PP
.B cp
[
.B \-ipr
] file ... directory
.SH DESCRIPTION
.I File1
is copied onto
.IR file2 .
By default, the mode and owner of  
.I file2
are preserved if it already
existed; otherwise the mode of the source file modified by the current
.IR umask (2)
is used.  The
.B \-p
option causes
.I cp
to attempt to preserve (duplicate) in its copies the modification
times and modes of the source files, ignoring the present
.IR umask .
.PP
In the second form, one or more
.I files
are copied into the
.I directory
with their original file-names.
.PP
.I Cp
refuses to copy a file onto itself.
.PP
If the 
.B \-i
option is specified, 
.I cp
will prompt the user with the name of the file
whenever the copy will cause an old file to be
overwritten. An answer of 'y' will cause 
.I cp
to continue. Any other answer will prevent it
from overwriting the file.
.PP
If the
.B \-r
option is specified and any of the source files are directories,
.I cp
copies each subtree rooted at that name; in this case
the destination must be a directory.
.SH "SEE ALSO"
cat(1), mv(1), rcp(1C)
