.\" Copyright (c) 1987 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)cmp.1	6.2 (Berkeley) 11/18/87
.\"
.TH CMP 1 "November 18, 1987"
.AT 3
.SH NAME
cmp \- compare two files
.SH SYNOPSIS
.B cmp
[
.B \-l
] [
.B \-s
] file1 file2 [ skip1 ] [ skip2 ]
.SH DESCRIPTION
The two files are compared.  (If \fIfile1\fP is `\-', the standard
input is used.)  With no options, \fIcmp\fP makes no comment if the
files are the same; if they differ, it reports the byte and line
number at which the difference occurred, or, that one file is an
initial subsequence of the other.  \fISkip1\fP and \fIskip2\fP are
initial byte offsets into \fIfile1\fP and \fIfile2\fP respectively,
and may be either octal or decimal; a leading ``0'' denotes octal.
.PP
Options:
.TP 6
.B \-s
Print nothing for differing files; set exit codes only.
.TP 6
.B \-l
Print the byte number (in decimal) and the differing bytes (in octal)
for all differences between the two files.
.SH "SEE ALSO"
diff(1), comm(1)
.SH DIAGNOSTICS
Exit code 0 is returned for identical files, 1 for different files,
and 2 for an inaccessible or missing argument, or a system error.
