
# line 27 "../gcc-1.37.1/cexp.y"
#include "config.h"
#include <setjmp.h>
/* #define YYDEBUG 1 */

  int yylex ();
  void yyerror ();
  int expression_value;

  static jmp_buf parse_return_error;

  /* some external tables of character types */
  extern unsigned char is_idstart[], is_idchar[];

#ifndef CHAR_TYPE_SIZE
#define CHAR_TYPE_SIZE BITS_PER_UNIT
#endif

# line 45 "../gcc-1.37.1/cexp.y"
typedef union  {
  struct constant {long value; int unsignedp;} integer;
  int voidval;
  char *sval;
} YYSTYPE;
# define INT 257
# define CHAR 258
# define NAME 259
# define ERROR 260
# define OR 261
# define AND 262
# define EQUAL 263
# define NOTEQUAL 264
# define LEQ 265
# define GEQ 266
# define LSH 267
# define RSH 268
# define UNARY 269
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern short yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 203 "../gcc-1.37.1/cexp.y"


/* During parsing of a C expression, the pointer to the next character
   is in this variable.  */

static char *lexptr;

/* Take care of parsing a number (anything that starts with a digit).
   Set yylval and return the token type; update lexptr.
   LEN is the number of characters in it.  */

/* maybe needs to actually deal with floating point numbers */

int
parse_number (olen)
     int olen;
{
  register char *p = lexptr;
  register long n = 0;
  register int c;
  register int base = 10;
  register int len = olen;

  for (c = 0; c < len; c++)
    if (p[c] == '.') {
      /* It's a float since it contains a point.  */
      yyerror ("floating point numbers not allowed in #if expressions");
      return ERROR;
    }

  yylval.integer.unsignedp = 0;

  if (len >= 3 && (!strncmp (p, "0x", 2) || !strncmp (p, "0X", 2))) {
    p += 2;
    base = 16;
    len -= 2;
  }
  else if (*p == '0')
    base = 8;

  while (len > 0) {
    c = *p++;
    len--;
    if (c >= 'A' && c <= 'Z') c += 'a' - 'A';

    if (c >= '0' && c <= '9') {
      n *= base;
      n += c - '0';
    } else if (base == 16 && c >= 'a' && c <= 'f') {
      n *= base;
      n += c - 'a' + 10;
    } else {
      /* `l' means long, and `u' means unsigned.  */
      while (1) {
	if (c == 'l' || c == 'L')
	  ;
	else if (c == 'u' || c == 'U')
	  yylval.integer.unsignedp = 1;
	else
	  break;

	if (len == 0)
	  break;
	c = *p++;
	len--;
      }
      /* Don't look for any more digits after the suffixes.  */
      break;
    }
  }

  if (len != 0) {
    yyerror ("Invalid number in #if expression");
    return ERROR;
  }

  /* If too big to be signed, consider it unsigned.  */
  if (n < 0)
    yylval.integer.unsignedp = 1;

  lexptr = p;
  yylval.integer.value = n;
  return INT;
}

struct token {
  char *operator;
  int token;
};

#ifndef NULL
#define NULL 0
#endif

static struct token tokentab2[] = {
  {"&&", AND},
  {"||", OR},
  {"<<", LSH},
  {">>", RSH},
  {"==", EQUAL},
  {"!=", NOTEQUAL},
  {"<=", LEQ},
  {">=", GEQ},
  {NULL, ERROR}
};

/* Read one token, getting characters through lexptr.  */

int
yylex ()
{
  register int c;
  register int namelen;
  register char *tokstart;
  register struct token *toktab;

 retry:

  tokstart = lexptr;
  c = *tokstart;
  /* See if it is a special token of length 2.  */
  for (toktab = tokentab2; toktab->operator != NULL; toktab++)
    if (c == *toktab->operator && tokstart[1] == toktab->operator[1]) {
      lexptr += 2;
      return toktab->token;
    }

  switch (c) {
  case 0:
    return 0;
    
  case ' ':
  case '\t':
  case '\n':
    lexptr++;
    goto retry;
    
  case '\'':
    lexptr++;
    c = *lexptr++;
    if (c == '\\')
      c = parse_escape (&lexptr);

    /* Sign-extend the constant if chars are signed on target machine.  */
    {
      if (lookup ("__CHAR_UNSIGNED__", sizeof ("__CHAR_UNSIGNED__")-1, -1)
	  || ((c >> (CHAR_TYPE_SIZE - 1)) & 1) == 0)
	yylval.integer.value = c & ((1 << CHAR_TYPE_SIZE) - 1);
      else
	yylval.integer.value = c | ~((1 << CHAR_TYPE_SIZE) - 1);
    }

    yylval.integer.unsignedp = 0;
    c = *lexptr++;
    if (c != '\'') {
      yyerror ("Invalid character constant in #if");
      return ERROR;
    }
    
    return CHAR;

    /* some of these chars are invalid in constant expressions;
       maybe do something about them later */
  case '/':
  case '+':
  case '-':
  case '*':
  case '%':
  case '|':
  case '&':
  case '^':
  case '~':
  case '!':
  case '@':
  case '<':
  case '>':
  case '(':
  case ')':
  case '[':
  case ']':
  case '.':
  case '?':
  case ':':
  case '=':
  case '{':
  case '}':
  case ',':
    lexptr++;
    return c;
    
  case '"':
    yyerror ("double quoted strings not allowed in #if expressions");
    return ERROR;
  }
  if (c >= '0' && c <= '9') {
    /* It's a number */
    for (namelen = 0;
	 c = tokstart[namelen], is_idchar[c] || c == '.'; 
	 namelen++)
      ;
    return parse_number (namelen);
  }
  
  if (!is_idstart[c]) {
    yyerror ("Invalid token in expression");
    return ERROR;
  }
  
  /* It is a name.  See how long it is.  */
  
  for (namelen = 0; is_idchar[tokstart[namelen]]; namelen++)
    ;
  
  lexptr += namelen;
  return NAME;
}


/* Parse a C escape sequence.  STRING_PTR points to a variable
   containing a pointer to the string to parse.  That pointer
   is updated past the characters we use.  The value of the
   escape sequence is returned.

   A negative value means the sequence \ newline was seen,
   which is supposed to be equivalent to nothing at all.

   If \ is followed by a null character, we return a negative
   value and leave the string pointer pointing at the null character.

   If \ is followed by 000, we return 0 and leave the string pointer
   after the zeros.  A value of 0 does not mean end of string.  */

int
parse_escape (string_ptr)
     char **string_ptr;
{
  register int c = *(*string_ptr)++;
  switch (c)
    {
    case 'a':
      return TARGET_BELL;
    case 'b':
      return TARGET_BS;
    case 'e':
      return 033;
    case 'f':
      return TARGET_FF;
    case 'n':
      return TARGET_NEWLINE;
    case 'r':
      return TARGET_CR;
    case 't':
      return TARGET_TAB;
    case 'v':
      return TARGET_VT;
    case '\n':
      return -2;
    case 0:
      (*string_ptr)--;
      return 0;
    case '^':
      c = *(*string_ptr)++;
      if (c == '\\')
	c = parse_escape (string_ptr);
      if (c == '?')
	return 0177;
      return (c & 0200) | (c & 037);
      
    case '0':
    case '1':
    case '2':
    case '3':
    case '4':
    case '5':
    case '6':
    case '7':
      {
	register int i = c - '0';
	register int count = 0;
	while (++count < 3)
	  {
	    c = *(*string_ptr)++;
	    if (c >= '0' && c <= '7')
	      i = (i << 3) + c - '0';
	    else
	      {
		(*string_ptr)--;
		break;
	      }
	  }
	if ((i & ~((1 << CHAR_TYPE_SIZE) - 1)) != 0)
	  {
	    i &= (1 << CHAR_TYPE_SIZE) - 1;
	    warning ("octal character constant does not fit in a byte");
	  }
	return i;
      }
    case 'x':
      {
	register int i = 0;
	register int count = 0;
	for (;;)
	  {
	    c = *(*string_ptr)++;
	    if (c >= '0' && c <= '9')
	      i = (i << 4) + c - '0';
	    else if (c >= 'a' && c <= 'f')
	      i = (i << 4) + c - 'a' + 10;
	    else if (c >= 'A' && c <= 'F')
	      i = (i << 4) + c - 'A' + 10;
	    else
	      {
		(*string_ptr)--;
		break;
	      }
	  }
	if ((i & ~((1 << BITS_PER_UNIT) - 1)) != 0)
	  {
	    i &= (1 << BITS_PER_UNIT) - 1;
	    warning ("hex character constant does not fit in a byte");
	  }
	return i;
      }
    default:
      return c;
    }
}

void
yyerror (s)
     char *s;
{
  error (s);
  longjmp (parse_return_error, 1);
}

/* This page contains the entry point to this file.  */

/* Parse STRING as an expression, and complain if this fails
   to use up all of the contents of STRING.  */
/* We do not support C comments.  They should be removed before
   this function is called.  */

int
parse_c_expression (string)
     char *string;
{
  lexptr = string;
  
  if (lexptr == 0 || *lexptr == 0) {
    error ("empty #if expression");
    return 0;			/* don't include the #if group */
  }

  /* if there is some sort of scanning error, just return 0 and assume
     the parsing routine has printed an error message somewhere.
     there is surely a better thing to do than this.     */
  if (setjmp (parse_return_error))
    return 0;

  if (yyparse ())
    return 0;			/* actually this is never reached
				   the way things stand. */
  if (*lexptr)
    error ("Junk after end of expression.");

  return expression_value;	/* set by yyparse () */
}

#ifdef TEST_EXP_READER
/* main program, for testing purposes. */
main ()
{
  int n, c;
  char buf[1024];
  extern int yydebug;
/*
  yydebug = 1;
*/
  initialize_random_junk ();

  for (;;) {
    printf ("enter expression: ");
    n = 0;
    while ((buf[n] = getchar ()) != '\n' && buf[n] != EOF)
      n++;
    if (buf[n] == EOF)
      break;
    buf[n] = '\0';
    printf ("parser returned %d\n", parse_c_expression (buf));
  }
}

/* table to tell if char can be part of a C identifier. */
unsigned char is_idchar[256];
/* table to tell if char can be first char of a c identifier. */
unsigned char is_idstart[256];
/* table to tell if c is horizontal space.  isspace () thinks that
   newline is space; this is not a good idea for this program. */
char is_hor_space[256];

/*
 * initialize random junk in the hash table and maybe other places
 */
initialize_random_junk ()
{
  register int i;

  /*
   * Set up is_idchar and is_idstart tables.  These should be
   * faster than saying (is_alpha (c) || c == '_'), etc.
   * Must do set up these things before calling any routines tthat
   * refer to them.
   */
  for (i = 'a'; i <= 'z'; i++) {
    ++is_idchar[i - 'a' + 'A'];
    ++is_idchar[i];
    ++is_idstart[i - 'a' + 'A'];
    ++is_idstart[i];
  }
  for (i = '0'; i <= '9'; i++)
    ++is_idchar[i];
  ++is_idchar['_'];
  ++is_idstart['_'];
#if DOLLARS_IN_IDENTIFIERS
  ++is_idchar['$'];
  ++is_idstart['$'];
#endif

  /* horizontal space table */
  ++is_hor_space[' '];
  ++is_hor_space['\t'];
}

error (msg)
{
  printf ("error: %s\n", msg);
}

warning (msg)
{
  printf ("warning: %s\n", msg);
}

struct hashnode *
lookup (name, len, hash)
     char *name;
     int len;
     int hash;
{
  return (DEFAULT_SIGNED_CHAR) ? 0 : ((struct hashnode *) -1);
}
#endif
short yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 31
# define YYLAST 345
short yyact[]={

  15,  26,  12,   1,  15,  13,  16,   2,  17,  13,
  14,   0,  15,  26,  14,   0,  36,  13,  16,   0,
  17,  58,  14,  24,  15,  25,  31,   0,   0,  13,
  16,   0,  17,  57,  14,  24,  12,  25,  31,  15,
  26,   0,   0,   0,  13,  16,   0,  17,   0,  14,
  15,  26,   0,   0,   0,  13,  16,  27,  17,   0,
  14,   0,  24,   0,  25,   0,  15,  26,   0,  27,
   0,  13,  16,  24,  17,  25,  14,   0,  15,  26,
   0,   0,   0,  13,  16,   0,  17,  28,  14,  24,
   0,  25,  15,   0,   0,   0,  27,  13,  16,  28,
  17,  24,  14,  25,  15,   0,   0,  27,   0,  13,
  16,   0,  17,   0,  14,  24,   0,  25,   5,   0,
   0,   0,   0,  27,   0,   8,  28,  24,   6,  25,
   4,   0,   0,   3,   0,   0,   0,  28,  32,  33,
  34,  35,   0,   0,   0,   0,  37,  38,  39,  40,
  41,  42,  43,  44,  45,  46,  47,  48,  49,  50,
  51,  52,  53,  54,  55,  56,  15,   0,   0,   0,
   0,  13,  16,   0,  17,   0,  14,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,  59,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   7,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,  30,  29,  20,  21,  22,  23,
  18,  19,   0,   0,   0,   0,  30,  29,  20,  21,
  22,  23,  18,  19,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,  18,  19,   0,   0,   0,   0,
   0,   0,   0,   0,  29,  20,  21,  22,  23,  18,
  19,   0,   0,   0,   0,   0,  20,  21,  22,  23,
  18,  19,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,  20,  21,  22,  23,  18,  19,   0,   0,
   0,   0,   0,   0,  20,  21,  22,  23,  18,  19,
   0,   0,   0,   0,   0,   0,   0,   0,  20,  21,
  22,  23,  18,  19,   0,   0,   0,   0,   0,   0,
   0,   0,  22,  23,  18,  19,   0,   0,   0,   0,
   0,   0,   9,  10,  11 };
short yypact[]={

  85,-1000, -42, -25,  85,  85,  85,  85,  85,-1000,
-1000,-1000,  85,  85,  85,  85,  85,  85,  85,  85,
  85,  85,  85,  85,  85,  85,  85,  85,  85,  85,
  85,  85,-1000,-1000,-1000,-1000,  -8, -25,-1000,-1000,
-1000, -33, -33, 129, 129,  67,  67, -13, -13, -13,
 -13,  55,  41,  29,  13,   2, -37,-1000,  85, -25 };
short yypgo[]={

   0, 133,   7,   3 };
short yyr1[]={

   0,   3,   2,   2,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1 };
short yyr2[]={

   0,   1,   1,   3,   2,   2,   2,   2,   3,   3,
   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
   3,   3,   3,   3,   3,   3,   3,   5,   1,   1,
   1 };
short yychk[]={

-1000,  -3,  -2,  -1,  45,  33,  43, 126,  40, 257,
 258, 259,  44,  42,  47,  37,  43,  45, 267, 268,
 263, 264, 265, 266,  60,  62,  38,  94, 124, 262,
 261,  63,  -1,  -1,  -1,  -1,  -2,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
  -1,  -1,  -1,  -1,  -1,  -1,  -1,  41,  58,  -1 };
short yydef[]={

   0,  -2,   1,   2,   0,   0,   0,   0,   0,  28,
  29,  30,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   4,   5,   6,   7,   0,   3,   9,  10,
  11,  12,  13,  14,  15,  16,  17,  18,  19,  20,
  21,  22,  23,  24,  25,  26,   0,   8,   0,  27 };
#ifndef lint
static char yaccpar_sccsid[] = "@(#)yaccpar	4.1	(Berkeley)	2/11/83";
#endif not lint

#
# define YYFLAG -1000
# define YYERROR goto yyerrlab
# define YYACCEPT return(0)
# define YYABORT return(1)

/*	parser for yacc output	*/

#ifdef YYDEBUG
int yydebug = 0; /* 1 for debugging */
#endif
YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */
int yychar = -1; /* current input token number */
int yynerrs = 0;  /* number of errors */
short yyerrflag = 0;  /* error recovery flag */

yyparse() {

	short yys[YYMAXDEPTH];
	short yyj, yym;
	register YYSTYPE *yypvt;
	register short yystate, *yyps, yyn;
	register YYSTYPE *yypv;
	register short *yyxi;

	yystate = 0;
	yychar = -1;
	yynerrs = 0;
	yyerrflag = 0;
	yyps= &yys[-1];
	yypv= &yyv[-1];

 yystack:    /* put a state and value onto the stack */

#ifdef YYDEBUG
	if( yydebug  ) printf( "state %d, char 0%o\n", yystate, yychar );
#endif
		if( ++yyps> &yys[YYMAXDEPTH] ) { yyerror( "yacc stack overflow" ); return(1); }
		*yyps = yystate;
		++yypv;
		*yypv = yyval;

 yynewstate:

	yyn = yypact[yystate];

	if( yyn<= YYFLAG ) goto yydefault; /* simple state */

	if( yychar<0 ) if( (yychar=yylex())<0 ) yychar=0;
	if( (yyn += yychar)<0 || yyn >= YYLAST ) goto yydefault;

	if( yychk[ yyn=yyact[ yyn ] ] == yychar ){ /* valid shift */
		yychar = -1;
		yyval = yylval;
		yystate = yyn;
		if( yyerrflag > 0 ) --yyerrflag;
		goto yystack;
		}

 yydefault:
	/* default state action */

	if( (yyn=yydef[yystate]) == -2 ) {
		if( yychar<0 ) if( (yychar=yylex())<0 ) yychar = 0;
		/* look through exception table */

		for( yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate) ; yyxi += 2 ) ; /* VOID */

		while( *(yyxi+=2) >= 0 ){
			if( *yyxi == yychar ) break;
			}
		if( (yyn = yyxi[1]) < 0 ) return(0);   /* accept */
		}

	if( yyn == 0 ){ /* error */
		/* error ... attempt to resume parsing */

		switch( yyerrflag ){

		case 0:   /* brand new error */

			yyerror( "syntax error" );
		yyerrlab:
			++yynerrs;

		case 1:
		case 2: /* incompletely recovered error ... try again */

			yyerrflag = 3;

			/* find a state where "error" is a legal shift action */

			while ( yyps >= yys ) {
			   yyn = yypact[*yyps] + YYERRCODE;
			   if( yyn>= 0 && yyn < YYLAST && yychk[yyact[yyn]] == YYERRCODE ){
			      yystate = yyact[yyn];  /* simulate a shift of "error" */
			      goto yystack;
			      }
			   yyn = yypact[*yyps];

			   /* the current yyps has no shift onn "error", pop stack */

#ifdef YYDEBUG
			   if( yydebug ) printf( "error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1] );
#endif
			   --yyps;
			   --yypv;
			   }

			/* there is no state on the stack with an error shift ... abort */

	yyabort:
			return(1);


		case 3:  /* no shift yet; clobber input char */

#ifdef YYDEBUG
			if( yydebug ) printf( "error recovery discards char %d\n", yychar );
#endif

			if( yychar == 0 ) goto yyabort; /* don't discard EOF, quit */
			yychar = -1;
			goto yynewstate;   /* try again in the same state */

			}

		}

	/* reduction by production yyn */

#ifdef YYDEBUG
		if( yydebug ) printf("reduce %d\n",yyn);
#endif
		yyps -= yyr2[yyn];
		yypvt = yypv;
		yypv -= yyr2[yyn];
		yyval = yypv[1];
		yym=yyn;
			/* consult goto table to find next state */
		yyn = yyr1[yyn];
		yyj = yypgo[yyn] + *yyps + 1;
		if( yyj>=YYLAST || yychk[ yystate = yyact[yyj] ] != -yyn ) yystate = yyact[yypgo[yyn]];
		switch(yym){
			
case 1:
# line 75 "../gcc-1.37.1/cexp.y"
{ expression_value = yypvt[-0].integer.value; } break;
case 3:
# line 81 "../gcc-1.37.1/cexp.y"
{ yyval.integer = yypvt[-0].integer; } break;
case 4:
# line 86 "../gcc-1.37.1/cexp.y"
{ yyval.integer.value = - yypvt[-0].integer.value;
			  yyval.integer.unsignedp = yypvt[-0].integer.unsignedp; } break;
case 5:
# line 89 "../gcc-1.37.1/cexp.y"
{ yyval.integer.value = ! yypvt[-0].integer.value;
			  yyval.integer.unsignedp = 0; } break;
case 6:
# line 92 "../gcc-1.37.1/cexp.y"
{ yyval.integer = yypvt[-0].integer; } break;
case 7:
# line 94 "../gcc-1.37.1/cexp.y"
{ yyval.integer.value = ~ yypvt[-0].integer.value;
			  yyval.integer.unsignedp = yypvt[-0].integer.unsignedp; } break;
case 8:
# line 97 "../gcc-1.37.1/cexp.y"
{ yyval.integer = yypvt[-1].integer; } break;
case 9:
# line 102 "../gcc-1.37.1/cexp.y"
{ yyval.integer.unsignedp = yypvt[-2].integer.unsignedp || yypvt[-0].integer.unsignedp;
			  if (yyval.integer.unsignedp)
			    yyval.integer.value = (unsigned) yypvt[-2].integer.value * yypvt[-0].integer.value;
			  else
			    yyval.integer.value = yypvt[-2].integer.value * yypvt[-0].integer.value; } break;
case 10:
# line 108 "../gcc-1.37.1/cexp.y"
{ if (yypvt[-0].integer.value == 0)
			    {
			      error ("division by zero in #if");
			      yypvt[-0].integer.value = 1;
			    }
			  yyval.integer.unsignedp = yypvt[-2].integer.unsignedp || yypvt[-0].integer.unsignedp;
			  if (yyval.integer.unsignedp)
			    yyval.integer.value = (unsigned) yypvt[-2].integer.value / yypvt[-0].integer.value;
			  else
			    yyval.integer.value = yypvt[-2].integer.value / yypvt[-0].integer.value; } break;
case 11:
# line 119 "../gcc-1.37.1/cexp.y"
{ if (yypvt[-0].integer.value == 0)
			    {
			      error ("division by zero in #if");
			      yypvt[-0].integer.value = 1;
			    }
			  yyval.integer.unsignedp = yypvt[-2].integer.unsignedp || yypvt[-0].integer.unsignedp;
			  if (yyval.integer.unsignedp)
			    yyval.integer.value = (unsigned) yypvt[-2].integer.value % yypvt[-0].integer.value;
			  else
			    yyval.integer.value = yypvt[-2].integer.value % yypvt[-0].integer.value; } break;
case 12:
# line 130 "../gcc-1.37.1/cexp.y"
{ yyval.integer.value = yypvt[-2].integer.value + yypvt[-0].integer.value;
			  yyval.integer.unsignedp = yypvt[-2].integer.unsignedp || yypvt[-0].integer.unsignedp; } break;
case 13:
# line 133 "../gcc-1.37.1/cexp.y"
{ yyval.integer.value = yypvt[-2].integer.value - yypvt[-0].integer.value;
			  yyval.integer.unsignedp = yypvt[-2].integer.unsignedp || yypvt[-0].integer.unsignedp; } break;
case 14:
# line 136 "../gcc-1.37.1/cexp.y"
{ yyval.integer.unsignedp = yypvt[-2].integer.unsignedp;
			  if (yyval.integer.unsignedp)
			    yyval.integer.value = (unsigned) yypvt[-2].integer.value << yypvt[-0].integer.value;
			  else
			    yyval.integer.value = yypvt[-2].integer.value << yypvt[-0].integer.value; } break;
case 15:
# line 142 "../gcc-1.37.1/cexp.y"
{ yyval.integer.unsignedp = yypvt[-2].integer.unsignedp;
			  if (yyval.integer.unsignedp)
			    yyval.integer.value = (unsigned) yypvt[-2].integer.value >> yypvt[-0].integer.value;
			  else
			    yyval.integer.value = yypvt[-2].integer.value >> yypvt[-0].integer.value; } break;
case 16:
# line 148 "../gcc-1.37.1/cexp.y"
{ yyval.integer.value = (yypvt[-2].integer.value == yypvt[-0].integer.value);
			  yyval.integer.unsignedp = 0; } break;
case 17:
# line 151 "../gcc-1.37.1/cexp.y"
{ yyval.integer.value = (yypvt[-2].integer.value != yypvt[-0].integer.value);
			  yyval.integer.unsignedp = 0; } break;
case 18:
# line 154 "../gcc-1.37.1/cexp.y"
{ yyval.integer.unsignedp = 0;
			  if (yypvt[-2].integer.unsignedp || yypvt[-0].integer.unsignedp)
			    yyval.integer.value = (unsigned) yypvt[-2].integer.value <= yypvt[-0].integer.value;
			  else
			    yyval.integer.value = yypvt[-2].integer.value <= yypvt[-0].integer.value; } break;
case 19:
# line 160 "../gcc-1.37.1/cexp.y"
{ yyval.integer.unsignedp = 0;
			  if (yypvt[-2].integer.unsignedp || yypvt[-0].integer.unsignedp)
			    yyval.integer.value = (unsigned) yypvt[-2].integer.value >= yypvt[-0].integer.value;
			  else
			    yyval.integer.value = yypvt[-2].integer.value >= yypvt[-0].integer.value; } break;
case 20:
# line 166 "../gcc-1.37.1/cexp.y"
{ yyval.integer.unsignedp = 0;
			  if (yypvt[-2].integer.unsignedp || yypvt[-0].integer.unsignedp)
			    yyval.integer.value = (unsigned) yypvt[-2].integer.value < yypvt[-0].integer.value;
			  else
			    yyval.integer.value = yypvt[-2].integer.value < yypvt[-0].integer.value; } break;
case 21:
# line 172 "../gcc-1.37.1/cexp.y"
{ yyval.integer.unsignedp = 0;
			  if (yypvt[-2].integer.unsignedp || yypvt[-0].integer.unsignedp)
			    yyval.integer.value = (unsigned) yypvt[-2].integer.value > yypvt[-0].integer.value;
			  else
			    yyval.integer.value = yypvt[-2].integer.value > yypvt[-0].integer.value; } break;
case 22:
# line 178 "../gcc-1.37.1/cexp.y"
{ yyval.integer.value = yypvt[-2].integer.value & yypvt[-0].integer.value;
			  yyval.integer.unsignedp = yypvt[-2].integer.unsignedp || yypvt[-0].integer.unsignedp; } break;
case 23:
# line 181 "../gcc-1.37.1/cexp.y"
{ yyval.integer.value = yypvt[-2].integer.value ^ yypvt[-0].integer.value;
			  yyval.integer.unsignedp = yypvt[-2].integer.unsignedp || yypvt[-0].integer.unsignedp; } break;
case 24:
# line 184 "../gcc-1.37.1/cexp.y"
{ yyval.integer.value = yypvt[-2].integer.value | yypvt[-0].integer.value;
			  yyval.integer.unsignedp = yypvt[-2].integer.unsignedp || yypvt[-0].integer.unsignedp; } break;
case 25:
# line 187 "../gcc-1.37.1/cexp.y"
{ yyval.integer.value = (yypvt[-2].integer.value && yypvt[-0].integer.value);
			  yyval.integer.unsignedp = 0; } break;
case 26:
# line 190 "../gcc-1.37.1/cexp.y"
{ yyval.integer.value = (yypvt[-2].integer.value || yypvt[-0].integer.value);
			  yyval.integer.unsignedp = 0; } break;
case 27:
# line 193 "../gcc-1.37.1/cexp.y"
{ yyval.integer.value = yypvt[-4].integer.value ? yypvt[-2].integer.value : yypvt[-0].integer.value;
			  yyval.integer.unsignedp = yypvt[-2].integer.unsignedp || yypvt[-0].integer.unsignedp; } break;
case 28:
# line 196 "../gcc-1.37.1/cexp.y"
{ yyval.integer = yylval.integer; } break;
case 29:
# line 198 "../gcc-1.37.1/cexp.y"
{ yyval.integer = yylval.integer; } break;
case 30:
# line 200 "../gcc-1.37.1/cexp.y"
{ yyval.integer.value = 0;
			  yyval.integer.unsignedp = 0; } break;
		}
		goto yystack;  /* stack new state and value */

	}
