.\" Copyright (c) 1985 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)window.1	6.5 (Berkeley) 5/12/86
.\"
.TH WINDOW 1 "May 12, 1986"
.UC 6
.SH NAME
window \- window environment
.SH SYNOPSIS
.B window
[
.B \-t
] [
.B \-f
] [
.B \-d
] [
.B \-e escape-char
] [
.B \-c command
]
.SH DESCRIPTION
\fIWindow\fP implements a window environment on
ASCII terminals.
.PP
A window is a rectangular portion of the physical terminal
screen associated with a set of processes.  Its size and
position can be changed by the user at any time.  Processes
communicate with their window in the same way they normally
interact with a terminal--through their standard input, output,
and diagnostic file descriptors.  The window program handles the
details of redirecting input an output to and from the
windows.  At any one time, only one window can receive
input from the keyboard, but all windows can simultaneously send output
to the display.
.PP
Windows can overlap and are framed as necessary.  Each window
is named by one of the digits ``1'' to ``9''.  This one character
identifier, as well as a user definable label string, are displayed
with the window on the top edge of its frame.  A window can be
designated to be in the \fIforeground\fP, in which case it will always be
on top of all normal, non-foreground windows, and can be covered
only by other foreground windows.  A window need not be completely
within the edges of the terminal screen.  Thus a large window
(possibly larger than the screen) may be positioned to show only
a portion of its full size.
.PP
Each window has a cursor and a set of control functions.  Most intelligent
terminal operations such as line and
character deletion and insertion are supported.  Display modes
such as underlining and reverse video are available if they are
supported by the terminal.  In addition,
similar to terminals with multiple pages of memory,
each window has a text buffer which can have more lines than the window
itself.
.SH OPTIONS
When \fIwindow\fP starts up, the commands (see long commands below)
contained in the file \fI.windowrc\fP in the user's home directory are
executed.  If it does not exist, two equal sized windows spanning
the terminal screen are created by default.
.PP
The command line options are
.TP
.B \-t
Turn on terse mode (see \fIterse\fP command below).
.TP
.B \-f
Fast.  Don't perform any startup action.
.TP
.B \-d
Ignore \fI.windowrc\fP and create the two default
windows instead.
.TP
.B \-e escape-char
Set the escape character to \fIescape-char\fP.  \fIEscape-char\fP
can be a single character, or in the form \fI^X\fP where \fIX\fP
is any character, meaning control-\fIX\fP.
.TP
.B \-c command
Execute the string \fIcommand\fP as a long command (see below)
before doing anything else.
.SH "PROCESS ENVIRONMENT"
With each newly created window, a shell program is spawned with its
process environment tailored to that window.  Its standard input,
output, and diagnostic file descriptors are bound to one end of either
a pseudo-terminal (\fIpty\fP (4)) or a UNIX domain socket
(\fIsocketpair\fP (4)).  If a pseudo-terminal is used, then its special
characters and modes (see \fIstty\fP (1)) are copied from the physical
terminal.  A \fItermcap\fP (5) entry tailored to this window is created
and passed as environment (\fIenviron\fP (5)) variable
\fITERMCAP\fP.  The termcap entry contains the window's size and
characteristics as well as information from the physical terminal,
such as the existence of underline, reverse video, and other display
modes, and the codes produced by the terminal's function keys,
if any.  In addition, the window size attributes of the pseudo-terminal
are set to reflect the size of this window, and updated whenever
it is changed by the user.  In particular, the editor \fIvi\fP (1) uses
this information to redraw its display.
.SH OPERATION
.PP
During normal execution, \fIwindow\fP can be in one of two states:
conversation mode and command mode.  In conversation mode, the
terminal's real cursor is placed at the cursor position of a particular
window--called the current window--and input from the keyboard is sent
to the process in that window.  The current window is always
on top of all other windows, except those in foreground.  In addition,
it is set apart by highlighting its identifier and label in reverse video.
.PP
Typing \fIwindow\fP's escape character (normally ^P) in conversation
mode switches it into command mode.  In command mode, the top line of
the terminal screen becomes the command prompt window, and \fIwindow\fP
interprets input from the keyboard as commands to manipulate windows.
.PP
There are two types of commands: short commands are usually one or two
key strokes; long commands are strings either typed by the user in the
command window (see the ``:'' command below), or read from a file (see
\fIsource\fP below).
.SH "SHORT COMMANDS"
Below, \fI#\fP represents one of the digits ``1'' to ``9''
corresponding to the windows 1 to 9.  \fI^X\fP means control-\fIX\fP,
where \fPX\fP is any character.  In particular, \fI^^\fP is
control-^.  \fIEscape\fP is the escape key, or \fI^[\fP.
.TP
.B #
Select window \fI#\fP as the current window
and return to conversation mode.
.TP
.B %#
Select window \fI#\fP but stay in command mode.
.TP
.B ^^
Select the previous window and return to conversation
mode.  This is useful for toggling between two windows.
.TP
.B escape
Return to conversation mode.
.TP
.B ^P
Return to conversation mode and write ^P to the
current window.  Thus, typing two ^P's in conversation
mode sends one to the current window.  If the \fIwindow\fP
escape is changed to some other character, that
character takes the place of ^P here.
.TP
.B ?
List a short summary of commands.
.TP
.B ^L
Redraw the screen.
.TP
.B q
Exit \fIwindow\fP.  Confirmation is requested.
.TP
.B ^Z
Suspend \fIwindow\fP.
.TP
.B w
Create a new window.  The user is prompted for the positions
of the upper left and lower right corners of the window.
The cursor is placed on the screen and the keys ``h'', ``j'',
``k'', and ``l''
move the cursor left, down, up, and right, respectively.
The keys ``H'', ``J'', ``K'', and ``L'' move the cursor to the respective
limits of the screen.  Typing a number before the movement keys
repeats the movement that number of times.  Return enters the cursor position
as the upper left corner of the window.  The lower right corner
is entered in the same manner.  During this process,
the placement of the new window is indicated by a rectangular
box drawn on the screen, corresponding to where the new window
will be framed.  Typing escape at any point
cancels this command.
.IP
This window becomes the current window,
and is given the first available ID.  The default buffer size
is used (see \fInline\fP command below).
.IP
Only fully visible windows can be created this way.
.TP
.B c#
Close window \fI#\fP.  The process in the window is sent
the hangup signal (see \fIkill\fP (1)).  \fICsh\fP (1) should
handle this signal correctly and cause no problems.
.TP
.B m#
Move window \fI#\fP to another location.  A box in the shape
of the window is drawn on
the screen to indicate the new position of the window, and the same keys as
those for the \fIw\fP command are used to position the box.  The
window can be moved partially off-screen.
.TP
.B M#
Move window \fI#\fP to its previous position.
.TP
.B s#
Change the size of window \fI#\fP.  The user is prompted
to enter the new lower right corner of the window.  A box
is drawn to indicate the new window size.  The same
keys used in \fIw\fP and \fIm\fP are used to enter the position.
.TP
.B S#
Change window \fI#\fP to its previous size.
.TP
.B ^Y
Scroll the current window up by one line.
.TP
.B ^E
Scroll the current window down by one line.
.TP
.B ^U
Scroll the current window up by half the window size.
.TP
.B ^D
Scroll the current window down by half the window size.
.TP
.B ^B
Scroll the current window up by the full window size.
.TP
.B ^F
Scroll the current window down by the full window size.
.TP
.B h
Move the cursor of the current window left by one column.
.TP
.B j
Move the cursor of the current window down by one line.
.TP
.B k
Move the cursor of the current window up by one line.
.TP
.B l
Move the cursor of the current window right by one column.
.TP
.B ^S
Stop output in the current window.
.TP
.B ^Q
Start output in the current window.
.TP
.B :
Enter a line to be executed as long commands.  Normal line
editing characters (erase character, erase word, erase line) are
supported.
.SH "LONG COMMANDS"
Long commands are a sequence of statements
parsed much like a programming language, with a syntax
similar to that of C.  Numeric and string expressions and variables
are supported, as well as conditional statements.
.PP
There are two data types: string and number.  A string is a sequence
of letters or digits beginning with a letter.  ``_'' and ``.'' are
considered letters.  Alternately, non-alphanumeric characters can
be included in strings by quoting them in ``"'' or escaping them
with ``\\''.  In addition, the ``\\'' sequences of C are supported,
both inside and outside quotes (e.g., ``\\n'' is a new line,
``\\r'' a carriage return).  For example, these are legal strings:
abcde01234, "&#$^*&#", ab"$#"cd, ab\\$\\#cd, "/usr/ucb/window".
.PP
A number is an integer value in one of three forms:
a decimal number, an octal number preceded by ``0'',
or a hexadecimal number preceded by ``0x'' or ``0X''.  The natural
machine integer size is used (i.e., the signed integer type
of the C compiler).  As in C, a non-zero number represents
a boolean true.
.PP
The character ``#'' begins a comment which terminates at the
end of the line.
.PP
A statement is either a conditional or an expression.  Expression
statements are terminated with a new line or ``;''.  To continue
an expression on the next line, terminate the first line with ``\\''.
.SH "CONDITIONAL STATEMENT"
\fIWindow\fP has a single control structure:
the fully bracketed if statement in the form
.nf
	if <expr> then
		<statement>
		. . .
	elsif <expr> then
		<statement>
		. . .
	else
		<statement>
		. . .
	endif
.fi
The \fIelse\fP and \fIelsif\fP parts are optional, and the latter can
be repeated any number of times.  \fI<Expr>\fP must be numeric.
.SH EXPRESSIONS
Expressions in \fIwindow\fP are similar to those in the
C language, with most C operators supported on numeric
operands.  In addition, some are overloaded to operate on strings.
.PP
When an expression is used as a statement, its value is discarded
after evaluation.  Therefore, only expressions with side
effects (assignments and function calls) are useful as statements.
.PP
Single valued (no arrays) variables are supported, of both
numeric and string values.  Some variables are predefined.  They
are listed below.
.PP
The operators in order of increasing precedence:
.TP
.B <expr1> = <expr2>
Assignment.  The variable of name \fI<expr1>\fP, which must be string valued,
is assigned the result of \fI<expr2>\fP.  Returns the value of \fI<expr2>\fP.
.TP
.B <expr1> ? <expr2> : <expr3>
Returns the value of \fI<expr2>\fP if \fI<expr1>\fP evaluates true
(non-zero numeric value); returns the value of \fI<expr3>\fP otherwise.  Only
one of \fI<expr2>\fP and \fI<expr3>\fP is evaluated.  \fI<Expr1>\fP must
be numeric.
.TP
.B <expr1> || <expr2>
Logical or.  Numeric values only.  Short circuit evaluation is supported
(i.e., if \fI<expr1>\fP evaluates true, then \fI<expr2>\fP is not evaluated).
.TP
.B <expr1> && <expr2>
Logical and with short circuit evaluation.  Numeric values only.
.TP
.B <expr1> | <expr2>
Bitwise or.  Numeric values only.
.TP
.B <expr1> ^ <expr2>
Bitwise exclusive or.  Numeric values only.
.TP
.B <expr1> & <expr2>
Bitwise and.  Numeric values only.
.TP
.B <expr1> == <expr2>, <expr1> != <expr2>
Comparison (equal and not equal, respectively).  The boolean
result (either 1 or 0) of the comparison is returned.  The
operands can be numeric or string valued.  One string operand
forces the other to be converted to a string in necessary.
.TP
.B <expr1> < <expr2>, <expr1> > <expr2>, <expr1> <= <expr2>, <expr1> >= <expr2>
Less than, greater than, less than or equal to,
greater than or equal to.  Both numeric and string values, with
automatic conversion as above.
.TP
.B <expr1> << <expr2>, <expr1> >> <expr2>
If both operands are numbers, \fI<expr1>\fP is bit
shifted left (or right) by \fI<expr2>\fP bits.  If \fI<expr1>\fP is
a string, then its first (or last) \fI<expr2>\fP characters are
returns (if \fI<expr2>\fP is also a string, then its length is used
in place of its value).
.TP
.B <expr1> + <expr2>, <expr1> - <expr2>
Addition and subtraction on numbers.  For ``+'', if one
argument is a string, then the other is converted to a string,
and the result is the concatenation of the two strings.
.TP
.B <expr1> * <expr2>, <expr1> / <expr2>, <expr1> % <expr2>
Multiplication, division, modulo.  Numbers only.
.TP
.B -<expr>, ~<expr>, !<expr>, $<expr>, $?<expr>
The first three are unary minus, bitwise complement and logical complement
on numbers only.  The operator, ``$'', takes \fI<expr>\fP and returns
the value of the variable of that name.  If \fI<expr>\fP is numeric
with value \fIn\fP and it appears within an alias macro (see below),
then it refers to the nth argument of the alias invocation.  ``$?''
tests for the existence of the variable \fI<expr>\fP, and returns 1
if it exists or 0 otherwise.
.TP
.B <expr>(<arglist>)
Function call.  \fI<Expr>\fP must be a string that is the unique
prefix of the name of a builtin \fIwindow\fP function
or the full name of a user defined alias macro.  In the case of a builtin
function, \fI<arglist>\fP can be in one of two forms:
.br
	<expr1>, <expr2>, . . .
.br
	argname1 = <expr1>, argname2 = <expr2>, . . .
.br
The two forms can in fact be intermixed, but the result is
unpredictable.  Most arguments can be omitted; default values will
be supplied for them.  The \fIargnames\fP can be unique prefixes
of the the argument names.  The commas separating
arguments are used only to disambiguate, and can usually be omitted.
.IP
Only the first argument form is valid for user defined aliases.  Aliases
are defined using the \fIalias\fP builtin function (see below).  Arguments
are accessed via a variant of the variable mechanism (see ``$'' operator
above).
.IP
Most functions return value, but some are used for side effect
only and so must be used as statements.  When a function or an alias is used
as a statement, the parenthesis surrounding
the argument list may be omitted.  Aliases return no value.
.SH "BUILTIN FUNCTIONS"
The arguments are listed by name in their natural
order.  Optional arguments are in square brackets (``[ ]'').  Arguments
that have no names are in angle brackets (``<>'').
.TP
.B alias([<string>], [<string-list>])
If no argument is given, all currently defined alias macros are
listed.  Otherwise, \fI<string>\fP is defined as an alias,
with expansion \fI<string-list>\fP.  The previous definition of
\fI<string>\fP, if any, is returned.  Default for \fI<string-list>\fP
is no change.
.TP
.B close(<window-list>)
Close the windows specified in \fI<window-list>\fP.  If \fI<window-list>\fP
is the word \fIall\fP, than all windows are closed.  No value is returned.
.TP
.B cursormodes([modes])
Set the window cursor to \fImodes\fP.  \fIModes\fP is the bitwise
or of the mode bits defined as the variables \fIm_ul\fP (underline),
\fIm_rev\fP (reverse video), \fIm_blk\fP (blinking),
and \fIm_grp\fP (graphics, terminal dependent).  Return
value is the previous modes.  Default is no change.
For example, cursor($m_rev|$m_blk) sets the window cursors to blinking
reverse video.
.TP
.B echo([window], [<string-list>])
Write the list of strings, \fI<string-list>\fP, to \fIwindow\fP, separated
by spaces and terminated with a new line.  The strings are only
displayed in the window, the processes in the window are not
involved (see \fIwrite\fP below).  No value is returned.  Default
is the current window.
.TP
.B escape([escapec])
Set the escape character to \fIescape-char\fP.  Returns the old
escape character as a one character string.  Default is no
change.  \fPEscapec\fP can be a string of a single character, or
in the form \fI^X\fP, meaning control-\fIX\fP.
.TP
.B foreground([window], [flag])
Move \fIwindow\fP in or out of foreground.  \fIFlag\fP
can be one of \fIon\fP, \fIoff\fP,
\fIyes\fP, \fIno\fP, \fItrue\fP, or \fIfalse\fP, with obvious
meanings, or it can be a numeric expression, in which case
a non-zero value is true.  Returns the old foreground flag
as a number.  Default for \fIwindow\fP is the current window,
default for \fIflag\fP is no change.
.TP
.B label([window], [label])
Set the label of \fIwindow\fP to \fIlabel\fP.  Returns the old
label as a string.  Default for \fIwindow\fP is the current
window, default for \fIlabel\fP is no change.  To turn
off a label, set it to an empty string ("").
.TP
.B list()
No arguments.  List the identifiers and labels of all windows.  No
value is returned.
.TP
.B nline([nline])
Set the default buffer size to \fInline\fP.  Initially, it is
48 lines.  Returns the old default buffer size.  Default is
no change.  Using a very large buffer can slow the program down
considerably.
.TP
.B select([window])
Make \fIwindow\fP the current window.  The previous current window
is returned.  Default is no change.
.TP
.B shell([<string-list>])
Set the default window shell program to \fI<string-list>\fP.  Returns
the first string in the old shell setting.  Default is no change.  Initially,
the default shell is taken from the environment variable \fISHELL\fP.
.TP
.B source(filename)
Read and execute the long commands in \fIfilename\fP.  Returns
-1 if the file cannot be read, 0 otherwise.
.TP
.B terse([flag])
Set terse mode to \fIflag\fP.  In terse mode, the command window
stays hidden even in command mode, and errors are reported by
sounding the terminal's bell.  \fIFlag\fP can take on the same
values as in \fIforeground\fP above.  Returns the old terse flag.
Default is no change.
.TP
.B unalias(alias)
Undefine \fIalias\fP.  Returns -1 if \fIalias\fP does not exist,
0 otherwise.
.TP
.B unset(variable)
Undefine \fIvariable\fP.  Returns -1 if \fIvariable\fP does not exist,
0 otherwise.
.TP
.B variables()
No arguments.  List all variables.  No value is returned.
.TP
.B window([row], [column], [nrow], [ncol], [nline], [frame],
.B [pty], [mapnl], [shell])
.br
Open a window with upper left corner at \fIrow\fP, \fIcolumn\fP
and size \fInrow\fP, \fIncol\fP.  If \fInline\fP is specified,
then that many lines are allocated for the text buffer.  Otherwise,
the default buffer size is used.  Default values for
\fIrow\fP, \fIcolumn\fP, \fInrow\fP, and \fIncol\fP are, respectively,
the upper, left-most, lower, or right-most extremes of the
screen.  \fIFrame\fP, \fIpty\fP, and \fImapnl\fP are flag values
interpreted in the same way as the argument to \fIforeground\fP (see above);
they mean, respectively, put a frame around this window (default true),
allocate pseudo-terminal for this window rather than socketpair (default
true), and map new line characters in this window to carriage return
and line feed (default true if socketpair is used, false otherwise).
\fIShell\fP is a list of strings that will be used as the shell
program to place in the window (default is the program specified
by \fIshell\fP, see below).  The created window's identifier
is returned as a number.
.TP
.B write([window], [<string-list>])
Send the list of strings, \fI<string-list>\fP, to \fIwindow\fP, separated
by spaces but not terminated with a new line.  The strings are actually
given to the window as input.  No value is returned.  Default
is the current window.
.SH "PREDEFINED VARIABLES"
These variables are for information only.  Redefining them does
not affect the internal operation of \fIwindow\fP.
.TP
.B baud
The baud rate as a number between 50 and 38400.
.TP
.B modes
The display modes (reverse video, underline, blinking, graphics)
supported by the physical terminal.  The value of \fImodes\fP is
the bitwise or of some of the one bit values, \fIm_blk\fP, \fIm_grp\fP,
\fIm_rev\fP, and \fIm_ul\fP (see below).  These values are useful
in setting the window cursors' modes (see \fIcursormodes\fP above).
.TP
.B m_blk
The blinking mode bit.
.TP
.B m_grp
The graphics mode bit (not very useful).
.TP
.B m_rev
The reverse video mode bit.
.TP
.B m_ul
The underline mode bit.
.TP
.B ncol
The number of columns on the physical screen.
.TP
.B nrow
The number of rows on the physical screen.
.TP
.B term
The terminal type.  The standard name, found in the second name
field of the terminal's \fITERMCAP\fP entry, is used.
.SH FILES
.ta 15
~/.windowrc	startup command file.
.br
/dev/[pt]ty[pq]?	pseudo-terminal devices.
.SH DIAGNOSTICS
Should be self explanatory.
.SH BUGS
