.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)whereis.1	6.2 (Berkeley) 5/7/86
.\"
.TH WHEREIS 1 "May 7, 1986"
.UC
.SH NAME
whereis \- locate source, binary, and or manual for program
.SH SYNOPSIS
.B whereis
[
.B \-sbm
] [
.B \-u
] [
.B \-SBM
dir ...
.B \-f
] name ...
.SH DESCRIPTION
.I Whereis
locates source/binary and manuals sections for specified files.
The supplied names are first stripped of leading pathname components
and any (single) trailing extension of the form ``.ext'', e.g. ``.c''.
Prefixes of ``s.'' resulting from use of source code control are also
dealt with.
.I Whereis
then attempts to locate the desired program in a list of standard places.
If any of the
.B \-b,
.B \-s
or
.B \-m
flags are given then
.I whereis
searches only for binaries, sources or manual sections respectively
(or any two thereof).
The
.B \-u
flag may be used to search for unusual entries.
A file is said to be unusual if it does not have one entry of
each requested type.
Thus ``whereis -m -u *'' asks for those files in the current
directory which have no documentation.
.sp
Finally, the
.B \-B
.B \-M
and
.B \-S
flags may be used to change or otherwise limit the places where
.I whereis
searches.
The
.B \-f
file flags is used to terminate the last such directory list
and signal the start of file names.
.SH EXAMPLE
The following finds all the files in /usr/bin which are not documented
in /usr/man/man1 with source in /usr/src/cmd:
.IP
cd /usr/ucb
.br
whereis \-u \-M /usr/man/man1 \-S /usr/src/cmd \-f *
.SH FILES
/usr/src/*
.br
/usr/{doc,man}/*
.br
/lib, /etc, /usr/{lib,bin,ucb,old,new,local}
.SH BUGS
Since the program uses
.IR chdir (2)
to run faster, pathnames given with the
.B \-M
.B \-S
and
.B \-B
must be full; i.e. they must begin with a ``/''.
