.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)vgrind.1	6.2 (Berkeley) 5/5/86
.\"
.TH VGRIND 1 "May 5, 1986"
.UC 4
.SH NAME
vgrind \- grind nice listings of programs
.SH SYNOPSIS
.B vgrind
[
.B \-f
] [
.B \-
] [
.B \-t
] [
.B \-n
] [
.B \-x
] [
.B \-W
] [
.B \-sn
] [
.B \-h
header
] [
.B \-d
file
] [
.BI \-l language
]
name ...
.SH DESCRIPTION
.I Vgrind
formats the program sources which are arguments 
in a nice style using
.IR troff (1)
Comments are placed in italics, keywords in bold face,
and the name of the current function is listed down the margin of each
page as it is encountered.
.PP
.I Vgrind 
runs in two basic modes, filter mode or regular mode.  In filter mode 
.I vgrind
acts as a filter in a manner similar to
.IR tbl (1).
The standard input is passed directly to the standard output except
for lines bracketed by the 
.I troff-like
macros:
.IP .vS
- starts processing
.IP .vE
- ends processing
.LP
These lines are formatted as described above.  The output from this
filter can be passed to 
.I troff 
for output.  There need be no particular ordering with 
.IR eqn (1)
or
.IR tbl (1).
.PP
In regular mode 
.I vgrind
accepts input files, processes them, and passes them to 
.IR troff (1)
for output.  
.PP
In both modes 
.I vgrind
passes any lines beginning with a decimal point without conversion.
.PP
The options are:
.IP \fB\-f\fP
forces filter mode
.IP \fB\-\fP
forces input to be taken from standard input (default if
.B \fB\-f\fP
is specified )
.IP \fB\-t\fP
similar to the same option in
.I troff
causing formatted text to go to the standard output
.IP \fB\-n\fP
forces no keyword bolding
.IP \fB\-x\fP
outputs the index file in a ``pretty'' format. 
The index file itself is produced whenever 
.I vgrind
is run with a file called 
.I index
in the current directory.
The index of function
definitions can then be run off by giving 
.I vgrind 
the
.B \-x
option and the file
.I index
as argument.
.IP \fB\-W\fP
forces output to the (wide) Versatec printer rather than the (narrow)
Varian
.IP \fB\-s\fP
specifies a point size to use on output (exactly the same as the argument
of a .ps)
.IP \fB\-h\fP
specifies a particular header to put on every output page (default is
the file name)
.IP \fB\-d\fP
specifies an alternate language definitions
file (default is /usr/lib/vgrindefs)
.IP \fB\-l\fP
specifies the language to use.  Currently known are PASCAL
.RB ( \-lp ),
MODEL
.RB ( \-lm ), C
.RB ( \-lc
or the default), CSH
.RB ( \-lcsh ), 
SHELL
.RB ( \-lsh ),
RATFOR
.RB ( \-lr ),
MODULA2
.RB ( \-lmod2 ),
YACC
.RB ( \-lyacc ),
ISP
.RB ( \-lisp ),
and ICON
.RB ( \-lI ).
.SH FILES
.ta 2i
index	file where source for index is created
.br
/usr/lib/tmac/tmac.vgrind	macro package
.br
/usr/lib/vfontedpr		preprocessor
.br
/usr/lib/vgrindefs		language descriptions
.SH AUTHOR
Dave Presotto & William Joy
.SH SEE ALSO
vlp(1),
vtroff(1),
vgrindefs(5)
.SH BUGS
Vfontedpr assumes that a certain programming style is followed:
.PP
For 
.B C
\- function names can be preceded on a line only by spaces, tabs, or an
asterisk.  The parenthesized arguments must also be on the same line.
.PP
For
.B PASCAL
\- function names need to appear on the same line as the keywords
.I function
or
.I procedure.
.PP
For
.B MODEL
\- function names need to appear on the same line as the keywords
.I is
.I beginproc.
.PP
If these conventions are not followed, the indexing and marginal function
name comment mechanisms will fail.
.sp
More generally, arbitrary formatting styles for programs mostly look bad.
The use of spaces to align source code fails miserably; if you plan to
.I vgrind
your program you should use tabs.  This is somewhat inevitable since the
font used by
.I vgrind
is variable width.
.PP
The mechanism of ctags in recognizing functions should be used here.
.PP
Filter mode does not work in documents using the \-me or \-ms macros.
(So what use is it anyway?)
