.\" Copyright (c) 1985, 1987 Regents of the University of California.
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms are permitted
.\" provided that the above copyright notice and this paragraph are
.\" duplicated in all such forms and that any documentation,
.\" advertising materials, and other materials related to such
.\" distribution and use acknowledge that the software was developed
.\" by the University of California, Berkeley.  The name of the
.\" University may not be used to endorse or promote products derived
.\" from this software without specific prior written permission.
.\" THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
.\" IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
.\" WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
.\"
.\"	@(#)vacation.1	6.6 (Berkeley) 7/9/88
.\"
.TH VACATION 1 "July 9, 1988"
.UC 6
.SH NAME
vacation \- return ``I am not here'' indication
.SH SYNOPSIS
.B vacation
.B -i
.br
.B vacation
[
.B -a
alias ] login
.SH DESCRIPTION
\fIVacation\fP returns a message to the sender of a message telling
them that you are currently not reading your mail.  The intended use
is in a \fI.forward\fP file.  For example, your \fI.forward\fP file
might have:
.PP
.ti +5
\eeric, "|/usr/ucb/vacation -a allman eric"
.PP
which would send messages to you (assuming your login name was eric) and
reply to any messages for ``eric'' or ``allman''.
.PP
No message will be sent unless \fIlogin\fP or an \fIalias\fP supplied
using the \fB-a\fP option is a substring of either the ``To:'' or ``Cc:''
headers of the mail.  No messages from ``???-REQUEST'', ``Postmaster'',
``UUCP'', ``MAILER'', or ``MAILER-DAEMON'' will be replied to, nor is a
notification sent if a ``Precedence: bulk'' or ``Precedence: junk'' line
is included in the mail headers.  Only one message per week will be sent
to each unique sender.  The people who have sent you messages are
maintained as an \fIndbm\fP(3) database in the files \fI.vacation.pag\fP
and \fI.vacation.dir\fP in your home directory.
.PP
The \fB-i\fP flag initializes the vacation database files.  It should be
used before you modify your \fI.forward\fP file.
.PP
\fIVacation\fP expects a file \fI.vacation.msg\fP, in your home directory,
containing a message to be sent back to each sender.  It should be an entire
message (including headers).  For example, it might say:
.PP
.in +5
.nf
From: eric@ucbmonet.Berkeley.EDU (Eric Allman)
Subject: I am on vacation
Delivered-By-The-Graces-Of: The Vacation program
Precedence: bulk

I am on vacation until July 22.  If you have something urgent,
please contact Joe Kalash <kalash@ucbingres.Berkeley.EDU>.
	--eric
.fi
.in -5
.PP
\fIVacation\fP reads the first line from the standard input for
a \s-1UNIX\s0-style ``From'' line to determine the sender.
\fISendmail\fP(8) includes this ``From'' line automatically.
.PP
Fatal errors, such as calling \fIvacation\fP with incorrect arguments,
or with non-existent \fIlogin\fPs, are logged in the system log file,
using \fIsyslog\fP(8).
.SH FILES
.nf
.ta \w'~/.vacation.msg    'u
~/.vacation.dir	database file
~/.vacation.msg	message to send
~/.vacation.pag	database file
.fi
.SH "SEE ALSO"
sendmail(8), syslog(8)
