.\" Copyright (c) 1985 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)unifdef.1	6.1 (Berkeley) 4/29/85
.\"
.TH UNIFDEF 1 "April 29, 1985"
.UC 6
.SH NAME
unifdef \- remove ifdef'ed lines
.SH SYNOPSIS
.B unifdef
[
.B \-t
.B \-l
.B \-c
.BI \-D sym
.BI \-U sym
.BI \-id sym
.BI \-iu sym
] ...  [ file ]
.SH DESCRIPTION
.I Unifdef
is useful for removing ifdef'ed lines from a file while otherwise leaving the
file alone.
.I Unifdef
is like a stripped-down C preprocessor:
it is smart enough to deal with the nested ifdefs, comments,
single and double
quotes of C syntax so that it can do its job, but it doesn't do any including
or interpretation of macros.
Neither does it strip out comments, though it recognizes and ignores them.
You specify which symbols you want defined
.BI \-D sym
or undefined
.BI \-U sym
and the lines inside those ifdefs will be copied to the output or removed as
appropriate.
The ifdef, ifndef, else, and endif lines associated with
.I sym
will also be removed.
Ifdefs involving symbols you don't specify are untouched and copied out
along with their associated
ifdef, else, and endif lines.
If an ifdef X occurs nested inside another ifdef X, then the
inside ifdef is treated as if it were an unrecognized symbol.
If the same symbol appears in more than one argument, only the first
occurrence is significant.
.PP
The
.B \-l
option causes
.I unifdef
to replace removed lines with blank lines
instead of deleting them.
.PP
If you use ifdefs to delimit non-C lines, such as comments
or code which is under construction,
then you must tell
.I unifdef
which symbols are used for that purpose so that it won't try to parse
for quotes and comments
in those ifdef'ed lines.
You specify that you want the lines inside certain ifdefs to be ignored
but copied out with
.BI \-id sym
and
.BI \-iu sym
similar to
.BI \-D sym
and
.BI \-U sym
above.
.PP
If you want to use
.I unifdef
for plain text (not C code), use the
.B \-t
option.
This makes
.I unifdef
refrain from attempting to recognize comments and single and double quotes.
.PP
.I Unifdef
copies its output to
.I stdout
and will take its input from
.I stdin
if no
.I file
argument is given.
If the
.B \-c
argument is specified, then the operation of
.I unifdef
is complemented,
i.e. the lines that would have been removed or blanked
are retained and vice versa.
.SH "SEE ALSO"
diff(1)
.SH DIAGNOSTICS
Premature EOF, inappropriate else or endif.
.PP
Exit status is 0 if output is exact copy of input, 1 if not, 2 if trouble.
.SH BUGS
Does not know how to deal with \fIcpp\fP consructs such as
.br
.sp
.nf
	#if	defined(X) || defined(Y)
.sp
.fi
.SH AUTHOR
Dave Yost
