.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)ul.1	6.2 (Berkeley) 5/7/86
.\"
.TH UL 1 "May 7, 1986"
.UC 4
.SH NAME
ul \- do underlining
.SH SYNOPSIS
.B ul
[
.B \-i
] [
.B \-t
.I terminal
]
[
.I name
\&...
]
.SH DESCRIPTION
.I Ul
reads the named files (or standard input if none are given)
and translates occurrences of underscores to the sequence
which indicates underlining for the terminal in use, as specified
by the environment variable
TERM.
The
.B \-t
option overrides the terminal kind specified in the environment.
The file
.I /etc/termcap
is read to determine the appropriate sequences for underlining.
If the terminal is incapable of underlining, but is capable of
a standout mode then that is used instead.
If the terminal can overstrike,
or handles underlining automatically,
.I ul
degenerates to
.IR cat (1).
If the terminal cannot underline, underlining is ignored.
.PP
The
.B \-i
option causes
.I ul
to indicate underlining onto by a separate line containing appropriate
dashes `\-'; this is useful when you want to look at the underlining
which is present in an
.I nroff
output stream on a crt-terminal.
.SH "SEE ALSO"
man(1), nroff(1), colcrt(1)
.SH BUGS
.I Nroff
usually outputs a series of backspaces and underlines intermixed
with the text to indicate underlining.  No attempt is made to optimize
the backward motion.
