.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)tset.1	6.2 (Berkeley) 5/5/86
.\"
.TH TSET 1 "May 5, 1986"
.UC 4
.SH NAME
tset \- terminal dependent initialization
.SH SYNOPSIS
.B tset
[ options ] [
.B \-m
[ident][test baudrate]:type ] \&... [ type ]
.sp 1
.B reset
[ options ] [
.B \-m
[ident][test baudrate]:type ] \&... [ type ]
.SH DESCRIPTION
.I Tset
sets up your terminal when you first log in to a UNIX system.
It does terminal dependent processing such as setting
erase and kill characters, setting or resetting delays,
sending any sequences needed to properly initialized the terminal,
and the like.
It first determines the
.I type
of terminal involved,
and then does necessary initializations and mode settings.
The type of terminal attached to each \s-2UNIX\s0 port is specified in the
.IR /etc/ttys (5)
database.
Type names for terminals may be found in the
.IR termcap (5)
database.
If a port is not wired permanently to a specific terminal (not hardwired)
it will be given an appropriate generic identifier such as
.IR dialup .
.PP
In the case where no arguments are specified,
.I tset
simply reads the terminal type out of the environment variable TERM
and re-initializes the terminal.  The rest of this manual concerns
itself with mode and environment initialization,
typically done once at login, and options
used at initialization time to determine the terminal type and set up
terminal modes.
.PP
When used in a startup script (\fI\&.profile\fR for
.IR sh (1)
users or
.I \&.login
for
.IR csh (1)
users) it is desirable to give information about the type of terminal
you will usually use on ports which are not hardwired.
These ports are identified in
.I /etc/ttys
as
.I dialup
or
.I plugboard
or
.I arpanet,
etc.
To specify
what terminal type you usually use on these ports, the
.B \-m
(map) option flag is followed by the appropriate port type identifier,
an optional baud rate specification,
and the terminal type.
(The effect is to ``map'' from some conditions to a terminal type,
that is, to tell
.I tset
``If I'm on this kind of port, guess that I'm on that kind of terminal''.)
If more than one mapping is specified, the first applicable mapping prevails.
A missing port type identifier matches all identifiers.
Any of the alternate generic names given in
.I termcap
may be used for the identifier.
.PP
A
.I baudrate
is specified as with
.IR stty (1),
and is compared with the
speed of the diagnostic output (which should be the control terminal).
The baud rate
.I test
may be any combination of:
.BR > ,
.BR @ ,
.BR < ,
and
.BR ! ;
.B @
means ``at''
and
.B !
inverts the sense of the test.  To avoid problems with metacharacters, it
is best to place the entire argument to
.B \-m
within ``\''' characters; users of
.IR csh (1)
must also put a ``\e'' before any ``!'' used here.
.PP
.KS
Thus
.IP
tset \-m \'dialup>300:adm3a\' -m dialup:dw2 -m \'plugboard:?adm3a\'
.KE
.LP
causes the terminal type to be set to an
.I adm3a
if the port in use is a dialup at a speed greater than 300 baud;
to a 
.I dw2
if the port is (otherwise) a dialup (i.e. at 300 baud or less).
(\fBNOTE:\fP the examples given here appear to take up more than
one line, for text processing reasons.  When you type in real
.I tset
commands, you must enter them entirely on one line.)
If the
.I type
finally determined by
.I tset
begins with a question mark,
the user is asked if s/he really wants that type.
A null response means to use that type;
otherwise, another type can be entered which will be used instead.
Thus, in the above case, the user will be queried on a plugboard port
as to whether they are actually using an
.IR adm3a .
.PP
If no mapping applies and a final
.I type
option, not preceded by a
.BR \-m ,
is given on the command line
then that type is used;
otherwise the type found in the
.I /etc/ttys
database will be taken to be the terminal type.
This should always be the case for hardwired ports.
.PP
It is usually desirable to return the terminal type, as finally determined by
.IR tset ,
and information about the terminal's capabilities
to a shell's environment.  This can be done using the
.B \-
option; using the Bourne shell,
.IR sh (1):
.IP
export TERM; TERM=\`tset \- \fIoptions...\fR\`
.LP
or using the C shell,
.IR csh (1):
.IP
setenv TERM \`tset - \fIoptions...\fR\`
.PP
With
.I csh
it is preferable to use the following command in your .login file to
initialize the TERM and TERMCAP environment variables at the same time.
.IP
eval \`tset -s \fIoptions...\fR\`
.PP
It is also convenient to make an alias in your .cshrc:
.IP
alias tset \'eval \`tset \-s \e!*\`\'
.PP
This allows the command:
.IP
tset 2621
.PP
to be invoked at any time to set the terminal and environment.
.B "Note to Bourne Shell users:"
It is
.B not
possible to get this aliasing effect with a shell script,
because shell scripts cannot set the environment of their parent.
(If a process could set its parent's environment,
none of this nonsense would be necessary in the first place.)
.PP
These commands cause
.I tset
to place the name of your terminal in the variable
TERM in the environment; see
.IR environ (7).
.PP
Once the terminal type is known,
.I tset
engages in terminal driver mode setting.
This normally involves sending an initialization sequence to the
terminal, setting the single character erase (and optionally
the line-kill (full line erase)) characters,
and setting special character delays.
Tab and newline expansion are turned off during transmission of
the terminal initialization sequence.
.PP
On terminals that can backspace but not overstrike
(such as a \s-2CRT\s0),
and when the erase character is the default erase character
(`#' on standard systems),
the erase character is changed to \s-2BACKSPACE\s0 (Control-H).
.PP
The options are:
.TP
.B \-e\fIc
set the erase character to be the named character
.I c
on all terminals,
the default being the backspace character on the terminal, usually ^H.
The character
.I c
can either be typed directly, or entered using the hat
notation used here.
.TP
.B \-k\fIc
is similar to
.B \-e
but for the line kill character rather than the erase character;
.I c
defaults to ^X (for purely historical reasons).
The kill characters is left alone if
.B \-k
is not specified.
The hat notation can also be used for this option.
.TP
.B \-i\fIc
is similar to
.B \-e
but for the interrupt character rather than the erase character;
.I c
defaults to ^C.  The hat notation can also be used for this option.
.TP
.B \-
The name of the terminal finally decided upon is output on the
standard output.
This is intended to be captured by the shell and placed in the
environment variable TERM.
.TP
.B \-s
Print the sequence of
.I csh
commands to initialize the environment variables TERM and TERMCAP based on
the name of the terminal finally decided upon.
.TP
.B \-n
On systems with the Berkeley 4BSD tty driver,
specifies that the new tty driver modes should be initialized for this terminal.
For a \s-2CRT\s0,
the CRTERASE and CRTKILL
modes are set only if the baud rate is 1200 or greater.
See tty(4) for more detail.
.TP
.B \-I
suppresses transmitting terminal initialization strings.
.TP
.B \-Q
suppresses printing the
``Erase set to'' and ``Kill set to'' messages.
.PP
If
.B tset
is invoked as
.BR reset ,
it will set cooked and echo modes, turn off cbreak and raw modes,
turn on newline translation, and restore special characters
to a sensible state before any terminal dependent processing is done.
Any special character that is found to be \s-2NULL\s0
or ``\-1'' is reset to its default value.  All arguments to
.I tset
may be used with reset.
.PP
This is most useful after a program dies leaving a terminal in a funny
state. You may have to type ``\s-2<LF>\s0reset\s-2<LF>\s0'' to get it to work
since \s-2<CR>\s0 may not work in this state. Often none of this will echo.
.SH EXAMPLES
.PP
These examples all assume the Bourne shell and use the - option.
If you use
.IR csh ,
use one of the variations described above.
Note that a typical use of
.I tset
in a .profile or .login will also use the
.B \-e
and
.B \-k
options, and often the
.B \-n
or
.B \-Q
options as well.
These options have not been included here to keep the examples small.
(\fBNOTE:\fP some of the examples given here appear to take up more than
one line, for text processing reasons.  When you type in real
.I tset
commands, you must enter them entirely on one line.)
.PP
At the moment, you are on a 2621.
This is suitable for typing by hand but
not for a .profile, unless you are
.I always
on a 2621.
.IP
export TERM; TERM=\`tset \- 2621\`
.PP
You have an h19 at home which you dial up on, but your office terminal
is hardwired and known in /etc/ttys.
.IP
export TERM; TERM=\`tset \- \-m dialup:h19\`
.PP
You have a switch which connects everything to everything, making
it nearly impossible to key on what port you are coming in on.
You use a vt100 in your office at 9600 baud, and dial up to switch
ports at 1200 baud from home on a 2621.
Sometimes you use someone elses terminal at work,
so you want it to ask you to make sure what terminal
type you have at high speeds, but at 1200 baud you are
always on a 2621.
Note the placement of the question mark, and the quotes
to protect the greater than and question mark from
interpretation by the shell.
.IP
export TERM; TERM=\`tset \- \-m 'switch>1200:?vt100' \-m 'switch<=1200:2621'
.PP
All of the above entries will fall back on the terminal type
specified in
.I /etc/ttys
if none of the conditions hold.
The following entry is appropriate if
you always dial up, always at the same baud rate,
on many different kinds of terminals.
Your most common terminal is an adm3a.
It always asks you what kind of terminal you are on,
defaulting to adm3a.
.IP
export TERM; TERM=\`tset \- \?adm3a\`
.PP
If the file
.I /etc/ttys
is not properly installed and you want to
key entirely on the baud rate, the following can be used:
.IP
export TERM; TERM=\`tset \- \-m '>1200:vt100' 2621\`
.PP
Here is a fancy example to illustrate the power of
.I tset
and to hopelessly confuse anyone who has made it this far.
You dial up at 1200 baud or less on a concept100,
sometimes over switch ports and sometimes over regular dialups.
You use various terminals at speeds higher than 1200 over switch ports,
most often the terminal in your office, which is a vt100.
However, sometimes you log in from the university you used to go to,
over the ARPANET; in this case you are on an ALTO emulating a dm2500.
You also often log in on various hardwired ports, such as the console,
all of which are properly entered in
.IR /etc/ttys .
You want your erase character set to control H,
your kill character set to control U,
and don't want
.I tset
to print the ``Erase set to Backspace, Kill set to Control U'' message.
.IP
export TERM; TERM=\`tset \-e \-k^U \-Q \- \-m 'switch<=1200:concept100' \-m 'switch:?vt100' \-m dialup:concept100 \-m arpanet:dm2500\`
.SH FILES
.DT
/etc/ttys	port name to terminal type mapping database
.br
/etc/termcap	terminal capability database
.SH SEE\ ALSO
csh(1), sh(1), stty(1), ttys(5), termcap(5), environ(7)
.SH BUGS
.PP
The
.I tset
command is one of the first commands a user must master when getting
started on a UNIX system.
Unfortunately, it is one of the most complex,
largely because of the extra effort the user must go through
to get the environment of the login shell set.
Something needs to be done to make all this simpler,
either the
.IR login (1)
program should do this stuff,
or a default shell alias should be made,
or a way to set the environment of the parent should exist.
.PP
This program can't intuit personal choices for erase, interrupt
and line kill characters, so it leaves these set to the local system
standards.
.ig
.SH NOTES
For compatibility with earlier versions of
.I tset
a number of flags are accepted whose use is discouraged:
.TP 10
\fB\-d\fR type
equivalent to
.B \-m
dialup:type
.TP 10
\fB\-p\fR type
equivalent to
.B \-m
plugboard:type
.TP 10
\fB\-a\fR type
equivalent to
.B \-m
arpanet:type
.TP 10
\fB\-E\fR c
Sets the erase character to
.I c
only if the terminal can backspace.
.TP 10
\fB\-\fR
prints the terminal type on the standard output
.TP 10
\fB\-r\fR
prints the terminal type on the diagnostic output.
..
