.\" Copyright (c) 1986 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)mset.1	1.3 (Berkeley) 1/11/86
.\"
.TH MSET 1 "January 11, 1986"
.UC 6
.SH NAME
mset \- retrieve ASCII to IBM 3270 keyboard map
.SH SYNOPSIS
.B mset
.SH DESCRIPTION
.I Mset
retrieves mapping information
for the ASCII keyboard to IBM 3270 terminal
special functions.
Normally, these mappings are found
in
.I /etc/map3270
(see
.IR map3270 (5)).
This information is used by the
.I tn3270
command (see
.IR tn3270 (1)).
.PP
.I Mset
can be used store the mapping information in the process environment
in order to avoid scanning
.I /etc/map3270
each time
.I tn3270
is invoked.
To do this, place the following command in your
.I .login
file:
.ti 5n
.sp
     set noglob; setenv \s-1MAP3270\s0 "\(gamset\(ga"; unset noglob
.PP
.I Mset
first determines the user's terminal type from the environment variable
.BR TERM .
Normally
.I mset
then uses the file
.I /etc/map3270
to find the keyboard mapping for that terminal.
However, if the environment variable
.B MAP3270
exists and contains the entry for the specified terminal, then that
definition is used.
If the value of
.B MAP3270
begins with a slash (`/') then it is assumed to be the full pathname
of an alternate mapping file and that file is searched first.
In any case, if the mapping for the terminal is not found in
the environment, nor in an alternate map file, nor in the standard map file,
then the same search is performed for an entry for a terminal type of
.B unknown.
If that search also fails,
then a default mapping
is used.
.SH FILES
/etc/map3270        keyboard mapping for known terminals
.SH SEE ALSO
tn3270(1), map3270(5)
.SH BUGS
If the entry for the specific terminal
exceeds 1024 bytes, \fIcsh\fR(1) will fail
to set the environment variable.
.I Mset
should probably
detect this case and
output the path to the
.I map3270
file
instead of the terminal entry.
