.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)telnet.1c	6.5 (Berkeley) 5/10/86
.\"
.TH TELNET 1C "May 10, 1986"
.UC 5
.SH NAME
telnet \- user interface to the \s-1TELNET\s0 protocol
.SH SYNOPSIS
telnet [ host [ port ] ]
.SH DESCRIPTION
.I Telnet
is used to communicate with another host using the
.B TELNET
protocol.
If 
.I telnet
is invoked without arguments, it enters command mode,
indicated by its prompt (\*(lqtelnet>\*(rq).
In this mode, it accepts and executes the commands listed below.
If it is invoked with arguments, it performs an
.B open
command (see below) with those arguments.
.PP
Once a connection has been opened,
.I telnet
enters an input mode.
The input mode entered will be either \*(lqcharacter at a time\*(rq
or \*(lqline by line\*(rq
depending on what the remote system supports.
.PP
In \*(lqcharacter at a time\*(rq mode, most
text typed is immediately sent to the remote host for processing.
.PP
In \*(lqline by line\*(rq mode, all text is echoed locally,
and (normally) only completed lines are sent to the remote host.
The \*(lqlocal echo character\*(rq (initially \*(lq^E\*(rq) may be used
to turn off and on the local echo
(this would mostly be used to enter passwords
without the password being echoed).
.PP
In either mode, if the
.I localchars
toggle is TRUE (the default in line mode; see below),
the user's
.IR quit ,
.IR intr ,
and
.I flush
characters are trapped locally, and sent as
.B TELNET
protocol sequences to the remote side.
There are options (see
.B toggle
.I autoflush
and
.B toggle
.I autosynch
below)
which cause this action to flush subsequent output to the terminal
(until the remote host acknowledges the
.B TELNET
sequence) and flush previous terminal input
(in the case of
.I quit
and
.IR intr ).
.PP
While connected to a remote host,
.I telnet
command mode may be entered by typing the
.I telnet
\*(lqescape character\*(rq (initially \*(lq^]\*(rq).
When in command mode, the normal terminal editing conventions are available.
.PP
.B COMMANDS
.PP
The following commands are available.
Only enough of each command to uniquely identify it need be typed
(this is also true for arguments to the
.BR mode ,
.BR set ,
.BR toggle ,
and
.B display
commands).
.PP
.TP
.B open \fIhost\fP \fR[\fP \fIport\fP \fR]\fP
.br
Open a connection to the named host.
If no port number
is specified, 
.I telnet
will attempt to contact a
.B TELNET
server at the default port.
The host specification may be either a host name (see 
.IR hosts (5))
or an Internet address specified in the \*(lqdot notation\*(rq (see
.IR inet (3N)).
.TP
.B close
.br
Close a
.B TELNET
session and return to command mode.
.TP
.B quit
.br
Close any open
.B TELNET
session and exit 
.IR telnet .
An end of file (in command mode) will also close a session and exit.
.TP
.B z
.br
Suspend
.IR telnet .
This command only works when the user is using the 
.IR csh (1).
.TP
.B mode \fItype\fP
.br
.I Type
is either
.I line
(for \*(lqline by line\*(rq mode)
or
.I character
(for \*(lqcharacter at a time\*(rq mode).
The remote host is asked for permission to go into the requested mode.
If the remote host is capable of entering that mode, the requested
mode will be entered.
.TP
.B status
.br
Show the current status of 
.IR telnet .
This includes the peer one is connected to, as well
as the current mode.
.TP
.B display \fR[\fP \fIargument...\fP \fR]\fP
.br
Displays all, or some, of the
.B set
and
.B toggle
values (see below).
.TP
.B ? \fR[\fP \fIcommand\fP \fR]\fP
.br
Get help.  With no arguments,
.I telnet
prints a help summary.
If a command is specified, 
.I telnet
will print the help information for just that command.
.TP
.B send \fIarguments\fP
.br
Sends one or more special character sequences to the remote host.
The following are the arguments which may be specified
(more than one argument may be specified at a time):
.RS
.TP
.I escape
.br
Sends the current
.I telnet
escape character (initially \*(lq^]\*(rq).
.TP
.I synch
.br
Sends the
.B TELNET SYNCH
sequence.
This sequence causes the remote system to discard all previously typed
(but not yet read) input.
This sequence is sent as TCP urgent
data (and may not work if the remote system is a 4.2 BSD system -- if
it doesn't work, a lower case \*(lqr\*(rq may be echoed on the terminal).
.TP
.I brk
.br
Sends the
.B TELNET BRK
(Break) sequence, which may have significance to the remote
system.
.TP
.I ip
.br
Sends the
.B TELNET IP
(Interrupt Process) sequence, which should cause the remote
system to abort the currently running process.
.TP
.I ao
.br
Sends the
.B TELNET AO
(Abort Output) sequence, which should cause the remote system to flush
all output
.B from
the remote system
.B to
the user's terminal.
.TP
.I ayt
.br
Sends the
.B TELNET AYT
(Are You There)
sequence, to which the remote system may or may not choose to respond.
.TP
.I ec
.br
Sends the
.B TELNET EC
(Erase Character)
sequence, which should cause the remote system to erase the last character
entered.
.TP
.I el
.br
Sends the
.B TELNET EL
(Erase Line)
sequence, which should cause the remote system to erase the line currently
being entered.
.TP
.I ga
.br
Sends the
.B TELNET GA
(Go Ahead)
sequence, which likely has no significance to the remote system.
.TP
.I nop
.br
Sends the
.B TELNET NOP
(No OPeration)
sequence.
.TP
.I ?
.br
Prints out help information for the
.B send
command.
.RE
.TP
.B set \fIargument value\fP
.br
Set any one of a number of
.I telnet
variables to a specific value.
The special value \*(lqoff\*(rq turns off the function associated with
the variable.
The values of variables may be interrogated with the
.B display
command.
The variables which may be specified are:
.RS
.TP
.I echo
.br
This is the value (initially \*(lq^E\*(rq) which, when in
\*(lqline by line\*(rq mode, toggles between doing local echoing
of entered characters (for normal processing), and suppressing
echoing of entered characters (for entering, say, a password).
.TP
.I escape
.br
This is the
.I telnet
escape character (initially \*(lq^[\*(rq) which causes entry
into
.I telnet
command mode (when connected to a remote system).
.TP
.I interrupt
.br
If
.I telnet
is in
.I localchars
mode (see
.B toggle
.I localchars
below)
and the
.I interrupt
character is typed, a
.B TELNET IP
sequence (see
.B send
.I ip
above)
is sent to the remote host.
The initial value for the interrupt character is taken to be
the terminal's
.B intr
character.
.TP
.I quit
.br
If
.I telnet
is in
.I localchars
mode (see
.B toggle
.I localchars
below)
and the
.I quit
character is typed, a
.B TELNET BRK
sequence (see
.B send
.I brk
above)
is sent to the remote host.
The initial value for the quit character is taken to be
the terminal's
.B quit
character.
.TP
.I flushoutput
.br
If
.I telnet
is in
.I localchars
mode (see
.B toggle
.I localchars
below)
and the
.I flushoutput
character is typed, a
.B TELNET AO
sequence (see
.B send
.I ao
above)
is sent to the remote host.
The initial value for the flush character is taken to be
the terminal's
.B flush
character.
.TP
.I erase
.br
If
.I telnet
is in
.I localchars
mode (see
.B toggle
.I localchars
below),
.B and
if
.I telnet
is operating in \*(lqcharacter at a time\*(rq mode, then when this
character is typed, a
.B TELNET EC
sequence (see
.B send
.I ec
above)
is sent to the remote system.
The initial value for the erase character is taken to be
the terminal's
.B erase
character.
.TP
.I kill
.br
If
.I telnet
is in
.I localchars
mode (see
.B toggle
.I localchars
below),
.B and
if
.I telnet
is operating in \*(lqcharacter at a time\*(rq mode, then when this
character is typed, a
.B TELNET EL
sequence (see
.B send
.I el
above)
is sent to the remote system.
The initial value for the kill character is taken to be
the terminal's
.B kill
character.
.TP
.I eof
.br
If
.I telnet
is operating in \*(lqline by line\*(rq mode, entering this character
as the first character on a line will cause this character to be
sent to the remote system.
The initial value of the eof character is taken to be the terminal's
.B eof
character.
.RE
.TP
.B toggle \fIarguments...\fP
.br
Toggle (between
TRUE
and
FALSE)
various flags that control how
.I telnet
responds to events.
More than one argument may be specified.
The state of these flags may be interrogated with the
.B display
command.
Valid arguments are:
.RS
.TP
.I localchars
.br
If this is
TRUE,
then the
.IR flush ,
.IR interrupt ,
.IR quit ,
.IR erase ,
and
.I kill
characters (see
.B set
above) are recognized locally, and transformed into (hopefully) appropriate
.B TELNET
control sequences
(respectively
.IR ao ,
.IR ip ,
.IR brk ,
.IR ec ,
and
.IR el ;
see
.B send
above).
The initial value for this toggle is TRUE in \*(lqline by line\*(rq mode,
and FALSE in \*(lqcharacter at a time\*(rq mode.
.TP
.I autoflush
.br
If
.I autoflush
and
.I localchars
are both
TRUE,
then when the
.IR ao ,
.IR intr ,
or
.I quit
characters are recognized (and transformed into
.B TELNET
sequences; see
.B set
above for details),
.I telnet
refuses to display any data on the user's terminal
until the remote system acknowledges (via a
.B TELNET
.I Timing Mark
option)
that it has processed those
.B TELNET
sequences.
The initial value for this toggle is TRUE if the terminal user had not
done an "stty noflsh", otherwise FALSE (see
.IR stty(1)).
.TP
.I autosynch
If
.I autosynch
and
.I localchars
are both
TRUE,
then when either the
.I intr
or
.I quit
characters is typed (see
.B set
above for descriptions of the
.I intr
and
.I quit
characters), the resulting
.B TELNET
sequence sent is followed by the
.B TELNET SYNCH
sequence.
This procedure
.B should
cause the remote system to begin throwing away all previously
typed input until both of the
.B TELNET
sequences have been read and acted upon.
The initial value of this toggle is FALSE.
.TP
.I crmod
.br
Toggle carriage return mode.
When this mode is enabled, most carriage return characters received from
the remote host will be mapped into a carriage return followed by
a line feed.
This mode does not affect those characters typed by the user, only
those received from the remote host.
This mode is not very useful unless the remote host
only sends carriage return, but never line feed.
The initial value for this toggle is FALSE.
.TP
.I debug
.br
Toggles socket level debugging (useful only to the
.IR super user ).
The initial value for this toggle is FALSE.
.TP
.I options
.br
Toggles the display of some internal
.I telnet
protocol processing (having to do with
.B TELNET
options).
The initial value for this toggle is FALSE.
.TP
.I netdata
.br
Toggles the display of all network data (in hexadecimal format).
The initial value for this toggle is FALSE.
.TP
.I ?
.br
Displays the legal
.B toggle
commands.
.RE
.SH BUGS
.PP
There is no adequate way for dealing with flow control.
.PP
On some remote systems, echo has to be turned off manually when in
\*(lqline by line\*(rq mode.
.PP
There is enough settable state to justify a
.RI . telnetrc
file.
.PP
No capability for a
.RI . telnetrc
file is provided.
.PP
In \*(lqline by line\*(rq mode, the terminal's
.I eof
character is only recognized (and sent to the remote system)
when it is the first character on a line.
