.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)tail.1	6.3 (Berkeley) 9/29/87
.\"
.TH TAIL 1 "September 29, 1987"
.UC 4
.SH NAME
tail \- deliver the last part of a file
.SH SYNOPSIS
.B tail
[\fB+-\fP]\fBnumber\fP[\fBlbc\fP][\fBrf\fP] [\fBfile\fP]
.SH DESCRIPTION
.I Tail
copies the named file to the standard output beginning
at a designated place.
If no file is named, the standard input is used.
.PP
Copying begins at distance
.I +number
from the beginning, or
.I \-number
from the end of the input.
.I Number
is counted in units of lines, blocks or characters,
according to the appended option
.B l,
.B b
or
.B c.
When no units are specified, counting is by lines.
.PP
Specifying
.B r
causes tail to print lines from the end of the file in reverse order.
The default for
.B r
is to print the entire file this way.
Specifying
.B f
causes
.I tail
to not quit at end of file, but rather wait and try to read repeatedly
in hopes that the file will grow.
.SH "SEE ALSO"
dd(1)
.SH BUGS
Tails relative to the end of the file
are treasured up in a buffer, and thus 
are limited in length.
.PP
Various kinds of anomalous behavior may happen
with character special files.
