.\" Copyright (c) 1985 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)systat.1	6.6 (Berkeley) 10/3/87
.\"
.TH SYSTAT 1 "October 3, 1987"
.UC 6
.SH NAME
systat \- display system statistics on a crt
.SH SYNOPSIS
.B systat
[
.RI \- display
] [
refresh-interval
]
.SH DESCRIPTION
.B Systat
displays various system statistics in a screen oriented fashion
using the curses screen display library, 
.IR curses (3X).
.PP
While
.I systat
is running the screen is usually divided into two windows (an exception
is the vmstat display which uses the entire screen).  The
upper window depicts the current system load average.  The
information displayed in the lower window may vary, depending on
user commands.  The last line on the screen is reserved for user
input and error messages.
.PP
By default
.I systat
displays the processes getting the largest percentage of the processor
in the lower window.  Other displays show swap space usage, disk i/o
statistics (a la
.IR iostat (1)),
virtual memory statistics (a la
.IR vmstat (1)),
network ``mbuf'' utilization, and network connections (a la
.IR netstat (1)).
.PP
Input is interpreted at two different levels. 
A ``global'' command interpreter processes all keyboard input.
If this command interpreter fails to recognize a command, the
input line is passed to a per-display command interpreter.  This
allows each display to have certain display-specific commands.
.PP
Certain characters cause immediate action by 
.IR systat .
These are
.IP ^L
Refresh the screen.
.IP ^G
Print the name of the current ``display'' being shown in
the lower window and the refresh interval.
.IP ^Z
Stop 
.IR systat .
.IP :
Move the cursor to the command line and interpret the input
line typed as a command.  While entering a command the
current character erase, word erase, and line kill characters
may be used.
.PP
The following commands are interpreted by the ``global''
command interpreter.
.IP help
.br
Print the names of the available displays on the command line.
.IP load
.br
Print the load average over the past 1, 5, and 15 minutes
on the command line.
.IP stop
.br
Stop refreshing the screen.
.IP "[ start ] [ number ]"
.br
Start (continue) refreshing the screen.  If a second, numeric,
argument is provided it is interpreted as a refresh interval
(in seconds).
Supplying only a number will set the refresh interval to this
value.
.IP "quit"
.br
Exit 
.IR systat .
(This may be abbreviated to
.IR q .)
.PP
The available displays are:
.IP pigs
.br
Display, in the lower window, those processes resident in main
memory and getting the
largest portion of the processor (the default display). 
When less than 100% of the
processor is scheduled to user processes, the remaining time
is accounted to the ``idle'' process.
.IP iostat
.br
Display, in the lower window, statistics about processor use
and disk throughput.  Statistics on processor use appear as
bar graphs of the amount of time executing in user mode (``user''),
in user mode running low priority processes (``nice''), in 
system mode (``system''), and idle (``idle'').  Statistics
on disk throughput show, for each drive, kilobytes of data transferred,
number of disk transactions performed, and average seek time
(in milliseconds).  This information may be displayed as
bar graphs or as rows of numbers which scroll downward.  Bar
graphs are shown by default; commands specific to this display  
are discussed below.
.IP swap
.br
Display, in the lower window, swap space in use on each swap
device configured.  Two sets of bar graphs are shown.  The
upper graph displays swap space allocated to pure text segments
(code), the lower graph displays space allocated to stack and
data segments.  Allocated space is sorted by its size into buckets
of size dmmin, dmmin*2, dmmin*4, up to dmmax (to reflect allocation
policies imposed by the system).  The disk segment size, in sectors,
is displayed along the left hand side of the text,
and data and stack graphs.
Space allocated to the user structure and page
tables is not currently accounted for.
.IP mbufs
.br
Display, in the lower window, the number of mbufs allocated
for particular uses, i.e. data, socket structures, etc.
.IP vmstat
.br
Take over the entire display and show a (rather crowded) compendium
of statistics related to virtual memory usage, process scheduling,
device interrupts, system name translation cacheing, disk i/o, etc.
.IP
The upper left quadrant of the screen shows the number
of users logged in and the load average over the last one, five,
and fifteen minute intervals.
Below this line are statistics on memory utilization.
The first row of the table reports memory usage only among
active processes, that is processes that have run in the previous 
twenty seconds.
The second row reports on memory usage of all processes.
The first column reports on the number of physical pages
claimed by processes.
The second column reports the number of physical pages that
are devoted to read only text pages.
The third and fourth columns report the same two figures for
virtual pages, that is the number of pages that would be
needed if all processes had all of their pages.
Finally the last column shows the number of physical pages
on the free list.
.IP
Below the memory display is the disk usage display.
It reports the number of seeks, transfers, and number
of kilobyte blocks transferred per second averaged over the
refresh period of the display (by default, five seconds).
For some disks it also reports the average milliseconds per seek.
Note that the system only keeps statistics on at most four disks.
.IP
Below the disk display is a list of the
average number of processes (over the last refresh interval)
that are runnable (`r'), in page wait (`p'),
in disk wait other than paging (`d'),
sleeping (`s'), and swapped out but desiring to run (`w').
Below the queue length listing is a numerical listing and
a bar graph showing the amount of
system (shown as `='), user (shown as `>'),
nice (shown as `-'), and idle time (shown as ` ').
.IP
At the bottom left are statistics on name translations.
It lists the number of names translated in the previous interval,
the number and percentage of the translations that were
handled by the system wide name translation cache, and
the number and percentage of the translations that were
handled by the per process name translation cache.
.IP
Under the date in the upper right hand quadrant are statistics
on paging and swapping activity.
The first two columns report the average number of pages
brought in and out per second over the last refresh interval
due to page faults and the paging daemon.
The third and fourth columns report the average number of pages
brought in and out per second over the last refresh interval
due to swap requests initiated by the scheduler.
The first row of the display shows the average
number of disk transfers per second over the last refresh interval;
the second row of the display shows the average
number of pages transferred per second over the last refresh interval.
.IP
Below the paging statistics is a line listing the average number of
total reclaims ('Rec'),
intransit blocking page faults (`It'),
swap text pages found in free list (`F/S'),
file system text pages found in free list (`F/F'),
reclaims from free list (`RFL'),
pages freed by the clock daemon (`Fre'),
and sequential process pages freed (`SFr') 
per second over the refresh interval.
.IP
Below this line are statistics on the average number of
zero filled pages (`zf') and demand filled text pages (`xf')
per second over the refresh period.
The first row indicates the number of requests that were
resolved, the second row shows the number that were set up,
and the last row shows the percentage of setup requests were
actually used.
Note that this percentage is usually less than 100%,
however it may exceed 100% if a large number of requests
are actually used long after they were set up during a
period when no new pages are being set up. 
Thus this figure is most interesting when observed over
a long time period, such as from boot time
(see below on getting such a display).
.IP
Below the page fill statistics is a column that
lists the average number of context switches (`Csw'),
traps (`Trp'; includes page faults), system calls (`Sys'), interrupts (`Int'),
characters output to DZ ports using pseudo-DMA (`Pdm'),
network software interrupts (`Sof'),
page faults (`Flt'), pages scanned by the page daemon (`Scn'),
and revolutions of the page daemon's hand (`Rev')
per second over the refresh interval.
.IP
Running down the right hand side of the display is a breakdown
of the interrupts being handled by the system.
At the top of the list is the total interrupts per second
over the time interval.
The rest of the column breaks down the total on a device
by device basis. 
Only devices that have interrupted at least once since boot time are shown.
.IP netstat
.br
Display, in the lower window, network connections.  By default,
network servers awaiting requests are not displayed.  Each address
is displayed in the format ``host.port'', with each shown symbolically,
when possible.  It is possible to have addresses displayed numerically,
limit the display to a set of ports, hosts, and/or protocols; see the
list of commands below.
.PP
Commands to switch between displays may be abbreviated to the
minimum unambiguous prefix; for example, ``io'' for ``iostat''.
Certain information may be discarded when the screen size is
insufficient for display.  For example, on a machine with 10
drives the 
.I iostat
bar graph displays only 3 drives on a 24 line terminal.  When
a bar graph would overflow the allotted screen space it is
truncated and the actual value is printed ``over top'' of the bar.
.PP
The following commands are specific to the 
.I iostat
display; the minimum unambiguous prefix may be supplied.
.IP numbers
Show the disk i/o statistics in numeric form.  Values are
displayed in numeric columns which scroll downward.
.IP bars
Show the disk i/o statistics in bar graph form (default).
.IP msps
Toggle the display of average seek time (the default is to
not display seek times).
.PP
The following commands are specific to the
.I vmstat
display; the minimum unambiguous prefix may be supplied.
.IP boot
Display cumulative statistics since the system was booted.
.IP run
Display statistics as a running total from the point this
command is given.
.IP time
Display statistics averaged over the refresh interval (the default).
.IP zero
Reset running statistics to zero.
.PP
The following commands are common to each display which shows
information about disk drives.  These commands are used to
select a set of drives to report on, should your system have
more drives configured than can normally be displayed on the
screen.
.IP "ignore [ drives ]"
Do not display information about the drives indicated.  Multiple
drives may be specified, separated by spaces.
.IP "display [ drives ]"
Display information about the drives indicated.  Multiple drives
may be specified, separated by spaces.
.PP
The following command is specific to the
.I netstat
display; the minimum unambiguous prefix may be supplied.
.IP all
Toggle the displaying of server processes awaiting requests (this
is the equivalent of the 
.B \-a
flag to
.IR netstat (1)).
.IP numbers
Display network addresses numerically.
.IP names
Display network addresses symbolically.
.PP
The remaining commands are common to displays which report
network connections (currently only the
.I netstat
display).   These commands may be used to select a specific set
of connections for
.I systat
to report on.
.IP "\fIprotocol\fP"
Display only network connections using the indicated protocol
(currently either ``tcp'' or ``udp'').
.IP "ignore [items]"
Do not display information about connections associated with
the specified hosts or ports.  Hosts and ports may be specified
by name (``ucbmonet'', ``ftp''), or numerically.  Host addresses
use the Internet dot notation (``128.32.0.9'').  Multiple items
may be specified with a single command by separating them with
spaces.
.IP "display [items]"
Display information about the connections associated with the
specified hosts or ports.  As for 
.IR ignore ,
.I items
may be names or numbers.
.IP "show [ports|hosts]"
Show, on the command line, the currently selected protocols,
hosts, and ports.  Hosts and ports which are being ignored
are prefixed with a `!'.  If
.I ports
or
.I hosts
is supplied as an argument to 
.IR show ,
then only the requested information will be displayed.
.IP "reset"
Reset the port, host, and protocol matching mechanisms to the default
(any protocol, port, or host).
.SH FILES
.nf
.ta \w'/dev/services   'u
/vmunix	for the namelist
/dev/kmem	for information in main memory
/dev/drum	for information about swapped out processes
/etc/hosts	for host names
/etc/networks	for network names
/etc/services	for port names
.SH AUTHOR
The unknown hacker.  The 
.I pigs
display is derived from a program of the same name
written by Bill Reeves.
.SH BUGS
Takes 2-10 percent of the cpu.  Certain displays presume
a 24 line by 80 character terminal.  The swap space display
should account for space allocated to the user structure and
page tables.  The
.I vmstat
display looks out of place because it is (it was added in as
a separate display rather than create a new program).
.PP
The whole
thing is pretty hokey and was included in the distribution under
serious duress.
