.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)sccs.1	2.5 (Berkeley) 5/12/86
.\"
.TH SCCS 1 "May 12, 1986"
.UC 5
.SH NAME
sccs \- front end for the \s-1SCCS\s0 subsystem
.SH SYNOPSIS
.B sccs
[
.B \-r
] [
.BI \-d path
] [
.BI \-p path
] command [ flags ] [ args ]
.SH DESCRIPTION
.I Sccs
is a front end
to the
.SM SCCS
programs
that helps them mesh more cleanly
with the rest of UNIX.
It also includes the capability to run
``set user id'' to another user
to provide additional protection.
.PP
Basically,
.I sccs
runs the
.I command
with the specified
.I flags
and
.I args.
Each
argument
is normally modified to be prepended
with ``SCCS/s.''.
.PP
Flags to be interpreted by the
.I sccs
program must be before the
.I command
argument.
Flags to be passed to the actual
.SM SCCS
program
must come after the
.I command
argument.
These flags are specific to the command
and are discussed in the documentation for that command.
.PP
Besides the usual
.SM SCCS
commands,
several ``pseudo-commands'' can be issued.
These are:
.IP edit 1i
Equivalent to ``get \-e''.
.IP delget
Perform a delta on the named files
and then get new versions.
The new versions will have id keywords expanded,
and will not be editable.
The \-m, \-p, \-r, \-s, and \-y flags
will be passed to delta,
and the \-b, \-c, \-e, \-i, \-k, \-l, \-s, and \-x flags
will be passed to get.
.IP deledit
Equivalent to ``delget'' except that the
``get'' phase includes the ``\-e'' flag.
This option is useful for making a ``checkpoint''
of your current editing phase.
The same flags will be passed to delta
as described above,
and all the flags listed for ``get''
above except \-e and \-k
are passed to ``edit''.
.IP create
Creates an
.SM SCCS
file,
taking the initial contents from the file of the same name.
Any flags to ``admin'' are accepted.
If the creation is successful,
the files are renamed with a comma on the front.
These should be removed when you are convinced that
the
.SM SCCS
files have been created successfully.
.IP fix
Must be followed by a
.B \-r
flag.
This command essentially removes the named delta,
but leaves you with a copy of the delta
with the changes that were in it.
It is useful for fixing small compiler bugs, etc.
Since it doesn't leave audit trails,
it should be used carefully.
.IP clean
This routine removes everything from the current directory
that can be recreated from SCCS files.
It will not remove any files being edited.
If the
.B \-b
flag is given, branches are ignored in the determination
of whether they are being edited;
this is dangerous if you are keeping the branches in the
same directory.
.IP unedit
This is the opposite of an ``edit''
or a ``get \-e''.
It should be used with extreme caution,
since any changes you made since the get
will be irretrievably lost.
.IP info
Gives a listing of all files being edited.
If the
.B \-b
flag is given,
branches (i.e.,
\s-1SID\s0's with two or fewer components)
are ignored.
If the
.B \-u
flag is given
(with an optional argument)
then only files being edited by you
(or the named user)
are listed.
.IP check
Like ``info''
except that nothing is printed if nothing is being edited,
and a non-zero exit status is returned if anything
is being edited.
The intent is to have this included in an ``install''
entry in a makefile
to insure that everything is included into the
.SM SCCS
file
before a version is installed.
.IP tell
Gives a newline-separated list
of the files being edited
on the standard output.
Takes the
.B \-b
and
.B \-u
flags like 
``info'' and ``check''.
.IP diffs
Gives a ``diff'' listing between the current version of the
program(s) you have out for editing and the versions
in
.SM SCCS
format.
The
.B \-r,
.B \-c,
.B \-i,
.B \-x,
and
.B \-t
flags are passed to
.I get\c
; the
.B \-l,
.B \-s,
.B \-e,
.B \-f,
.B \-h,
and
.B \-b
options are passed to
.I diff.
The
.B \-C
flag is passed to
.I diff
as
.B \-c.
.IP print
This command prints out verbose information
about the named files.
.PP
The
.B \-r
flag runs
.I sccs
as the real user
rather than as whatever effective user
.I sccs
is ``set user id'' to.
The
.B \-d
flag gives a root directory for the
.SM SCCS
files.
The default is the current directory.
The
.B \-p
flag defines the pathname of the directory
in which the
.SM SCCS
files will be found;
``SCCS'' is the default.
The
.B \-p
flag differs from the
.B \-d
flag in that the
.B \-d
argument is prepended to the entire pathname
and the
.B \-p
argument is inserted before the final component of the
pathname.
For example,
``sccs \-d/x \-py get a/b''
will convert to
``get /x/a/y/s.b''.
The intent here is to create aliases such as
``alias syssccs sccs -d/usr/src''
which will be used as
``syssccs get cmd/who.c''.
Also, if the environment variable
PROJECT
is set,
its value is used to determine the
.B \-d flag.
If it begins with a slash,
it is taken directly;
otherwise,
the home directory of a user of that name
is examined for a subdirectory ``src'' or ``source''.
If such a directory is found,
it is used.
.PP
Certain commands (such as
.IR admin )
cannot be run ``set user id'' by all users,
since this would allow anyone to change the authorizations.
These commands are always run as the real user.
.SH EXAMPLES
.de BX
.PP
.nf
.in +0.5i
..
.de EX
.fi
.PP
..
To get a file for editing,
edit it,
and produce a new delta:
.BX
sccs get \-e file.c
ex file.c
sccs delta file.c
.EX
To get a file from another directory:
.BX
sccs \-p/usr/src/sccs/s. get cc.c
.EX
or
.BX
sccs get /usr/src/sccs/s.cc.c
.EX
To make a delta of a large number of files
in the current directory:
.BX
sccs delta *.c
.EX
To get a list of files being edited that are not on branches:
.BX
sccs info \-b
.EX
To delta everything being edited by you:
.BX
sccs delta \`sccs tell \-u\`
.EX
In a makefile, to get source files
from an
.SM SCCS
file if it does not already exist:
.BX
SRCS = <list of source files>
$(SRCS):
	sccs get $(REL) $@
.EX
.SH "SEE ALSO"
admin(SCCS),
chghist(SCCS),
comb(SCCS),
delta(SCCS),
get(SCCS),
help(SCCS),
prt(SCCS),
rmdel(SCCS),
sccsdiff(SCCS),
what(SCCS)
.br
Eric Allman,
.ul
An Introduction to the Source Code Control System
.SH BUGS
It should be able to take directory arguments on pseudo-commands
like the
.SM SCCS
commands do.
