.\" Copyright (c) 1985 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)rdist.1	6.6 (Berkeley) 5/13/86
.\"
.TH RDIST 1 "May 13, 1986"
.UC 6
.ad
.SH NAME
rdist \- remote file distribution program
.SH SYNOPSIS
.B rdist
[ \-nqbRhivwy ]
[ \-f distfile ] [ \-d var=value ] [ \-m host ]
[ name ... ]
.PP
.B rdist
[ \-nqbRhivwy ] -c name ... [login@]host[:dest]
.SH DESCRIPTION
.I Rdist
is a program to maintain identical copies of files over multiple hosts. 
It preserves the owner, group, mode, and mtime of files if possible and
can update programs that are executing.
.I Rdist
reads commands from
.I distfile
to direct the updating of files and/or directories.
If
.I distfile
is `\-', the standard input is used.
If no
.B \-f
option is present, the program looks first for `distfile',
then `Distfile' to use as the input.
If no names are specified on the command line,
.I rdist
will update all of the files and directories listed in
.IR distfile .
Otherwise, the argument is taken to be the name of a file to be updated
or the label of a command to execute. If label and file names conflict,
it is assumed to be a label.
These may be used together to update specific files
using specific commands.
.PP
The
.B \-c
option forces
.I rdist
to interpret the remaining arguments as a small
.IR distfile .
The equivalent distfile is as follows.
.nf

.ti +.5i
( \fIname\fP ... ) -> [\fIlogin\fP@]\fIhost\fP
.ti +1i
install	[\fIdest\fP] ;

.fi
.PP
Other options:
.TP
.B \-d
Define
.I var
to have
.IR value .
The
.B \-d
option is used to define or override variable definitions in the
.IR distfile .
.I Value
can be the empty string, one name, or a list of names surrounded by
parentheses and separated by tabs and/or spaces.
.TP
.B \-m
Limit which machines are to be updated. Multiple
.B -m
arguments can be given to limit updates to a subset of the hosts listed the
.IR distfile .
.TP
.B \-n
Print the commands without executing them. This option is
useful for debugging
.IR distfile .
.TP
.B \-q
Quiet mode. Files that are being modified are normally
printed on standard output. The
.B \-q
option suppresses this.
.TP
.B \-R
Remove extraneous files. If a directory is being updated, any files that exist
on the remote host that do not exist in the master directory are removed.
This is useful for maintaining truely identical copies of directories.
.TP
.B \-h
Follow symbolic links. Copy the file that the link points to rather than the
link itself.
.TP
.B \-i
Ignore unresolved links.
.I Rdist
will normally try to maintain the link structure of files being transfered
and warn the user if all the links cannot be found.
.TP
.B \-v
Verify that the files are up to date on all the hosts. Any files
that are out of date will be displayed but no files will be changed
nor any mail sent.
.TP
.B \-w
Whole mode. The whole file name is appended to the destination directory
name. Normally, only the last component of a name is used when renaming files.
This will preserve the directory structure of the files being
copied instead of flattening the directory structure. For example,
renaming a list of files such as ( dir1/f1 dir2/f2 ) to dir3 would create
files dir3/dir1/f1 and dir3/dir2/f2 instead of dir3/f1 and dir3/f2.
.TP
.B \-y
Younger mode. Files are normally updated if their
.I mtime
and
.I size
(see
.IR stat (2))
disagree. The
.B \-y
option causes
.I rdist
not to update files that are younger than the master copy.
This can be used
to prevent newer copies on other hosts from being replaced.
A warning message is printed for files which are newer than the master copy.
.TP
.B \-b
Binary comparison. Perform a binary comparison and update files if they differ
rather than comparing dates and sizes.
.PP
.I Distfile
contains a sequence of entries that specify the files
to be copied, the destination hosts, and what operations to perform
to do the updating. Each entry has one of the following formats.
.nf

.in +.5i
<variable name> `=' <name list>
[ label: ] <source list> `\->' <destination list> <command list>
[ label: ] <source list> `::' <time_stamp file> <command list>
.in

.fi
The first format is used for defining variables.
The second format is used for distributing files to other hosts.
The third format is used for making lists of files that have been changed
since some given date.
The \fIsource list\fP specifies a
list of files and/or directories on the local host which are to be used
as the master copy for distribution.
The \fIdestination list\fP is the list of hosts to which these files are to be
copied.  Each file in the source list is added to a list of changes
if the file is out of date on the host which is being updated (second format) or
the file is newer than the time stamp file (third format).
.PP
Labels are optional. They are used to identify a command for partial updates.
.PP
Newlines, tabs, and blanks are only used as separators and are
otherwise ignored. Comments begin with `#' and end with a newline.
.PP
Variables to be expanded begin with `$' followed by one character or
a name enclosed in curly braces (see the examples at the end).
.PP
The source and destination lists have the following format:
.nf

.ti +.5i
<name>
or
.ti +.5i
`(' <zero or more names separated by white-space> `)'

.fi
The shell meta-characters `[', `]', `{', `}', `*', and `?'
are recognized and expanded (on the local host only) in the same way as
.IR csh (1).
They can be escaped with a backslash.
The `~' character is also expanded in the same way as
.IR csh
but is expanded separately on the local and destination hosts.
When the
.B \-w
option is used with a file name that begins with `~', everything except the
home directory is appended to the destination name.
File names which do not begin with `/' or `~' use the destination user's
home directory as the root directory for the rest of the file name.
.PP
The command list consists of zero or more commands of the following
format.
.nf

.in +.5i
.ta \w'install    'u +\w'name list    'u
`install'	<options>	opt_dest_name `;'
`notify'	<name list>	`;'
`except'	<name list>	`;'
`except_pat'	<pattern list>	`;'
`special'	<name list>	string `;'
.in

.fi
.PP
The
.I install
command is used to copy out of date files and/or directories.
Each source file is copied to each host in the destination list.
Directories are recursively copied in the same way.
.I Opt_dest_name
is an optional parameter to rename files.
If no
.I install
command appears in the command list or
the destination name is not specified,
the source file name is used.
Directories in the path name will be created if they
do not exist on the remote host.
To help prevent disasters, a non-empty directory on a target host will
never be replaced with a regular file or a symbolic link.
However, under the `\-R' option a non-empty directory will be removed
if the corresponding filename is completely absent on the master host.
The
.I options
are `\-R', `\-h', `\-i', `\-v', `\-w', `\-y', and `\-b'
and have the same semantics as
options on the command line except they only apply to the files
in the source list.
The login name used on the destination host is the same as the local host
unless the destination name is of the format ``login@host".
.PP
The
.I notify
command is used to mail the list of files updated (and any errors
that may have occured) to the listed names.
If no `@' appears in the name, the destination host is appended to
the name
(e.g., name1@host, name2@host, ...).
.PP
The
.I except
command is used to update all of the files in the source list
.B except
for the files listed in \fIname list\fP.
This is usually used to copy everything in a directory except certain files.
.PP
The
.I except_pat
command is like the
.I except
command except that \fIpattern list\fP is a list of regular expressions
(see
.IR ed (1)
for details).
If one of the patterns matches some string within a file name, that file will
be ignored.
Note that since `\e' is a quote character, it must be doubled to become
part of the regular expression.  Variables are expanded in \fIpattern list\fP
but not shell file pattern matching characters.  To include a `$', it
must be escaped with `\e'.
.PP
The
.I special
command is used to specify
.IR sh (1)
commands that are to be executed on the
remote host after the file in \fIname list\fP is updated or installed.
If the \fIname list\fP is omitted then the shell commands will be executed
for every file updated or installed.  The shell variable `FILE' is set
to the current filename before executing the commands in
.IR string .
.I String
starts and ends with `"' and can cross multiple lines in
.I distfile.
Multiple commands to the shell should be separated by `;'.
Commands are executed in the user's home directory on the host
being updated.
The
.I special
command can be used to rebuild private databases, etc.
after a program has been updated.
.PP
The following is a small example.
.nf

.in +.5i
HOSTS = ( matisse root@arpa)

FILES = ( /bin /lib /usr/bin /usr/games
	/usr/include/{*.h,{stand,sys,vax*,pascal,machine}/*.h}
	/usr/lib /usr/man/man? /usr/ucb /usr/local/rdist )

EXLIB = ( Mail.rc aliases aliases.dir aliases.pag crontab dshrc
	sendmail.cf sendmail.fc sendmail.hf sendmail.st uucp vfont )

${FILES} -> ${HOSTS}
	install -R ;
	except /usr/lib/${EXLIB} ;
	except /usr/games/lib ;
	special /usr/lib/sendmail "/usr/lib/sendmail -bz" ;

srcs:
/usr/src/bin -> arpa
	except_pat ( \e\e.o\e$ /SCCS\e$ ) ;

IMAGEN = (ips dviimp catdvi)

imagen:
/usr/local/${IMAGEN} -> arpa
	install /usr/local/lib ;
	notify ralph ;

${FILES} :: stamp.cory
	notify root@cory ;
.in

.fi
.SH FILES
.nf
.ta \w'/tmp/rdist*    'u
distfile	input command file
/tmp/rdist*	temporary file for update lists
.fi
.SH "SEE ALSO"
sh(1), csh(1), stat(2)
.SH DIAGNOSTICS
A complaint about mismatch of rdist version numbers may really stem
from some problem with starting your shell, e.g., you are in too many groups.
.SH BUGS
Source files must reside on the local host where rdist is executed.
.PP
There is no easy way to have a special command executed after all files
in a directory have been updated.
.PP
Variable expansion only works for name lists; there should be a general macro
facility.
.PP
.I Rdist
aborts on files which have a negative mtime (before Jan 1, 1970).
.PP
There should be a `force' option to allow replacement of non-empty directories
by regular files or symlinks.  A means of updating file modes and owners
of otherwise identical files is also needed.
