.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)netstat.1	6.7 (Berkeley) 5/14/88
.\"
.TH NETSTAT 1 "May 14, 1988"
.UC 5
.SH NAME
netstat \- show network status
.SH SYNOPSIS
.B netstat
[ 
.B \-Aan
] [
.B \-f
.I address_family
] [
.I system
] [
.I core
]
.br
.B netstat
[ 
.B \-himnrs
] [
.B \-f
.I address_family
] [
.I system
] [
.I core
]
.br
.B netstat
[ 
.B \-n
] [
.B \-I
.I interface
]
.I interval
[
.I system
] [
.I core
]
.br
.B netstat
[ 
.B \-p
.I protocol
] [
.I system
] [
.I core
]
.SH DESCRIPTION
The
.I netstat 
command symbolically displays the contents of various network-related
data structures.
There are a number of output formats,
depending on the options for the information presented.
The first form of the command displays a list of active sockets for
each protocol.
The second form presents the contents of one of the other network
data structures according to the option selected.
Using the third form, with an 
.I interval
specified,
.I netstat
will continuously display the information regarding packet
traffic on the configured network interfaces.
The fourth form displays statistics about the named protocol.
.PP
The options have the following meaning:
.TP 
.B \-A
With the default display,
show the address of any protocol control blocks associated with sockets; used
for debugging.
.TP
.B \-a
With the default display,
show the state of all sockets; normally sockets used by
server processes are not shown.
.B \-d
With either interface display (option
.B \-i
or an interval, as described below),
show the number of dropped packets.
.TP
.B \-h
Show the state of the IMP host table.
.TP
.B \-i
Show the state of interfaces which have been auto-configured
(interfaces statically configured into a system, but not
located at boot time are not shown).
.TP
.BI \-I " interface"
Show information only about this interface;
used with an
.I interval
as described below.
.TP
.B \-m
Show statistics recorded by the memory management routines
(the network manages a private pool of memory buffers).
.TP
.B \-n
Show network addresses as numbers (normally 
.I netstat
interprets addresses and attempts to display them
symbolically).
This option may be used with any of the display formats.
.TP
.BI \-p " protocol"
Show statistics about 
.IR protocol ,
which is either a well-known name for a protocol or an alias for it.  Some
protocol names and aliases are listed in the file 
.IR /etc/protocols .
A null response typically means that there are no interesting numbers to 
report.
The program will complain if
.I protocol
is unknown or if there is no statistics routine for it.
.TP
.B \-s
Show per-protocol statistics.
.TP
.B \-r
Show the routing tables.
When
.B \-s
is also present, show routing statistics instead.
.TP
.BI \-f " address_family"
Limit statistics or address control block reports to those
of the specified
.IR address\ family .
The following address families
are recognized:
.IR inet ,
for
.BR AF_INET ,
.IR ns ,
for
.BR AF_NS ,
and
.IR unix ,
for
.BR AF_UNIX .
.PP
The arguments, 
.I system
and
.I core
allow substitutes for the defaults ``/vmunix'' and ``/dev/kmem''.
.PP
The default display, for active sockets, shows the local
and remote addresses, send and receive queue sizes (in bytes), protocol,
and the internal state of the protocol.
Address formats are of the form ``host.port'' or ``network.port''
if a socket's address specifies a network but no specific host address.
When known the host and network addresses are displayed symbolically
according to the data bases
.I /etc/hosts
and
.IR /etc/networks ,
respectively.  If a symbolic name for an address is unknown, or if
the 
.B \-n
option is specified, the address is printed numerically, according
to the address family.
For more information regarding 
the Internet ``dot format,''
refer to 
.IR inet (3N).
Unspecified,
or ``wildcard'', addresses and ports appear as ``*''.  
.PP
The interface display provides a table of cumulative
statistics regarding packets transferred, errors, and collisions.
The network addresses of the interface
and the maximum transmission unit (``mtu'') are also displayed.
.PP
The routing table display indicates the available routes and
their status.  Each route consists of a destination host or network
and a gateway to use in forwarding packets.  The flags field shows
the state of the route (``U'' if ``up''), whether the route
is to a gateway (``G''), whether the route was created dynamically
by a redirect (``D''), and whether the route has been modified
by a redirect (``M'').  Direct routes are created for each
interface attached to the local host;
the gateway field for such entries shows the address of the outgoing interface.
The refcnt field gives the
current number of active uses of the route.  Connection oriented
protocols normally hold on to a single route for the duration of
a connection while connectionless protocols obtain a route while sending
to the same destination.
The use field provides a count of the number of packets
sent using that route.  The interface entry indicates the network
interface utilized for the route.
.PP
When 
.I netstat
is invoked with an
.I interval
argument, it displays a running count of statistics related to
network interfaces.  This display consists of a
column for the primary interface
(the first interface found during autoconfiguration)
and a column summarizing
information for all interfaces.
The primary interface may be replaced with another interface with the
.I \-I
option.
The first line of each screen of information contains a summary since the
system was last rebooted.  Subsequent lines of output show values
accumulated over the preceding interval.
.SH SEE ALSO
iostat(1),
vmstat(1),
hosts(5),
networks(5),
protocols(5),
services(5),
trpt(8C)
.SH BUGS
The notion of errors is ill-defined.  Collisions mean
something else for the IMP.
