.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)man.1	6.7 (Berkeley) 4/19/88
.\"
.TH MAN 1 "April 19, 1988"
.UC 4
.SH NAME
man \- print out the manual
.SH SYNOPSIS
.br
.B man
[
.B \-
] [
.B -a
] [
.B \-M
.I path
] [
section
]
title ...
.SH DESCRIPTION
\fIMan\fP is the program which provides on-line access to the UNIX manual.
If a \fIsection\fP specifier is given, \fIman\fP looks in that section of
the manual for the given \fItitle\fP(s).  \fISection\fP is either an Arabic
section number (``3'' for example), or one of the words ``local'', ``new,''
or ``old''.  (The abbreviations ``l'', ``n'', and ``o'' are also allowed.)
If \fIsection\fP is omitted, \fIman\fP searches all sections of the manual,
giving preference to commands over library subroutines, and displays the
first manual page it finds, if any.  If the \fI-a\fP option is supplied,
\fIman\fP displays all applicable manual pages.
.PP
Normally \fIman\fP checks in standard locations (/usr/man and /usr/local/man)
for manual information.  This can be changed by supplying a search path (a
la the Bourne shell) with the \fB-M\fP flag.  The search path is a colon
(``:'') separated list of directories in which \fIman\fP expects to find
the standard manual subdirectories.  This search path can also be set with
the environmental variable \fIMANPATH\fP.
.PP
Since some manual pages are intended for use only on certain machines,
\fIman\fP only searches those directories applicable to the current
machine.  \fIMan\fP's determination of the current machine type can
be overridden by setting the environmental variable \fIMACHINE\fP.
.PP
If the standard output is a teletype, and the \fB-\fP flag is not provided,
\fIman\fP uses \fImore\fP(1), or the pager provided by the environmental
variable \fIPAGER\fP, to display the manual page.
.PP
The FORTRAN version of section 3 of the manual may be specified by supplying
\fIman\fP with the \fIsection\fP ``3f''.  Also, a specific section of the
local manual may be specified by appending a number to the \fIsection\fP,
i.e. ``l5'' would indicate section 5 of the local manual.
.SH FILES
.nf
.ta \w'/usr/local/man/man?/*   'u
/usr/man	standard manual area
/usr/man/cat?/*	directories containing standard manual pages
/usr/local/man/cat?/*	directories containing local manual pages
/usr/src/man	directories containing unformatted manual pages
.fi
.SH SEE\ ALSO
apropos(1), more(1), whatis(1), whereis(1)
.SH BUGS
The manual is supposed to be reproducible either on the
phototypesetter or on a typewriter, however, on a typewriter,
some information is necessarily lost.
