.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)lastcomm.1	6.3 (Berkeley) 3/8/88
.\"
.TH LASTCOMM 1 "March 8, 1988"
.UC
.SH NAME
lastcomm \- show last commands executed in reverse order
.SH SYNOPSIS
.B lastcomm
[ -f file ]
[ command name ] ... [user name] ... [terminal name] ...
.SH DESCRIPTION
.I Lastcomm
gives information on previously executed commands.
With no arguments,
.I lastcomm
prints information about all the commands recorded
during the current accounting file's lifetime.  The \fI-f\fP option
causes \fIlastcomm\fP to read from a file other than the default
accounting file.
If called with arguments, only accounting entries with a
matching command
name, user name, or terminal name are printed.
So, for example,
.ti +0.5i
lastcomm a.out root ttyd0
.br
would produce a listing of all the
executions of commands named
.I a.out
by user
.I root
on the terminal
.IR ttyd0 .
.PP
For each process entry, the following are printed.
.in +0.5i
The name of the user who ran the process.
.br
Flags, as accumulated by the accounting facilities in the system.
.br
The command name under which the process was called.
.br
The amount of cpu time used by the process (in seconds).
.br
The time the process exited.
.in -0.5i
.PP
The flags are encoded as follows: ``S'' indicates the command was
executed by the super-user, ``F'' indicates the command ran after
a fork, but without a following 
.IR exec ,
``C'' indicates the command was run in PDP-11 compatibility mode
(VAX only),
``D'' indicates the command terminated with the generation of a
.I core
file, and ``X'' indicates the command was terminated with a signal.
.SH FILES
/usr/adm/acct
.SH "SEE ALSO"
last(1),
sigvec(2),
acct(8),
core(5)
