.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)gprof.1	6.3 (Berkeley) 9/30/87
.\"
.TH GPROF 1 "September 30, 1987"
.UC 5
.SH NAME
gprof \- display call graph profile data
.SH SYNOPSIS
.B gprof
[ options ] [ a.out [ gmon.out ... ] ]
.SH DESCRIPTION
.I gprof
produces an execution profile of C, Pascal, or Fortran77 programs.
The effect of called routines is incorporated in the profile of each caller.
The profile data is taken from the call graph profile file
.RI ( gmon.out
default) which is created by programs
that are compiled with the 
.B \-pg
option of 
.IR cc ,
.IR pc ,
and
.IR f77 .
The
.B \-pg
option also links in versions of the library routines 
that are compiled for profiling.
The symbol table in the named object file
.RI ( a.out
default)
is read and correlated with the call graph profile file.
If more than one profile file is specified,
the
.I gprof
output shows the sum of the profile information in the given profile files.
.PP
.I Gprof
calculates the amount of time spent in each routine.
Next, these times are propagated along the edges of the call graph.
Cycles are discovered, and calls into a cycle are made to share the time 
of the cycle.
The first listing shows the functions
sorted according to the time they represent
including the time of their call graph descendents.
Below each function entry is shown its (direct) call graph children,
and how their times are propagated to this function.
A similar display above the function shows how this function's time and the
time of its descendents is propagated to its (direct) call graph parents.
.PP
Cycles are also shown, with an entry for the cycle as a whole and
a listing of the members of the cycle and their contributions to the
time and call counts of the cycle.
.PP
Second, a flat profile is given,
similar to that provided by
.IR prof (1).
This listing gives the total execution times, the call counts,
the number of milliseconds per call in the routine itself, and
the number of milliseconds per call in the routine itself including
its descendents.
.PP
Finally, an index of the function names is provided.
.PP
The following options are available:
.TP
.B \-a
suppresses the printing of statically declared functions.
If this option is given, all relevant information about the static function
.RI ( e.g.,
time samples, calls to other functions, calls from other functions)
belongs to the function loaded just before the static function in the
.I a.out
file.
.TP
.B \-b
suppresses the printing of a description of each field in the profile.
.TP
.B \-c
the static call graph of the program is discovered by a heuristic
that examines the text space of the object file.
Static-only parents or children are shown
with call counts of 0.
.TP
.BI \-e " name"
suppresses the printing of the graph profile entry for routine
.I name
and all its descendants
(unless they have other ancestors that aren't suppressed).
More than one
.B \-e
option may be given.
Only one
.I name
may be given with each
.B \-e
option.
.TP
.BI \-E " name"
suppresses the printing of the graph profile entry for routine
.I name
(and its descendants) as 
.BR \-e ,
above, and also excludes the time spent in
.I name
(and its descendants) from the total and percentage time computations.
(For example,
.B \-E
.I mcount
.B \-E
.I mcleanup
is the default.)
.TP
.BI \-f " name"
prints the graph profile entry of only the specified routine
.I name
and its descendants.
More than one
.B \-f
option may be given.
Only one
.I name
may be given with each
.B \-f
option.
.TP
.BI \-F " name"
prints the graph profile entry of only the routine
.I name
and its descendants (as 
.BR \-f,
above) and also uses only the times of the printed routines
in total time and percentage computations.
More than one
.B \-F
option may be given.
Only one
.I name
may be given with each
.B \-F
option.
The
.B \-F
option
overrides
the
.B \-E
option.
.TP
.BI \-k " fromname toname"
will delete any arcs from routine
.I fromname
to routine
.IR toname .
This can be used to break undesired cycles.
More than one
.B \-k
option may be given.
Only one pair of routine names may be given with each
.B \-k
option.
.TP
.B \-s
a profile file
.I gmon.sum
is produced that represents
the sum of the profile information in all the specified profile files.
This summary profile file may be given to later
executions of gprof (probably also with a
.BR \-s )
to accumulate profile data across several runs of an
.I a.out
file.
.TP
.B \-z
displays routines that have zero usage (as shown by call counts
and accumulated time).
This is useful with the 
.B \-c
option for discovering which routines were never called.
.SH FILES
.ta 1.5i
.I a.out	
the namelist and text space.
.br
.I gmon.out	
dynamic call graph and profile.
.br
.I gmon.sum	
summarized dynamic call graph and profile.
.SH "SEE ALSO"
monitor(3), profil(2), cc(1), prof(1)
.br
``gprof: A Call Graph Execution Profiler'', by
Graham, S.L., Kessler, P.B., McKusick, M.K.;
.IR "Proceedings of the SIGPLAN '82 Symposium on Compiler Construction" ,
SIGPLAN Notices, Vol. 17, No. 6, pp. 120-126, June 1982.
.SH BUGS
Beware of quantization errors.
The granularity of the sampling is shown, but remains
statistical at best.
We assume that the time for each execution of a function
can be expressed by the total time for the function divided
by the number of times the function is called.
Thus the time propagated along the call graph arcs to the function's
parents is directly proportional to the number of times that
arc is traversed.
.PP
Parents that are not themselves profiled will have the time of 
their profiled children propagated to them, but they will appear
to be spontaneously invoked in the call graph listing, and will
not have their time propagated further.
Similarly, signal catchers, even though profiled, will appear
to be spontaneous (although for more obscure reasons).
Any profiled children of signal catchers should have their times
propagated properly, unless the signal catcher was invoked during 
the execution of the profiling routine, in which case all is lost.
.PP
The profiled program must call 
.IR exit (2)
or return normally for the profiling information to be saved
in the gmon.out file.
