.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)vi.1	6.1 (Berkeley) 4/29/85
.\"
.TH VI 1 "April 29, 1985"
.UC
.SH NAME
vi \- screen oriented (visual) display editor based on ex
.SH SYNOPSIS
.B vi
[
.B \-t
tag
] [
.B \-r
] [
\fB+\fR\fIcommand\fR
] [
.B \-l
] [
\fB\-w\fIn\fR
]
name ...
.SH DESCRIPTION
.I Vi
(visual) is a display oriented text editor based on
.IR ex (1).
.I Ex
and
.I vi
run the same code; it is possible to get to
the command mode of
.I ex
from within
.I vi
and vice-versa.
.PP
The
.I "Vi Quick Reference"
card and the
.I "Introduction to Display Editing with Vi"
provide full details on using
.I vi.
.SH FILES
See
.IR ex (1).
.SH SEE ALSO
ex (1), edit (1), ``Vi Quick Reference'' card,
``An Introduction to Display Editing with Vi''.
.SH AUTHOR
William Joy
.br
Mark Horton added macros to \fIvisual\fR mode and is maintaining version 3
.SH BUGS
Software tabs using \fB^T\fR work only immediately after the
.I autoindent.
.PP
Left and right shifts on intelligent terminals don't make use of
insert and delete character operations in the terminal.
.PP
The
.I wrapmargin
option can be fooled since it looks at output columns when blanks are typed.
If a long word passes through the margin and onto the next line without a 
break, then the line won't be broken.
.PP
Insert/delete within a line can be slow if tabs are present on intelligent
terminals, since the terminals need help in doing this correctly.
.PP
Saving text on deletes in the named buffers is somewhat inefficient.
.PP
The
.I source
command does not work when executed as \fB:source\fR;
there is no way to use the \fB:append\fR, \fB:change\fR,
and \fB:insert\fR commands, since it is not possible to give
more than one line of input to a \fB:\fR escape.  To use these
on a \fB:global\fR you must \fBQ\fR to \fIex\fR command mode,
execute them, and then reenter the screen editor with
.I vi
or
.I open.
