.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)ex.1	6.4 (Berkeley) 6/5/86
.\"
.TH EX 1 "June 5, 1986"
.UC 4
.SH NAME
ex, edit \- text editor
.SH SYNOPSIS
.B ex
[
.B \-
] [
.B \-v
] [
.B \-t 
tag
] [
.B \-r
] [
\fB+\fIcommand\fR
] [
.B \-l
]
name ...
.br
.B edit
[
ex options
]
.SH DESCRIPTION
.I Ex
is the root of a family of editors:
.I edit,
.I ex
and
.I vi.
.I Ex
is a superset of
.I ed,
with the most notable extension being a display editing facility.
Display based editing is the focus of
.I vi.
.PP
If you have not used
.I ed,
or are a casual user, you will find that the editor
.I edit
is convenient for you.
It avoids some of the complexities of
.I ex
used mostly by systems programmers and persons very familiar with
.I ed.
.PP
If you have a \s-2CRT\s0 terminal, you may wish to use a display
based editor; in this case
see
.IR vi (1),
which is a command which focuses on the display editing portion of
.I ex.
.SH DOCUMENTATION
The document
.I "Edit: A tutorial"
(USD:14) provides a comprehensive introduction to
.I edit
assuming no previous knowledge of computers or the \s-2UNIX\s0 system.
.PP
The
.I "Ex Reference Manual \- Version 3.7"
(USD:16)
is a comprehensive and complete manual for the command mode features
of
.I ex,
but you cannot learn to use the editor by reading it.
For an introduction to
more advanced forms of editing using the command mode of
.I ex
see the editing documents written by Brian Kernighan for the editor
.I ed;
the material in the introductory and advanced documents works also with
.I ex.
.PP
.I "An Introduction to Display Editing with Vi"
(USD:15)
introduces the display editor
.I vi
and provides reference material on
.I vi.
In addition, the
.I "Vi Quick Reference"
card summarizes the commands
of
.I vi
in a useful, functional way, and is useful with the
.I Introduction.
.SH FILES
.DT
/usr/lib/ex?.?strings		error messages
.br
/usr/lib/ex?.?recover		recover command
.br
/usr/lib/ex?.?preserve		preserve command
.br
/etc/termcap			describes capabilities of terminals
.br
~/.exrc				editor startup file
.br
/tmp/Ex\fInnnnn\fR			editor temporary
.br
/tmp/Rx\fInnnnn\fR			named buffer temporary
.br
/usr/preserve			preservation directory
.SH SEE ALSO
awk(1), ed(1), grep(1), sed(1), grep(1), vi(1), termcap(5), environ(7)
.SH AUTHOR
Originally written by William Joy
.br
Mark Horton has maintained the editor since version 2.7, adding macros,
support for many unusual terminals,
and other features such as word abbreviation mode.
.SH BUGS
The
.I undo
command causes all marks to be lost on lines changed and then restored
if the marked lines were changed.
.PP
.I Undo
never clears the buffer modified condition.
.PP
The
.I z
command prints a number of logical rather than physical lines.
More than a screen full of output may result if long lines are present.
.PP
File input/output errors don't print a name if the command line \fB`\-'\fR
option is used.
.PP
There is no easy way to do a single scan ignoring case.
.PP
The editor does not warn if text is placed in named buffers and not used
before exiting the editor.
.PP
Null characters are discarded in input files, and cannot appear in resultant
files.
