.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)error.1	6.2 (Berkeley) 5/5/86
.\"
.TH ERROR 1 "May 5, 1986"
.UC 4
.SH NAME
error \- analyze and disperse compiler error messages
.SH SYNOPSIS
.B error
[
.B \-n
] [
.B \-s
] [
.B \-q
] [
.B \-v
] [
.B \-t
suffixlist
] [
.B \-I
ignorefile
] [ name ]
.SH DESCRIPTION
.I Error
analyzes and optionally disperses the diagnostic error messages
produced by a number of compilers and language processors to the source
file and line where the errors occurred.  It can replace the painful,
traditional methods of scribbling abbreviations of errors on paper, and
permits error messages and source code to be viewed simultaneously
without machinations of multiple windows in a screen editor.
.PP
.I Error
looks at the error messages,
either from the specified file \fIname\fR
or from the standard input,
and attempts to determine which
language processor produced each error message,
determines the source file and line number to which the error message refers,
determines if the error message is to be ignored or not,
and inserts the (possibly slightly modified) error message into
the source file as a comment on the line preceding to which the
line the error message refers.
Error messages which can't be categorized by language processor
or content are not inserted into any file,
but are sent to the standard output.
.I Error
touches source files only after all input has been read.
By specifying the
.B \-q
query option,
the user is asked to confirm any potentially
dangerous (such as touching a file) or verbose action.
Otherwise
.I error
proceeds on its merry business.
If the
.B \-t
touch option and associated suffix list is given, 
.I error
will restrict itself to touch only those files with suffices
in the suffix list.
Error also can be asked (by specifying
.B \-v)
to invoke
.IR vi (1)
on the files in which error messages were inserted; this obviates
the need to remember the names of the files with errors.
.PP
.I Error
is intended to be run
with its standard input
connected via a pipe to the error message source.
Some language processors put error messages on their standard error file;
others put their messages on the standard output.
Hence, both error sources should be piped together into
.I error.
For example, when using the \fIcsh\fP syntax,
.IP
make \-s lint |\|& error \-q \-v
.LP
will analyze all the error messages produced
by whatever programs
.I make
runs when making lint.
.PP
.I Error
knows about the error messages produced by:
.I make,
.I cc,
.I cpp,
.I ccom,
.I as,
.I ld,
.I lint,
.I pi,
.I pc,
.I f77,
and
.I DEC Western Research Modula-2.
.I Error
knows a standard format for error messages produced by
the language processors,
so is sensitive to changes in these formats.
For all languages except 
.I Pascal,
error messages are restricted to be on one line.
Some error messages refer to more than one line in more than
one files;
.I error
will duplicate the error message and insert it at
all of the places referenced.
.PP
.I Error
will do one of six things with error messages.
.TP 10
.I synchronize
Some language processors produce short errors describing
which file it is processing.
.I Error 
uses these to determine the file name for languages that
don't include the file name in each error message.
These synchronization messages are consumed entirely by
.I error.
.TP 10
.I discard
Error messages from
.I lint
that refer to one of the two
.I lint
libraries,
.I /usr/lib/llib-lc
and
.I /usr/lib/llib-port
are discarded,
to prevent accidently touching these libraries.
Again, these error messages are consumed entirely by
.I error.
.TP 10
.I nullify
Error messages from
.I lint
can be nullified if they refer to a specific function,
which is known to generate diagnostics which are not interesting.
Nullified error messages are not inserted into the source file,
but are written to the standard output.
The names of functions to ignore are taken from
either the file named
.I .errorrc
in the users's home directory, 
or from the file named by the
.B \-I
option.
If the file does not exist,
no error messages are nullified.
If the file does exist, there must be one function
name per line.
.TP 10
.I not file specific
Error messages that can't be intuited are grouped together,
and written to the standard output before any files are touched.
They will not be inserted into any source file.
.TP 10
.I file specific
Error message that refer to a specific file,
but to no specific line,
are written to the standard output when
that file is touched.
.TP 10
.I true errors
Error messages that can be intuited are candidates for
insertion into the file to which they refer.
.PP
Only true error messages are candidates for inserting into
the file they refer to.
Other error messages are consumed entirely by
.I error
or are written to the standard output.
.I Error
inserts the error messages into the source file on the line
preceding the line the language processor found in error.
Each error message is turned into a one line comment for the
language,
and is internally flagged
with the string ``###'' at
the beginning of the error,
and ``%%%'' at the end of the error.
This makes pattern searching for errors easier with an editor,
and allows the messages to be easily removed.
In addition, each error message contains the source line number
for the line the message refers to.
A reasonably formatted source program can be recompiled
with the error messages still in it,
without having the error messages themselves cause future errors.
For poorly formatted source programs in free format languages,
such as C or Pascal,
it is possible to insert a comment into another comment,
which can wreak havoc with a future compilation.
To avoid this, programs with comments and source
on the same line should be formatted
so that language statements appear before comments.
.PP
Options available with
.I error
are:
.TP 5
.B \-n
Do
.I not
touch any files; all error messages are sent to the
standard output.
.TP 5
.B \-q
The user is
.I queried
whether s/he wants to touch the file.
A ``y'' or ``n'' to the question is necessary to continue.
Absence of the
.B \-q
option implies that all referenced files
(except those referring to discarded error messages)
are to be touched.
.TP 5
.B \-v
After all files have been touched,
overlay the visual editor
.I vi
with it set up to edit all files touched,
and positioned in the first touched file at the first error.
If
.I vi 
can't be found, try
.I ex
or
.I ed
from standard places.
.TP 5
.B \-t
Take the following argument as a suffix list.
Files whose suffixes do not appear in the suffix list are not touched.
The suffix list is dot separated, and ``*'' wildcards work.
Thus the suffix list:
.IP
\&     ".c.y.foo*.h"
.IP
allows
.I error
to touch files ending with ``.c'', ``.y'', ``.foo*'' and ``.y''.
.TP 5
.B \-s
Print out 
.I statistics
regarding the error categorization.
Not too useful.
.PP
.I Error
catches interrupt and terminate signals,
and if in the insertion phase,
will orderly terminate what it is doing.
.SH AUTHOR
Robert Henry
.SH FILES
.ta 2i
~/.errorrc	function names to ignore for \fIlint\fP error messages
.br
/dev/tty	user's teletype
.SH BUGS
.PP
Opens the teletype directly to do user querying.
.PP
Source files with links make a new copy of the file with
only one link to it.
.PP
Changing a language processor's format of error messages
may cause 
.I error
to not understand the error message.
.PP
.I Error,
since it is purely mechanical,
will not filter out subsequent errors caused by `floodgating'
initiated by one syntactically trivial error.
Humans are still much better at discarding these related errors.
.PP
Pascal error messages belong after the lines affected
(error puts them before).  The alignment of the `\||\|' marking
the point of error is also disturbed by
.I error.
.PP
.I Error
was designed for work on CRT's at reasonably high speed.
It is less pleasant on slow speed terminals, and has never been
used on hardcopy terminals.
