.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)checknr.1	6.2 (Berkeley) 5/7/86
.\"
.TH CHECKNR 1 "May 7, 1986"
.UC 4
.SH NAME
checknr \- check nroff/troff files
.SH SYNOPSIS
.B checknr
[
.B \-s
] [
.B \-f
] [
.BR \-a ".x1.y1.x2.y2. ... .xn.yn"
] [
.BR \-c ".x1.x2.x3 ... .xn"
] [
\fIfile\fP ...
]
.SH DESCRIPTION
.I Checknr
checks a list of
.IR nroff (1)
or
.IR troff (1)
input files for certain kinds of errors
involving mismatched opening and closing delimiters
and unknown commands.
If no files are specified,
.I checknr
checks the standard input.
Delimeters checked are:
.IP (1)
Font changes using \efx ... \efP.
.IP (2)
Size changes using \esx ... \es0.
.IP (3)
Macros that come in open ... close forms, for example,
the .TS and .TE macros which must always come in pairs.
.PP
.I Checknr
knows about the
.IR ms (7)
and
.IR me (7)
macro packages.
.PP
Additional pairs of macros can be added to the list using the
.B \-a
option.
This must be followed by groups of six characters, each group defining
a pair of macros.
The six characters are
a period,
the first macro name,
another period,
and the second macro name.
For example, to define a pair .BS and .ES, use \-\fBa\fP.BS.ES
.PP
The
.B \-c
option defines commands which would otherwise be complained about
as undefined.
.PP
The
.B \-f
option requests
.I checknr
to ignore \ef font changes.
.PP
The
.B \-s
option requests
.I checknr
to ignore \es size changes.
.PP
.I Checknr
is intended to be used on documents that are prepared with
.I checknr
in mind, much the same as
.I lint.
It expects a certain document writing style for \ef and \es commands,
in that each \efx must be terminated with \efP and
each \esx must be terminated with \es0.
While it will work to directly go into the next font or explicitly
specify the original font or point size,
and many existing documents actually do this,
such a practice will produce complaints from
.I checknr.
Since it is probably better to use the \efP and \es0 forms anyway,
you should think of this as a contribution to your document
preparation style.
.SH SEE\ ALSO
nroff(1), troff(1), checkeq(1), ms(7), me(7)
.SH DIAGNOSTICS
Complaints about unmatched delimiters.
.br
Complaints about unrecognized commands.
.br
Various complaints about the syntax of commands.
.SH BUGS
There is no way to define a 1 character macro name using
.BR \-a .
.br
Does not correctly recognize certain reasonable constructs,
such as conditionals.
