.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)apply.1	6.1 (Berkeley) 4/29/85
.\"
.TH APPLY 1 "April 29, 1985"
.UC 5
.SH NAME
apply \- apply a command to a set of arguments
.SH SYNOPSIS
.B apply
[
.B \-a\fIc\fP
] [
.B \-\fIn\fP
] command args ...
.SH DESCRIPTION
.I Apply
runs the named
.I command
on each
argument
.I arg
in turn.
Normally arguments are chosen singly; the optional number
.I n
specifies the number of arguments to be passed to
.I command.
If
.I n
is zero,
.I command
is run without arguments once for each
.I arg.
Character sequences of the form %\fId\fP
in
.I command,
where
.I d
is a digit from 1 to 9,
are replaced by the
\fId\fP'th following unused
.I arg.
If any such sequences occur,
.I n
is ignored,
and the number of arguments passed to
.I command
is the maximum value of
.I d
in
.I command.
The character `%' may be changed by the
.B \-a
option.
.PP
Examples:
.RS
apply echo *
.RE
is similar to ls(1);
.RS
apply \-2 cmp a1 b1 a2 b2 ...
.RE
compares the `a' files to the `b' files;
.RS
apply \-0 who 1 2 3 4 5
.RE
runs who(1) 5 times; and
.RS
apply \(aaln %1 /usr/joe\(aa *
.RE
links all files in the current directory to the directory /usr/joe.
.SH "SEE ALSO"
sh(1)
.SH AUTHOR
Rob Pike
.SH BUGS
Shell metacharacters in
.I command
may have bizarre effects; it is best to enclose complicated
commands in single quotes \(aa\ \(aa.
.sp
There is no way to pass a literal `%2' if `%' is the
argument expansion character.
