.\"	@(#)binmail.1	6.1 (Berkeley) 4/29/85
.\"
.TH BINMAIL 1 "April 29, 1985"
.AT 3
.SH NAME
binmail \- send or receive mail among users
.SH SYNOPSIS
.B /bin/mail
[
.B +
] [
.B \-i
] [ person ] ...
.br
.B /bin/mail
.B "[ + ]"
[
.B \-i
]
.B \-f
file
.LP
.SH DESCRIPTION
Note: This is the old version 7 UNIX system mail program.  The default
.I mail
command is described in
.IR Mail (1),
and its binary is in the directory
.IR /usr/ucb .
.PP
.I mail
with no argument prints a user's mail, message-by-message,
in last-in, first-out order; the optional argument
.B +
displays the mail messages in first-in, first-out order.
For each message, it reads a line from the standard input
to direct disposition of the message.
.TP
newline
Go on to next message.
.TP
d
Delete message and go on to the next.
.TP
p
Print message again.
.TP
\-
Go back to previous message.
.TP
.RI "s [" " file " "] ..."
Save the message in the named
.I files
(`mbox' default).
.TP
.RI "w [" " file " "] ..."
Save the message, without a header, in the named
.I files
(`mbox' default).
.TP
.RI "m [" " person " "] ..."
Mail the message to the named
.I persons
(yourself is default).
.TP
EOT (control-D)
Put unexamined mail back in the mailbox and stop.
.TP
q
Same as EOT.
.TP
.RI ! command
Escape to the Shell to do
.IR command .
.TP
*
Print a command summary.
.PP
An interrupt normally terminates the 
.I mail
command; the mail file is unchanged.  The optional argument
.B \(mii
tells
.I mail
to continue after interrupts.
.PP
When
.I persons
are named,
.I mail
takes the standard input up to an end-of-file (or a line with just `.')
and adds it to each
.I person's
`mail' file.  The message is preceded by the sender's name and a postmark.
Lines that look like postmarks are prepended with `>'.  A
.I person
is usually a user name recognized by
.IR  login (1).
To denote a recipient on a remote system, prefix 
.I person
by the system name and exclamation mark (see
.IR uucp (1C)).
.PP
The
.B \-f
option causes the named file, for example, `mbox',
to be printed as if it were the mail file.
.PP
When a user logs in he is informed of the presence of mail.
.SH FILES
.ta \w'/usr/spool/mail/*.lock 'u
/etc/passwd	to identify sender and locate persons
.br
.li
/usr/spool/mail/*	incoming mail for user *
.br
mbox		saved mail
.br
/tmp/ma*	temp file
.br
/usr/spool/mail/*.lock	lock for mail directory
.br
dead.letter	unmailable text
.br
.SH "SEE ALSO"
Mail(1), write(1), uucp(1C), uux(1C), xsend(1), sendmail(8)
.SH BUGS
Race conditions sometimes result in a failure to remove a lock file.
.PP
Normally anybody can read your mail, unless it is sent by
.IR xsend (1).
An installation can overcome this by making
.I mail
a set-user-id command that owns the mail directory.
