.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)lprm.1	6.1 (Berkeley) 4/29/85
.\"
.TH LPRM 1 "April 29, 1985"
.UC 5
.SH NAME
lprm \- remove jobs from the line printer spooling queue
.SH SYNOPSIS
.B lprm
[
.BI \-P printer
] [
.B \-
] [
job # ...
] [
user ...
]
.SH DESCRIPTION
.I Lprm
will remove a job, or jobs, from a printer's spool queue.
Since the spooling directory is protected from users, using
.I lprm
is normally the only method by which a user may remove a job.
.PP
.I Lprm
without any arguments will delete the currently active job if it is
owned by the user who invoked
.IR lprm .
.PP
If the
.B \-
flag is specified, 
.I lprm
will remove all jobs which a user
owns.  If the super-user employs this flag, the spool queue will
be emptied entirely. The owner is determined by the user's login name
and host name on the machine where the
.I lpr
command was invoked.
.PP
Specifying a user's name, or list of user names, will cause
.I lprm
to attempt to remove any jobs queued belonging to that user
(or users).  This form of invoking
.I lprm
is useful only to the super-user.
.PP
A user may dequeue an individual job by specifying its job number.
This number may be obtained from the
.IR lpq (1)
program, e.g.
.PP
.nf
.in +0.5i
.ta \w'k0-k9  'u +\w'Type  'u +\w'"/usr/lib/lpd"  'u
.ta \w'1st: 'u +\w'(standard input)      		'u
% lpq \-l

1st: ken	[job #013ucbarpa]
	(standard input)	100 bytes
% lprm 13
.in -0.5i
.fi
.PP
.I Lprm
will announce the names of any files it removes and is silent if
there are no jobs in the queue which match the request list.
.PP
.I Lprm
will kill off an active daemon, if necessary, before removing
any spooling files.  If a daemon is killed, a new one is
automatically restarted upon completion of file removals.
.PP
The
.B \-P
option may be usd to specify the queue associated with a specific
printer (otherwise the default printer, or the value of the PRINTER
variable in the environment is used).
.SH FILES
.nf
.ta \w'/usr/spool/*/lock   'u
/etc/printcap	printer characteristics file
/usr/spool/*	spooling directories
/usr/spool/*/lock	lock file used to obtain the pid of the current
	daemon and the job number of the currently active job
.fi
.SH "SEE ALSO"
lpr(1),
lpq(1),
lpd(8)
.SH DIAGNOSTICS
``Permission denied" if the user tries to remove files other than his
own.
.SH BUGS
Since there are race conditions possible in the update of the lock file,
the currently active job may be incorrectly identified.
