.\" Copyright (c) 1987 Regents of the University of California.
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms are permitted
.\" provided that the above copyright notice and this paragraph are
.\" duplicated in all such forms and that any documentation,
.\" advertising materials, and other materials related to such
.\" distribution and use acknowledge that the software was developed
.\" by the University of California, Berkeley.  The name of the
.\" University may not be used to endorse or promote products derived
.\" from this software without specific prior written permission.
.\" THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
.\" IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
.\" WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
.\"
.\"	@(#)dm.8	5.6 (Berkeley) 7/9/88
.\"
.TH DM 8 "July 9, 1988"
.UC 8
.SH NAME
dm \- dungeon master
.SH SYNOPSIS
.B ln -s dm game
.SH DESCRIPTION
\fIDm\fP is a program used to regulate game playing.  \fIDm\fP expects to
be invoked with the name of a game that a user wishes to play.  This is
done by creating symbolic links to \fIdm\fP, in \fI/usr/games\fP, for all
of the regulated games.  The actual binaries for these games should be
placed in a ``hidden'' directory, \fI/usr/games/hide\fP, that may only be
accessed by the \fIdm\fP program.  \fIDm\fP determines if the requested
game is available and, if so, runs it.  The file \fI/usr/games/dm.config\fP
controls the conditions under which games may be run.  For remotely mounted
file systems, a machine name may be appended to the config file name,
i.e. the machine ``rip.berkeley.edu'' will use the file \fIdm.config.rip\fP
if it is present, otherwise it will use \fIdm.config\fP.
.PP
The file \fI/usr/games/nogames\fP may be used to ``turn off'' game
playing.  If the file exists, no game playing is allowed; the contents
of the file will be displayed to any user requesting a game.
.SH FILES
.nf
.ta \w'/usr/games/dm.config 'u
/usr/games/dm.config	- configuration file
/usr/games/hide		- directory of ``real'' binaries
/usr/games/nogames	- turns off game playing
.SH SEE ALSO
dm.config(5)
.SH BUGS
Two problems result from \fIdm\fP running the games setuid ``games''.
First, all games that allow users to run UNIX commands should carefully
set both the real and effective user id's immediately before executing
those commands.  Probably more important is that \fIdm\fP never be setuid
anything but ``games'' so that compromising a game will result only in
the user's ability to play games at will.  Secondly, games which previously
had no reason to run setuid and which accessed user files may have to
be modified.
