.\" Copyright (c) 1985 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)battlestar.6	6.2 (Berkeley) 5/6/86
.\"
.TH BATTLESTAR 6 "May 6, 1986"
.UC 6
.SH NAME
battlestar \- a tropical adventure game
.SH SYNOPSIS
.B battlestar
[
.B -r (recover a saved game)
]
.br
.fi
.SH DESCRIPTION
.I Battlestar
is an adventure game in the classic style.  However, It's slightly less
of a
puzzle and more a game of exploration.  There are a few magical words
in the game, but on the whole, simple English
should suffice to make one's desires understandable to the parser.
.SH "THE SETTING"
In the days before the darkness came, when battlestars ruled the
heavens...
.br
.nf

		Three He made and gave them to His daughters,
		Beautiful nymphs, the goddesses of the waters.
		One to bring good luck and simple feats of wonder,
		Two to wash the lands and churn the waves asunder,
		Three to rule the world and purge the skies with thunder.
		
.fi
.PP
In those times great wizards were known and their powers were beyond
belief.  They could take any object from thin air, and, uttering the
word `su' could disappear.
.PP
In those times men were known for their lust of gold and desire to
wear fine weapons.  Swords and coats of mail were fashioned that could
withstand a laser blast.
.PP
But when the darkness fell, the rightful reigns were toppled.  Swords
and helms and heads of state went rolling across the grass.  The entire
fleet of battlestars was reduced to a single ship.
.SH "SAMPLE COMMANDS"
.nf

	take	---	take an object
	drop	---	drop an object

	wear	---	wear an object you are holding
	draw	---	carry an object you are wearing

	puton	---	take an object and wear it
	take off --	draw an object and drop it

	throw  <object> <direction>

	!	<shell esc>
	
.fi
.SH "IMPLIED OBJECTS"
.nf

	>-: take watermelon
	watermelon:
	Taken.
	>-: eat
	watermelon:
	Eaten.
	>-: take knife and sword and apple, drop all
	knife:
	Taken.
	broadsword:
	Taken.
	apple:
	Taken.
	knife:
	Dropped.
	broadsword:
	Dropped.
	apple:
	Dropped.
	>-: get
	knife:
	Taken.
	
.fi
.PP
Notice that the "shadow" of the next word stays around if you
want to take advantage of it.  That is, saying "take knife" and then
"drop"
will drop the knife you just took.
.SH "SCORE & INVEN"
The two commands "score" and "inven" will print out your current status
in
the game.
.SH "SAVING A GAME"
The command "save" will save your game in a file called "Bstar."  You
can
recover a saved game by using the "-r" option when you start up the
game.
.SH DIRECTIONS
The compass directions N, S, E, and W can be used if you have a compass.
If you don't have a compass, you'll have to say R, L, A, or B, which
stand for
Right, Left, Ahead, and Back.  Directions printed in room descriptions
are
always printed in R, L, A, & B relative directions.
.SH HISTORY
I wrote Battlestar in 1979 in order to experiment with the niceties of
the C Language.
Most interesting things that happen in the game are hardwired into the
code, so don't 
send me any hate mail about it!  Instead, enjoy art for art's sake!
.SH AUTHOR
David Riggle
.SH "INSPIRATION & ASSISTANCE"
Chris Guthrie
.br
Peter Da Silva
.br
Kevin Brown
.br
Edward Wang
.br
Ken Arnold & Company
.SH BUGS
Countless.
.SH "FAN MAIL"
Send to edward%ucbarpa@Berkeley.arpa, chris%ucbcory@berkeley.arpa,
riggle.pa@xerox.arpa.
